/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen;

import aurora.plugin.source.gen.IDGenerator;
import aurora.plugin.source.gen.ModelMapParser;
import aurora.plugin.source.gen.SourceGenManager;
import aurora.plugin.source.gen.builders.ISourceBuilder;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import uncertain.composite.CompositeMap;
import uncertain.composite.IterationHandle;

public class BuilderSession {
    private SourceGenManager sourceGenManager;
    private StringBuilder eventResult = new StringBuilder();
    private CompositeMap model;
    private CompositeMap context;
    private CompositeMap current_context;
    private CompositeMap current_model;
    private Map<String, Object> configMap;

    public BuilderSession(SourceGenManager sourceGenManager) {
        this.sourceGenManager = sourceGenManager;
    }

    public SourceGenManager getSourceGenManager() {
        return this.sourceGenManager;
    }

    public void setSourceGenManager(SourceGenManager sourceGenManager) {
        this.sourceGenManager = sourceGenManager;
    }

    public CompositeMap getContext() {
        return this.context;
    }

    public void setContext(CompositeMap context) {
        this.context = context;
    }

    public CompositeMap getModel() {
        return this.model;
    }

    public void setModel(CompositeMap model) {
        this.model = model;
    }

    public CompositeMap getCurrentModel() {
        return this.current_model;
    }

    public void setCurrentModel(CompositeMap current_model) {
        this.current_model = current_model;
    }

    public void appendContext(CompositeMap context) {
        CompositeMap parent = this.getCurrentModel().getParent();
        if (parent == null) {
            this.context = context;
        } else {
            CompositeMap parentContext;
            String modelId = parent.getString((Object)"markid", "");
            if (!"".equals(modelId) && (parentContext = this.lookUpParentContext(modelId)) != null) {
                parentContext.addChild(context);
            }
        }
        this.setCurrentContext(context);
    }

    private CompositeMap lookUpParentContext(final String modelId) {
        String c_id;
        if (this.current_context != null && modelId.equals(c_id = this.current_context.getString((Object)"markid", ""))) {
            return this.current_context;
        }
        final CompositeMap[] maps = new CompositeMap[1];
        this.context.iterate(new IterationHandle(){

            public int process(CompositeMap map) {
                String c_id = map.getString((Object)"markid", "");
                if (modelId.equals(c_id)) {
                    maps[0] = map;
                    return 2;
                }
                return 0;
            }
        }, true);
        return maps[0];
    }

    public CompositeMap getCurrentContext() {
        return this.current_context;
    }

    public void setCurrentContext(CompositeMap current_context) {
        this.current_context = current_context;
    }

    public String buildComponent(CompositeMap model) {
        return this.sourceGenManager.buildComponent(this, model);
    }

    public void appendResultln(String result) {
        if ("".equals(result)) {
            return;
        }
        this.getEventResult().append(result);
        this.getEventResult().append("\n");
    }

    public void appendResult(String result) {
        if ("".equals(result)) {
            return;
        }
        this.getEventResult().append(result);
    }

    public void clearEventResult() {
        this.setEventResult(new StringBuilder());
    }

    public StringBuilder getEventResult() {
        return this.eventResult;
    }

    public void setEventResult(StringBuilder eventResult) {
        this.eventResult = eventResult;
    }

    public BuilderSession getCopy() {
        BuilderSession bs = new BuilderSession(this.sourceGenManager);
        bs.setContext(this.getContext());
        bs.setCurrentContext(this.getCurrentContext());
        bs.setCurrentModel(this.getCurrentModel());
        bs.setModel(this.getModel());
        bs.configMap = this.configMap;
        return bs;
    }

    public IDGenerator getIDGenerator() {
        return this.sourceGenManager.getIDGenerator();
    }

    public Object execActionEvent(String event, CompositeMap context) {
        StringBuilder sb = new StringBuilder();
        Collection<String> values = this.sourceGenManager.getBuilders().values();
        for (String clazz : values) {
            ISourceBuilder newInstance = this.sourceGenManager.createNewInstance(clazz);
            if (newInstance == null) continue;
            BuilderSession bs = this.getCopy();
            newInstance.actionEvent(event, bs);
            sb.append((CharSequence)bs.getEventResult());
        }
        return sb.toString();
    }

    public ModelMapParser createModelMapParser(CompositeMap model) {
        return this.sourceGenManager.createModelMapParser(model);
    }

    public void addConfig(String key, Object value) {
        if (this.configMap == null) {
            this.configMap = new HashMap<String, Object>();
        }
        this.configMap.put(key, value);
    }

    public Map<String, String> defineConfig() {
        String property = System.getProperty("user.name");
        String format = DateFormat.getDateInstance().format(new Date());
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("encoding", "UTF-8");
        config.put("date", format);
        config.put("author", property);
        config.put("revision", "1.0");
        config.put("copyright", "add by aurora_ide team");
        config.put("template_type", this.getModel().getString((Object)"template_type", ""));
        if (this.configMap != null) {
            Set<String> keySet = this.configMap.keySet();
            for (String k : keySet) {
                config.put(k, "" + this.configMap.get(k));
            }
        }
        return config;
    }

    public Object getConfig(String key) {
        if (this.configMap != null) {
            return this.configMap.get(key);
        }
        return null;
    }
}

