/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.script;

import aurora.javascript.EcmaError;
import aurora.javascript.EvaluatorException;
import aurora.javascript.JavaScriptException;
import aurora.javascript.RhinoException;
import aurora.plugin.script.engine.InterruptException;
import aurora.plugin.script.engine.ScriptRunner;
import java.io.File;
import javax.script.ScriptException;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class ServerScript
extends AbstractEntry {
    String jsimport;
    String exp = null;
    String resultpath = null;
    String cdata = null;
    String optimizeLevel = null;
    int lineno = -1;
    private IObjectRegistry registry;

    public ServerScript(OCManager oc_manager, IObjectRegistry registry) {
        this.registry = registry;
    }

    public String getResultpath() {
        return this.resultpath;
    }

    public void setResultpath(String resultpath) {
        this.resultpath = resultpath;
    }

    public String getExp() {
        return this.exp;
    }

    public void setExp(String exp) {
        this.exp = exp;
    }

    public String getImport() {
        return this.jsimport;
    }

    public void setImport(String import1) {
        this.jsimport = import1;
    }

    public String getOptimizeLevel() {
        return this.optimizeLevel;
    }

    public void setOptimizeLevel(String optimizeLevel) {
        this.optimizeLevel = optimizeLevel;
    }

    public void run(ProcedureRunner runner) throws Exception {
        long t = System.nanoTime();
        CompositeMap context = runner.getContext();
        if (this.exp == null) {
            this.exp = this.cdata;
        }
        try {
            ScriptRunner sr = new ScriptRunner(this.exp, context, this.registry);
            sr.setImport(this.jsimport);
            sr.setProcedureRunner(runner);
            sr.setOptimizeLevel(this.optimizeLevel);
            Object res = sr.run();
            if (this.resultpath != null) {
                context.putObject(this.resultpath, res, true);
            }
        }
        catch (InterruptException ie) {
            throw ie;
        }
        catch (RhinoException re) {
            Class<?> clz = ((Object)((Object)re)).getClass();
            if (clz == EcmaError.class || clz == JavaScriptException.class || clz == EvaluatorException.class) {
                String fileName = new File(this.source).getName();
                String srcName = re.sourceName();
                String source_ = fileName;
                int line = re.lineNumber();
                boolean isInLine = "<Unknown source>".equals(srcName);
                if (isInLine) {
                    line += this.lineno - 1;
                } else {
                    source_ = source_ + " --> " + srcName;
                }
                StringBuilder sb = new StringBuilder(500);
                sb.append("source  : " + source_ + "\n");
                sb.append("lineno  : " + line + "\n");
                sb.append("line src: " + re.lineSource() + "\n");
                Throwable ee = this.getRootCause(re);
                sb.append("message : " + ee.getMessage());
                System.err.println(sb.toString());
                ScriptException se = new ScriptException(ee.getMessage(), source_, line);
                ee.printStackTrace();
                throw se;
            }
            re.printStackTrace();
            throw (Exception)this.getRootCause(re);
        }
    }

    private Throwable getRootCause(Throwable thr) {
        while (thr.getCause() != null) {
            thr = thr.getCause();
        }
        return thr;
    }

    public void beginConfigure(CompositeMap config) {
        super.beginConfigure(config);
        this.lineno = config.getLocationNotNull().getStartLine();
        this.cdata = config.getText();
        if (this.cdata == null) {
            this.cdata = "";
        }
    }
}

