/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap.sync.idoc;

import aurora.plugin.sap.ISapConfig;
import aurora.plugin.sap.sync.idoc.DatabaseTool;
import aurora.plugin.sap.sync.idoc.DestinationProvider;
import aurora.plugin.sap.sync.idoc.IDocServer;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.sql.DataSource;
import uncertain.core.ILifeCycle;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.util.resource.ILocatable;

public class IDocServerManager
extends AbstractLocatableObject
implements ILifeCycle {
    public static final String PLUGIN = IDocServerManager.class.getCanonicalName();
    public static final String SERVER_NAME_SEPARATOR = ",";
    public static final String AURORA_IDOC_PLUGIN_VERSION = "2.1";
    private IObjectRegistry registry;
    private String serverNameList;
    private String idocFileDir;
    private boolean keepIdocFile = true;
    private boolean interfaceEnabledFlag = true;
    private boolean enabledJCo = true;
    private int reconnectTime = 60000;
    private int maxReconnectTime = 3600000;
    private boolean debug = false;
    private List<IDocServer> idocServerList = new LinkedList<IDocServer>();
    private ILogger logger;
    private DataSource datasource;
    private DestinationProvider destinationProvider;
    private boolean running = true;

    public IDocServerManager(IObjectRegistry registry) {
        this.registry = registry;
    }

    private void initParameters() {
        this.logger = LoggingContext.getLogger((String)PLUGIN, (IObjectRegistry)this.registry);
        this.logger.info("Aurora IDoc Plugin Version: 2.1");
        this.datasource = (DataSource)this.registry.getInstanceOfType(DataSource.class);
        if (this.datasource == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, DataSource.class, (String)((Object)((Object)this)).getClass().getCanonicalName());
        }
        if (this.serverNameList == null) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"serverNameList");
        }
        if (this.idocFileDir == null) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"idocFileDir");
        }
        File idocDir = new File(this.idocFileDir);
        if (!idocDir.exists()) {
            throw BuiltinExceptionFactory.createRequiredFileNotFound((String)this.idocFileDir);
        }
    }

    public boolean startup() {
        this.initParameters();
        if (this.isEnabledJCo()) {
            this.destinationProvider = new DestinationProvider();
            this.registry.registerInstance(ISapConfig.class, (Object)this.destinationProvider);
        }
        String[] servers = this.serverNameList.split(SERVER_NAME_SEPARATOR);
        for (int i = 0; i < servers.length; ++i) {
            String serverName = servers[i];
            IDocServer server = new IDocServer(this, serverName);
            server.startup();
            this.idocServerList.add(server);
        }
        return true;
    }

    public IObjectRegistry getRegistry() {
        return this.registry;
    }

    public DatabaseTool getDatabaseTool() throws SQLException {
        Connection connection = this.datasource.getConnection();
        DatabaseTool dbTool = new DatabaseTool(connection, this.logger);
        return dbTool;
    }

    public void closeDatabaseTool(DatabaseTool databaseManager) {
        if (databaseManager != null) {
            databaseManager.close();
        }
    }

    public void shutdown() {
        this.running = false;
        if (this.idocServerList != null && !this.idocServerList.isEmpty()) {
            for (IDocServer server : this.idocServerList) {
                try {
                    server.shutdown();
                }
                catch (Throwable e) {
                    this.logger.log(Level.SEVERE, "shutdown server " + server.getServerName() + " failed!", e);
                }
            }
            this.idocServerList = null;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public String getServerNameList() {
        return this.serverNameList;
    }

    public void setServerNameList(String serverNameList) {
        this.serverNameList = serverNameList;
    }

    public String getIdocFileDir() {
        return this.idocFileDir;
    }

    public void setIdocFileDir(String idocFileDir) {
        this.idocFileDir = idocFileDir;
    }

    public boolean isKeepIdocFile() {
        return this.keepIdocFile;
    }

    public boolean getKeepIdocFile() {
        return this.keepIdocFile;
    }

    public void setKeepIdocFile(boolean keepIdocFile) {
        this.keepIdocFile = keepIdocFile;
    }

    public boolean isInterfaceEnabledFlag() {
        return this.interfaceEnabledFlag;
    }

    public boolean getInterfaceEnabledFlag() {
        return this.interfaceEnabledFlag;
    }

    public void setInterfaceEnabledFlag(boolean interfaceEnabledFlag) {
        this.interfaceEnabledFlag = interfaceEnabledFlag;
    }

    public int getReconnectTime() {
        return this.reconnectTime;
    }

    public void setReconnectTime(int reconnectTime) {
        this.reconnectTime = reconnectTime;
    }

    public int getMaxReconnectTime() {
        return this.maxReconnectTime;
    }

    public void setMaxReconnectTime(int maxReconnectTime) {
        this.maxReconnectTime = maxReconnectTime;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    public boolean isEnabledJCo() {
        return this.enabledJCo;
    }

    public boolean getEnabledJCo() {
        return this.enabledJCo;
    }

    public void setEnabledJCo(boolean enabledJCo) {
        this.enabledJCo = enabledJCo;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void addDestination(String destinationName) {
        if (this.destinationProvider != null) {
            this.destinationProvider.addDestination(destinationName);
        }
    }
}

