/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.poi;

import aurora.i18n.ILocalizedMessageProvider;
import aurora.plugin.export.MergedHeader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.composite.transform.GroupTransformer;

public class ExcelExportImpl {
    public static final String KEY_DATA_TYPE = "datatype";
    public static final String KEY_DATA_TYPE_NUMBER = "Number";
    public static final String KEY_DATA_TYPE_STRING = "String";
    public final String KEY_DATA_FORMAT = "dataFormat";
    ILocalizedMessageProvider localMsgProvider;
    Workbook wb;
    CompositeMap dataModel;
    CompositeMap context;
    CompositeMap mergeColumn;
    CompositeMap headerConfig;
    List<CompositeMap> headerList;
    final int numberLimit = 65535;
    int headLevel;
    CellStyle headstyle;
    CellStyle bodystyle;
    Map<Integer, CellStyle> styleMap = new HashMap<Integer, CellStyle>();
    Sheet sheet;
    CreationHelper creationHelper;

    public ExcelExportImpl(ILocalizedMessageProvider localMsgProvider) {
        this.localMsgProvider = localMsgProvider;
    }

    public void createExcel(CompositeMap dataModel, CompositeMap column_config, OutputStream os, CompositeMap merge_column) throws Exception {
        this.context = dataModel.getRoot();
        if (merge_column != null) {
            CompositeMap groupConfig = null;
            Iterator it = merge_column.getChildIterator();
            if (it != null) {
                groupConfig = new CompositeMap();
                while (it.hasNext()) {
                    CompositeMap record = (CompositeMap)it.next();
                    CompositeMap configRecord = new CompositeMap();
                    configRecord.put((Object)"group_key_fields", (Object)record.getString((Object)"name"));
                    configRecord.put((Object)"record_name", (Object)record.getString((Object)"name"));
                    groupConfig.addChild(configRecord);
                }
            }
            this.mergeColumn = groupConfig;
            this.dataModel = GroupTransformer.transformByConfig((CompositeMap)dataModel, (CompositeMap)this.mergeColumn);
        } else {
            this.dataModel = dataModel;
        }
        this.headerConfig = new MergedHeader((CompositeMap)column_config).conifg;
        this.wb = new HSSFWorkbook();
        this.creationHelper = this.wb.getCreationHelper();
        this.setCellStyle(this.wb);
        this.createExcel();
        try {
            this.wb.write(os);
            os.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            os.close();
        }
    }

    void setCellStyle(Workbook wb) {
        this.headstyle = wb.createCellStyle();
        Font headfont = wb.createFont();
        headfont.setFontName("\u5b8b\u4f53");
        headfont.setBoldweight((short)700);
        headfont.setFontHeightInPoints((short)12);
        this.headstyle.setFont(headfont);
        this.headstyle.setAlignment((short)2);
        this.headstyle.setVerticalAlignment((short)1);
        this.bodystyle = wb.createCellStyle();
        this.bodystyle.setVerticalAlignment((short)1);
        Font bodyfont = wb.createFont();
        bodyfont.setFontName("\u5b8b\u4f53");
        bodyfont.setFontHeightInPoints((short)12);
        this.bodystyle.setFont(bodyfont);
    }

    short getExcelAlign(String align) {
        int excelAlign = 0;
        if (align == null || "left".equalsIgnoreCase(align)) {
            excelAlign = 1;
        } else if ("right".equalsIgnoreCase(align)) {
            excelAlign = 3;
        } else if ("center".equalsIgnoreCase(align)) {
            excelAlign = 2;
        }
        return (short)excelAlign;
    }

    void createExcel() {
        this.sheet = null;
        Iterator iterator = this.dataModel.getChildIterator();
        this.headLevel = 0;
        this.sheet = this.wb.createSheet();
        this.createExcelHeader(this.sheet);
        this.sheet.createFreezePane(0, ++this.headLevel);
        if (iterator != null) {
            if (this.mergeColumn != null) {
                this.createExcelTableMerge(this.sheet, this.dataModel);
            } else {
                this.createExcelTable(this.sheet, iterator);
            }
        }
    }

    void createExcelHeader(Sheet sheet) {
        Row header = sheet.createRow(0);
        this.headerList = new LinkedList<CompositeMap>();
        this.generatExcelHead(this.headerConfig, sheet, header, -1);
        this.createBodyStyle();
    }

    void createBodyStyle() {
        int length = this.headerList.size();
        for (int i = 0; i < length; ++i) {
            CompositeMap record = this.headerList.get(i);
            CellStyle style = this.wb.createCellStyle();
            style.cloneStyleFrom(this.bodystyle);
            style.setAlignment(this.getExcelAlign(record.getString((Object)"align")));
            if (record.getString((Object)this.KEY_DATA_FORMAT) != null) {
                style.setDataFormat(this.wb.createDataFormat().getFormat(record.getString((Object)this.KEY_DATA_FORMAT)));
            }
            this.styleMap.put(i, style);
            int width = record.getInt((Object)"width", 100);
            this.sheet.setColumnWidth(i, (int)((short)(width * 42)));
        }
    }

    void createExcelTableMerge(Sheet sheet, CompositeMap record) {
        int mergeCount = 0;
        int col = 0;
        Iterator iterator = record.getChildIterator();
        while (iterator.hasNext()) {
            CompositeMap childRecord = (CompositeMap)iterator.next();
            Iterator it = childRecord.getChildIterator();
            if (it != null) {
                this.createExcelTableMerge(sheet, childRecord);
                mergeCount = childRecord.getInt((Object)"_count");
                String colName = childRecord.getName();
                int l = this.headerList.size();
                for (int i = 0; i < l; ++i) {
                    CompositeMap head = this.headerList.get(i);
                    if (!colName.equals(head.get((Object)"name"))) continue;
                    col = i;
                    break;
                }
                CellRangeAddress range = new CellRangeAddress(this.headLevel - mergeCount, this.headLevel - 1, col, col);
                sheet.addMergedRegion(range);
                int count = record.getInt((Object)"_count", 0);
                record.put((Object)"_count", (Object)(count + mergeCount));
                continue;
            }
            this.createExcelTable(sheet, record.getChildIterator());
            record.put((Object)"_count", (Object)record.getChilds().size());
            break;
        }
    }

    void createExcelTable(Sheet sheet, Iterator iterator) {
        int col = 0;
        while (iterator.hasNext() && this.headLevel != 65535) {
            CompositeMap object = (CompositeMap)iterator.next();
            if (!"record".equals(object.getName())) continue;
            Row row = sheet.getRow(this.headLevel);
            if (row == null) {
                row = sheet.createRow(this.headLevel);
            }
            for (CompositeMap record : this.headerList) {
                CellStyle style = this.styleMap.get(col);
                Cell cell = row.createCell(col);
                cell.setCellStyle(style);
                this.setCellValue(cell, object, record);
                ++col;
            }
            col = 0;
            ++this.headLevel;
        }
    }

    void setCellValue(Cell cell, CompositeMap record, CompositeMap config) {
        Object value = record.get((Object)config.getString((Object)"name"));
        if (value == null) {
            return;
        }
        if (config.getString((Object)KEY_DATA_TYPE) != null) {
            if (KEY_DATA_TYPE_STRING.equalsIgnoreCase(config.getString((Object)KEY_DATA_TYPE))) {
                cell.setCellValue(this.creationHelper.createRichTextString(value.toString()));
            } else {
                try {
                    cell.setCellValue(Double.parseDouble(value.toString()));
                }
                catch (Exception e) {
                    cell.setCellValue(this.creationHelper.createRichTextString(value.toString()));
                }
            }
        } else if (value instanceof String) {
            cell.setCellValue(this.creationHelper.createRichTextString(value.toString()));
        } else if (value instanceof Number) {
            cell.setCellValue(Double.parseDouble(value.toString()));
        } else if (value != null) {
            cell.setCellValue(this.creationHelper.createRichTextString(value.toString()));
        }
    }

    String getPrompt(String key) {
        String promptString = this.localMsgProvider.getMessage(key);
        promptString = promptString == null ? key : promptString;
        promptString = TextParser.parse((String)promptString, (CompositeMap)this.context);
        return promptString;
    }

    int generatExcelHead(CompositeMap columnConfigs, Sheet sheet, Row header, int col) {
        int rownum = header.getRowNum();
        Iterator iterator = columnConfigs.getChildIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                CellRangeAddress range;
                Iterator it;
                CompositeMap record = (CompositeMap)iterator.next();
                String title = this.getPrompt(record.getString((Object)"prompt"));
                Cell cell = header.createCell(++col);
                cell.setCellValue(this.creationHelper.createRichTextString(title));
                cell.setCellStyle(this.headstyle);
                int level = record.getInt((Object)"_level", 0);
                if (this.headLevel == 0) {
                    this.headLevel = level;
                }
                if ((it = record.getChildIterator()) != null) {
                    Long span = (Long)record.getObject("column/@_count");
                    range = new CellRangeAddress(rownum, rownum, col, col + span.intValue() - 1);
                    sheet.addMergedRegion(range);
                    while (it.hasNext()) {
                        Row nextRow = sheet.getRow(rownum + 1);
                        if (nextRow == null) {
                            nextRow = sheet.createRow(rownum + 1);
                        }
                        CompositeMap object = (CompositeMap)it.next();
                        col = this.generatExcelHead(object, sheet, nextRow, col - 1);
                    }
                    continue;
                }
                this.headerList.add(record);
                if (level == 0) continue;
                range = new CellRangeAddress(rownum, rownum + level, col, col);
                sheet.addMergedRegion(range);
            }
        }
        return col;
    }
}

