/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.mail;

import aurora.database.service.SqlServiceContext;
import aurora.plugin.mail.Attachment;
import aurora.plugin.mail.IMailServerConfig;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IConfigurable;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;
import uncertain.util.resource.ILocatable;

public class SendMail
extends AbstractEntry
implements IConfigurable {
    private IObjectRegistry registry;
    private String title;
    private String content;
    private String smtpServer;
    private String password;
    private String userName;
    private String to;
    private String cc;
    private String from;
    private String port;
    private Boolean auth = null;
    private Attachment[] attachments;

    public SendMail(IObjectRegistry registry) {
        this.registry = registry;
    }

    public void run(ProcedureRunner runner) throws Exception {
        IMailServerConfig mailConfig = (IMailServerConfig)this.registry.getInstanceOfType(IMailServerConfig.class);
        if (mailConfig != null) {
            this.smtpServer = this.smtpServer != null ? this.smtpServer : mailConfig.getSmtpServer();
            this.userName = this.userName != null ? this.userName : mailConfig.getUserName();
            this.password = this.password != null ? this.password : mailConfig.getPassword();
            this.from = this.from != null ? this.from : mailConfig.getFrom();
            this.port = this.port != null ? this.port : mailConfig.getPort();
            this.auth = this.auth != null ? this.auth.booleanValue() : mailConfig.getAuth();
        }
        if (this.port == null) {
            this.port = "25";
        }
        if (this.auth == null) {
            this.auth = false;
        }
        ILogger logger = LoggingContext.getLogger((CompositeMap)runner.getContext(), (String)((Object)((Object)this)).getClass().getCanonicalName());
        logger.config("Accept to E-mail message, began sendind mail operation");
        CompositeMap map = runner.getContext();
        SqlServiceContext svcContext = SqlServiceContext.createSqlServiceContext((CompositeMap)map);
        CompositeMap current_param = svcContext.getCurrentParameter();
        this.password = TextParser.parse((String)this.password, (CompositeMap)current_param);
        this.smtpServer = TextParser.parse((String)this.smtpServer, (CompositeMap)current_param);
        this.content = TextParser.parse((String)this.content, (CompositeMap)current_param);
        this.from = TextParser.parse((String)this.from, (CompositeMap)current_param);
        this.title = TextParser.parse((String)this.title, (CompositeMap)current_param);
        this.to = TextParser.parse((String)this.to, (CompositeMap)current_param);
        this.port = TextParser.parse((String)this.port, (CompositeMap)current_param);
        this.userName = TextParser.parse((String)this.userName, (CompositeMap)current_param);
        this.cc = TextParser.parse((String)this.cc, (CompositeMap)current_param);
        if (this.smtpServer == null || "".equals(this.smtpServer)) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)this.smtpServer);
        }
        if (this.from == null || "".equals(this.from)) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)this.from);
        }
        if (this.password == null || "".equals(this.password)) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)this.password);
        }
        if (this.to == null || "".equals(this.to)) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)this.to);
        }
        if (this.content == null || "".equals(this.content)) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)this.content);
        }
        this.parseAttachParameters(runner.getContext());
        this.sendMail();
        logger.config("Mail send successfully!");
    }

    public void sendMail() throws Exception {
        Properties props = new Properties();
        props.put("mail.smtp.host", this.smtpServer);
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.port", this.port);
        Session s = null;
        if (this.auth.booleanValue()) {
            props.put("mail.smtp.auth", "true");
            SmtpAuth smtpAuth = new SmtpAuth(this.userName, this.password);
            s = Session.getDefaultInstance((Properties)props, (Authenticator)smtpAuth);
        } else {
            props.put("mail.smtp.auth", "false");
            s = Session.getDefaultInstance((Properties)props, null);
        }
        MimeMessage message = new MimeMessage(s);
        InternetAddress fromAddress = new InternetAddress(this.from);
        message.setFrom((Address)fromAddress);
        message.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.to));
        if (this.cc != null && !"".equals(this.cc)) {
            message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)this.cc));
        }
        message.setSubject(this.title);
        message.setSentDate(new Date());
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart mbp = new MimeBodyPart();
        mbp.setContent((Object)this.content, "text/html;charset=utf-8");
        mp.addBodyPart((BodyPart)mbp);
        this.addAttachment((Multipart)mp);
        message.setContent((Multipart)mp);
        Transport.send((Message)message, (Address[])message.getAllRecipients());
    }

    protected void addAttachment(Multipart mp) throws MessagingException, UnsupportedEncodingException {
        if (this.attachments != null) {
            for (int i = 0; i < this.attachments.length; ++i) {
                MimeBodyPart mbp = new MimeBodyPart();
                String fileName = this.attachments[i].getPath();
                FileDataSource fds = new FileDataSource(fileName);
                mbp.setDataHandler(new DataHandler((DataSource)fds));
                String encodeFileName = MimeUtility.encodeText((String)this.attachments[i].getName());
                mbp.setFileName(encodeFileName);
                mp.addBodyPart((BodyPart)mbp);
            }
        }
    }

    protected void parseAttachParameters(CompositeMap context) throws MessagingException {
        if (this.attachments != null) {
            for (int i = 0; i < this.attachments.length; ++i) {
                this.attachments[i].setPath(TextParser.parse((String)this.attachments[i].getPath(), (CompositeMap)context));
                this.attachments[i].setName(TextParser.parse((String)this.attachments[i].getName(), (CompositeMap)context));
            }
        }
    }

    public void check() {
    }

    public IObjectRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(IObjectRegistry registry) {
        this.registry = registry;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Deprecated
    public String getTto() {
        return this.to;
    }

    @Deprecated
    public void setTto(String tto) {
        this.to = tto;
    }

    @Deprecated
    public String getCto() {
        return this.cc;
    }

    @Deprecated
    public void setCto(String cto) {
        this.cc = cto;
    }

    @Deprecated
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Attachment[] getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Attachment[] attaches) {
        this.attachments = attaches;
    }

    public boolean isAuth() {
        return this.auth;
    }

    public void setAuth(boolean auth) {
        this.auth = auth;
    }

    class SmtpAuth
    extends Authenticator {
        private String username;
        private String password;

        public SmtpAuth(String username, String password) {
            this.username = username;
            this.password = password;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

