/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.export.word;

import aurora.plugin.export.word.wml.Body;
import aurora.plugin.export.word.wml.Break;
import aurora.plugin.export.word.wml.Document;
import aurora.plugin.export.word.wml.Footer;
import aurora.plugin.export.word.wml.Header;
import aurora.plugin.export.word.wml.Image;
import aurora.plugin.export.word.wml.PBdr;
import aurora.plugin.export.word.wml.PTab;
import aurora.plugin.export.word.wml.Paragraph;
import aurora.plugin.export.word.wml.Table;
import aurora.plugin.export.word.wml.TableTc;
import aurora.plugin.export.word.wml.TableTcBorder;
import aurora.plugin.export.word.wml.TableTr;
import aurora.plugin.export.word.wml.Text;
import aurora.plugin.export.word.wml.Toc;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.docx4j.XmlUtils;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.PageSizePaper;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentSettingsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.Br;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.CTDocProtect;
import org.docx4j.wml.CTHeight;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.CTSettings;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.CTTabStop;
import org.docx4j.wml.CTTblPrBase;
import org.docx4j.wml.CTVerticalJc;
import org.docx4j.wml.Color;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.FooterReference;
import org.docx4j.wml.Ftr;
import org.docx4j.wml.Hdr;
import org.docx4j.wml.HdrFtrRef;
import org.docx4j.wml.HeaderReference;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.Numbering;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STAlgClass;
import org.docx4j.wml.STAlgType;
import org.docx4j.wml.STBorder;
import org.docx4j.wml.STBrType;
import org.docx4j.wml.STCryptProv;
import org.docx4j.wml.STDocProtect;
import org.docx4j.wml.STFldCharType;
import org.docx4j.wml.STHeightRule;
import org.docx4j.wml.STHint;
import org.docx4j.wml.STLineSpacingRule;
import org.docx4j.wml.STPTabAlignment;
import org.docx4j.wml.STPTabLeader;
import org.docx4j.wml.STPTabRelativeTo;
import org.docx4j.wml.STShd;
import org.docx4j.wml.STTabJc;
import org.docx4j.wml.STTabTlc;
import org.docx4j.wml.STVerticalJc;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Tabs;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;
import org.docx4j.wml.U;
import org.docx4j.wml.UnderlineEnumeration;

public class WordUtils {
    public static final int TWIP_CENTIMETER = 567;
    private static final String KEY_RUN_NUMID = "KEY_RUN_NUMID";
    private static final String KEY_TEMPLATE_FILE = "KEY_TEMPLATE_FILE";
    private static final String KEY_NUMBERING_DEFINITION_PART = "KEY_NUMBERING_DEFINITION_PART";
    public static final ThreadLocal threadLocal = new ThreadLocal();
    static final String initialNumbering = "<w:numbering xmlns:ve=\"http://schemas.openxmlformats.org/markup-compatibility/2006\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" xmlns:w10=\"urn:schemas-microsoft-com:office:word\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:wne=\"http://schemas.microsoft.com/office/word/2006/wordml\"><w:abstractNum w:abstractNumId=\"0\"><w:nsid w:val=\"2DD860C0\"/><w:multiLevelType w:val=\"multilevel\"/><w:tmpl w:val=\"0409001D\"/><w:lvl w:ilvl=\"0\"><w:start w:val=\"1\"/><w:numFmt w:val=\"decimal\"/><w:lvlText w:val=\"%1\"/><w:lvlJc w:val=\"left\"/><w:pPr><w:tabs><w:tab w:val=\"num\" w:pos=\"420\"/></w:tabs><w:ind w:left=\"420\" w:hanging=\"420\"/></w:pPr><w:rPr><w:b/><w:rFonts w:hint=\"eastAsia\" w:ascii=\"\u5b8b\u4f53\" w:hAnsi=\"\u5b8b\u4f53\"/><w:color w:val=\"auto\"/><w:sz w:val=\"24\"/><w:szCs w:val=\"24\"/></w:rPr></w:lvl><w:lvl w:ilvl=\"1\"><w:start w:val=\"1\"/><w:numFmt w:val=\"decimal\"/><w:lvlText w:val=\"%1.%2\"/><w:lvlJc w:val=\"left\"/><w:pPr><w:tabs><w:tab w:val=\"num\" w:pos=\"840\"/></w:tabs><w:ind w:left=\"840\" w:hanging=\"840\"/></w:pPr><w:rPr><w:b/><w:rFonts w:hint=\"eastAsia\" w:ascii=\"\u5b8b\u4f53\" w:hAnsi=\"\u5b8b\u4f53\"/><w:color w:val=\"auto\"/><w:sz w:val=\"24\"/><w:szCs w:val=\"24\"/></w:rPr></w:lvl><w:lvl w:ilvl=\"2\"><w:start w:val=\"1\"/><w:numFmt w:val=\"decimal\"/><w:lvlText w:val=\"(%3)\"/><w:lvlJc w:val=\"left\"/><w:pPr><w:tabs><w:tab w:val=\"num\" w:pos=\"1260\"/></w:tabs><w:ind w:left=\"1260\"  w:hanging=\"420\"/></w:pPr></w:lvl><w:lvl w:ilvl=\"3\"><w:start w:val=\"1\"/><w:numFmt w:val=\"lowerLetter\"/><w:lvlText w:val=\"(%4)\"/><w:lvlJc w:val=\"left\"/><w:pPr><w:tabs><w:tab w:val=\"num\" w:pos=\"1680\"/></w:tabs><w:ind w:left=\"1680\" w:hanging=\"420\"/></w:pPr></w:lvl><w:lvl w:ilvl=\"4\"><w:start w:val=\"1\"/><w:numFmt w:val=\"lowerRoman\"/><w:lvlText w:val=\"%5)\"/><w:lvlJc w:val=\"left\"/><w:pPr><w:tabs><w:tab w:val=\"num\" w:pos=\"2100\"/></w:tabs><w:ind w:left=\"2100\" w:hanging=\"420\"/></w:pPr></w:lvl><w:lvl w:ilvl=\"5\"><w:start w:val=\"1\"/><w:numFmt w:val=\"lowerRoman\"/><w:lvlText w:val=\"(%6)\"/><w:lvlJc w:val=\"left\"/><w:pPr><w:tabs><w:tab w:val=\"num\" w:pos=\"2520\"/></w:tabs><w:ind w:left=\"2520\" w:hanging=\"420\"/></w:pPr></w:lvl><w:lvl w:ilvl=\"6\"><w:start w:val=\"1\"/><w:numFmt w:val=\"decimal\"/><w:lvlText w:val=\"%7.\"/><w:lvlJc w:val=\"left\"/><w:pPr><w:tabs><w:tab w:val=\"num\" w:pos=\"2940\"/></w:tabs><w:ind w:left=\"2940\" w:hanging=\"420\"/></w:pPr></w:lvl><w:lvl w:ilvl=\"7\"><w:start w:val=\"1\"/><w:numFmt w:val=\"lowerLetter\"/><w:lvlText w:val=\"%8.\"/><w:lvlJc w:val=\"left\"/><w:pPr><w:tabs><w:tab w:val=\"num\" w:pos=\"3360\"/></w:tabs><w:ind w:left=\"3360\" w:hanging=\"420\"/></w:pPr></w:lvl><w:lvl w:ilvl=\"8\"><w:start w:val=\"1\"/><w:numFmt w:val=\"lowerRoman\"/><w:lvlText w:val=\"%9.\"/><w:lvlJc w:val=\"left\"/><w:pPr><w:tabs><w:tab w:val=\"num\" w:pos=\"3780\"/></w:tabs><w:ind w:left=\"3780\" w:hanging=\"420\"/></w:pPr></w:lvl></w:abstractNum><w:num w:numId=\"1\"><w:abstractNumId w:val=\"0\"/></w:num></w:numbering>";

    private static Object getObject(String key) {
        Map map = (Map)threadLocal.get();
        return map.get(key);
    }

    private static void putObject(String key, Object value) {
        Map map = (Map)threadLocal.get();
        map.put(key, value);
    }

    public static WordprocessingMLPackage createWord(Document doc, File templateFile) throws Exception {
        String watermark;
        Footer footer;
        if (doc.getDebugger().booleanValue()) {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Document.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"gbk");
            marshaller.marshal((Object)doc, (OutputStream)System.out);
            System.out.println("");
        }
        threadLocal.set(new HashMap());
        WordUtils.putObject(KEY_TEMPLATE_FILE, templateFile);
        WordprocessingMLPackage wordMLPackage = WordUtils.createWordprocessingMLPackage(doc);
        MainDocumentPart mdp = wordMLPackage.getMainDocumentPart();
        ObjectFactory factory = Context.getWmlObjectFactory();
        SectPr docSectPr = ((org.docx4j.wml.Document)wordMLPackage.getMainDocumentPart().getJaxbElement()).getBody().getSectPr();
        SectPr.PgMar pg = factory.createSectPrPgMar();
        Double top = doc.getTop() * 567.0;
        pg.setTop(BigInteger.valueOf(top.intValue()));
        Double bottom = doc.getBottom() * 567.0;
        pg.setBottom(BigInteger.valueOf(bottom.intValue()));
        Double left = doc.getLeft() * 567.0;
        pg.setLeft(BigInteger.valueOf(left.intValue()));
        Double right = doc.getRight() * 567.0;
        pg.setRight(BigInteger.valueOf(right.intValue()));
        docSectPr.setPgMar(pg);
        HeaderPart hp = null;
        Header header = doc.getHeader();
        if (header != null && header.getPara() != null) {
            hp = WordUtils.addHeader(factory, wordMLPackage, header.getPara());
        }
        if ((footer = doc.getFooter()) != null) {
            WordUtils.addFooter(factory, wordMLPackage);
        }
        if ((watermark = doc.getWatermark()) != null) {
            WordUtils.addWaterMark(hp, factory, wordMLPackage, watermark);
        }
        Body body = doc.getBody();
        List<Object> paras = body.getParas();
        int indexOfToc = WordUtils.findToc(paras);
        ArrayList tocs = new ArrayList();
        for (Object object : paras) {
            P p = null;
            if (object instanceof Paragraph) {
                Paragraph paragraph = (Paragraph)object;
                Boolean toc = paragraph.getToc();
                if (toc.booleanValue()) {
                    Object t;
                    String tocTitle = "untitle";
                    List<Object> objs = paragraph.getObjects();
                    if (objs != null && objs.size() > 0 && (t = objs.get(0)) instanceof Text) {
                        tocTitle = ((Text)t).getText();
                    }
                    HashMap<String, String> bmk = new HashMap<String, String>();
                    String bookmark = UUID.randomUUID().toString();
                    paragraph.setTocBookMark(bookmark);
                    bmk.put("TOC_TITLE", tocTitle);
                    bmk.put("TOC_BOOKMARK", bookmark);
                    tocs.add(bmk);
                }
                p = WordUtils.createPara(wordMLPackage, factory, (Paragraph)object);
            } else if (object instanceof Break) {
                p = WordUtils.createPageBreak(factory);
            } else if (object instanceof Table) {
                Table table = (Table)object;
                p = WordUtils.createTable(wordMLPackage, factory, table);
            }
            if (p == null) continue;
            ((org.docx4j.wml.Document)mdp.getJaxbElement()).getBody().getContent().add(p);
        }
        if (indexOfToc != -1 && !tocs.isEmpty()) {
            ((org.docx4j.wml.Document)mdp.getJaxbElement()).getBody().getContent().add(indexOfToc++, WordUtils.createTOCHead(factory));
            ((org.docx4j.wml.Document)mdp.getJaxbElement()).getBody().getContent().add(indexOfToc++, WordUtils.createTOCStart(factory));
            for (Map map : tocs) {
                ((org.docx4j.wml.Document)mdp.getJaxbElement()).getBody().getContent().add(indexOfToc++, WordUtils.createTOC(factory, map));
            }
            ((org.docx4j.wml.Document)mdp.getJaxbElement()).getBody().getContent().add(indexOfToc++, WordUtils.createTOCEnd(factory));
            ((org.docx4j.wml.Document)mdp.getJaxbElement()).getBody().getContent().add(indexOfToc++, WordUtils.createPageBreak(factory));
        }
        WordUtils.hideSpellAndGrammaticalErrors(wordMLPackage, factory);
        if (doc.getReadOnly().booleanValue()) {
            WordUtils.setReadOnly(wordMLPackage, true);
        }
        if (doc.getDebugger().booleanValue()) {
            System.out.println(XmlUtils.marshaltoString((Object)wordMLPackage.getMainDocumentPart().getJaxbElement(), (boolean)true, (boolean)true));
        }
        return wordMLPackage;
    }

    public static WordprocessingMLPackage createWord(String xml, File templateFile) throws Exception {
        Document doc = WordUtils.unmarshalXML(xml);
        return WordUtils.createWord(doc, templateFile);
    }

    private static Document unmarshalXML(String xml) throws JAXBException, FileNotFoundException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Document.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        Document doc = (Document)unmarshaller.unmarshal((Reader)new StringReader(xml));
        return doc;
    }

    public static WordprocessingMLPackage createWordprocessingMLPackage(Document doc) throws Exception {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage((PageSizePaper)PageSizePaper.valueOf((String)doc.getPageSize()), (boolean)doc.getLandscape());
        NumberingDefinitionsPart ndp = new NumberingDefinitionsPart();
        wordMLPackage.getMainDocumentPart().addTargetPart((Part)ndp);
        ndp.setJaxbElement((Object)((Numbering)XmlUtils.unmarshalString((String)initialNumbering)));
        WordUtils.putObject(KEY_NUMBERING_DEFINITION_PART, ndp);
        return wordMLPackage;
    }

    public static int getWritableWidth(WordprocessingMLPackage wordPackage) throws Exception {
        return ((SectionWrapper)wordPackage.getDocumentModel().getSections().get(0)).getPageDimensions().getWritableWidthTwips();
    }

    public static void hideSpellAndGrammaticalErrors(WordprocessingMLPackage wordMLPackage, ObjectFactory factory) throws InvalidFormatException {
        DocumentSettingsPart ds = wordMLPackage.getMainDocumentPart().getDocumentSettingsPart();
        if (ds == null) {
            ds = new DocumentSettingsPart();
        }
        CTSettings cs = factory.createCTSettings();
        cs.setHideSpellingErrors(Context.getWmlObjectFactory().createBooleanDefaultTrue());
        cs.setHideGrammaticalErrors(Context.getWmlObjectFactory().createBooleanDefaultTrue());
        ds.setJaxbElement((Object)cs);
        wordMLPackage.getMainDocumentPart().addTargetPart((Part)ds);
    }

    public static Tbl createTable(WordprocessingMLPackage wordMLPackage, ObjectFactory factory, Table table) throws Exception {
        Double tblWidth;
        Tbl tbl = factory.createTbl();
        TblPr tblPr = factory.createTblPr();
        tbl.setTblPr(tblPr);
        Double indLeft = table.getIndLeft();
        if (indLeft != null) {
            indLeft = indLeft * 567.0;
            TblWidth w = factory.createTblWidth();
            w.setType("dxa");
            w.setW(BigInteger.valueOf(indLeft.intValue()));
            tblPr.setTblInd(w);
        }
        if ((tblWidth = table.getWidth()) != null) {
            tblWidth = tblWidth * 567.0;
            TblWidth w = factory.createTblWidth();
            w.setType("dxa");
            w.setW(BigInteger.valueOf(tblWidth.intValue()));
            tblPr.setTblW(w);
        }
        Jc jc = factory.createJc();
        jc.setVal(JcEnumeration.fromValue((String)table.getAlign()));
        tblPr.setJc(jc);
        Boolean isBorder = table.getBorder();
        if (isBorder.booleanValue()) {
            CTTblPrBase.TblStyle tblStyle = factory.createCTTblPrBaseTblStyle();
            tblStyle.setVal("TableGrid");
            tblPr.setTblStyle(tblStyle);
        }
        for (TableTr tblTr : table.getTrs()) {
            Tr tr = factory.createTr();
            tbl.getContent().add(tr);
            TrPr trPr = factory.createTrPr();
            CTHeight ctHeight = new CTHeight();
            Double height = tblTr.getHeight() * 567.0;
            ctHeight.setVal(BigInteger.valueOf(height.intValue()));
            ctHeight.setHRule(STHeightRule.AT_LEAST);
            JAXBElement trHeightElement = factory.createCTTrPrBaseTrHeight(ctHeight);
            trPr.getCnfStyleOrDivIdOrGridBefore().add(trHeightElement);
            tr.setTrPr(trPr);
            for (TableTc tblTc : tblTr.getTcs()) {
                String vAlign;
                Integer span;
                String fill;
                Double width;
                Tc tc = factory.createTc();
                tr.getContent().add(tc);
                TcPr tcPr = factory.createTcPr();
                if (tblTc.getBorders().size() > 0) {
                    TcPrInner.TcBorders tcB = factory.createTcPrInnerTcBorders();
                    tcPr.setTcBorders(tcB);
                    for (TableTcBorder border : tblTc.getBorders()) {
                        CTBorder ctborder = factory.createCTBorder();
                        ctborder.setVal(STBorder.fromValue((String)border.getStyle()));
                        ctborder.setSz(new BigInteger(border.getSize()));
                        ctborder.setColor(border.getColor());
                        String type = border.getType();
                        if ("top".equalsIgnoreCase(type)) {
                            tcB.setTop(ctborder);
                            continue;
                        }
                        if ("bottom".equalsIgnoreCase(type)) {
                            tcB.setBottom(ctborder);
                            continue;
                        }
                        if ("left".equalsIgnoreCase(type)) {
                            tcB.setLeft(ctborder);
                            continue;
                        }
                        if (!"right".equalsIgnoreCase(type)) continue;
                        tcB.setRight(ctborder);
                    }
                }
                if ((width = tblTc.getWidth()) != null) {
                    width = width * 567.0;
                    tc.setTcPr(tcPr);
                    TblWidth cellWidth = factory.createTblWidth();
                    tcPr.setTcW(cellWidth);
                    cellWidth.setType("dxa");
                    cellWidth.setW(BigInteger.valueOf(width.intValue()));
                }
                if ((fill = tblTc.getFill()) != null) {
                    CTShd shd = factory.createCTShd();
                    shd.setVal(STShd.CLEAR);
                    shd.setColor("auto");
                    shd.setFill(fill);
                    tcPr.setShd(shd);
                }
                if ((span = tblTc.getSpan()) != null) {
                    TcPrInner.GridSpan gs = factory.createTcPrInnerGridSpan();
                    gs.setVal(new BigInteger(span.toString()));
                    tcPr.setGridSpan(gs);
                }
                if ((vAlign = tblTc.getVAlign()) != null) {
                    CTVerticalJc vjc = factory.createCTVerticalJc();
                    vjc.setVal(STVerticalJc.fromValue((String)vAlign));
                    tcPr.setVAlign(vjc);
                }
                tc.setTcPr(tcPr);
                for (Paragraph para : tblTc.getParas()) {
                    tc.getContent().add(WordUtils.createPara(wordMLPackage, factory, para));
                }
            }
        }
        return tbl;
    }

    public static int findToc(List<Object> paras) {
        int i = 0;
        for (Object obj : paras) {
            if (obj instanceof Toc) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static R createImage(WordprocessingMLPackage wordprocessingMLPackage, ObjectFactory factory, HeaderPart part, File file) throws Exception {
        if (file == null || !file.exists()) {
            R run = factory.createR();
            RPr rpr = factory.createRPr();
            run.setRPr(rpr);
            Color color = new Color();
            color.setVal("#ff0000");
            rpr.setColor(color);
            org.docx4j.wml.Text t = factory.createText();
            t.setValue("(" + file.getAbsolutePath() + ")\u8be5\u94fe\u63a5\u5730\u5740\u56fe\u7247\u6587\u4ef6\u5df2\u4e22\u5931!");
            run.getContent().add(t);
            return run;
        }
        FileInputStream is = null;
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            System.out.println("File too large!!");
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        try {
            int offset;
            is = new FileInputStream(file);
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                System.out.println("Could not completely read file " + file.getName());
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        BinaryPartAbstractImage imagePart = part != null ? BinaryPartAbstractImage.createImagePart((OpcPackage)wordprocessingMLPackage, (Part)part, (byte[])bytes) : BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)wordprocessingMLPackage, (byte[])bytes);
        Inline inline = imagePart.createImageInline(null, null, 0, 1, false);
        R run = factory.createR();
        Drawing drawing = factory.createDrawing();
        run.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        return run;
    }

    public static JAXBElement getWrappedFldChar(FldChar fldchar) {
        return new JAXBElement(new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "fldChar"), FldChar.class, (Object)fldchar);
    }

    public static P.Hyperlink createHyperlink(String name, String anchor) throws JAXBException {
        String hpl = "<w:hyperlink xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" w:anchor=\"" + anchor + "\"><w:r><w:t>" + name + "</w:t></w:r><w:r> <w:tab /> </w:r><w:fldSimple w:instr=\"PAGEREF " + anchor + "\"> <w:r> <w:t></w:t> </w:r> </w:fldSimple> </w:hyperlink>";
        return (P.Hyperlink)XmlUtils.unmarshalString((String)hpl);
    }

    public static P createTOCHead(ObjectFactory factory) {
        P p = factory.createP();
        org.docx4j.wml.Text t = factory.createText();
        t.setValue("\u76ee    \u5f55");
        R run = factory.createR();
        run.getContent().add(t);
        Jc jc = factory.createJc();
        jc.setVal(JcEnumeration.CENTER);
        PPr ppr = factory.createPPr();
        ppr.setJc(jc);
        p.setPPr(ppr);
        RPr rPr = factory.createRPr();
        RFonts rf = new RFonts();
        rf.setHint(STHint.EAST_ASIA);
        rf.setAscii("\u5b8b\u4f53");
        rf.setHAnsi("\u5b8b\u4f53");
        rPr.setRFonts(rf);
        BooleanDefaultTrue bdt = Context.getWmlObjectFactory().createBooleanDefaultTrue();
        rPr.setBCs(bdt);
        rPr.setB(bdt);
        run.setRPr(rPr);
        p.getContent().add(run);
        return p;
    }

    public static P createTOCStart(ObjectFactory factory) {
        P p1 = factory.createP();
        R r11 = factory.createR();
        FldChar fldchar = factory.createFldChar();
        fldchar.setFldCharType(STFldCharType.BEGIN);
        r11.getContent().add(WordUtils.getWrappedFldChar(fldchar));
        p1.getContent().add(r11);
        R r12 = factory.createR();
        org.docx4j.wml.Text txt = new org.docx4j.wml.Text();
        txt.setSpace("preserve");
        txt.setValue("TOC \\o \"1-3\" \\h \\z \\u \\h");
        r12.getContent().add(factory.createRInstrText(txt));
        p1.getContent().add(r12);
        R r13 = factory.createR();
        FldChar fldchar2 = factory.createFldChar();
        fldchar2.setFldCharType(STFldCharType.SEPARATE);
        r13.getContent().add(WordUtils.getWrappedFldChar(fldchar2));
        p1.getContent().add(r13);
        return p1;
    }

    public static P createTOCEnd(ObjectFactory factory) {
        P p3 = factory.createP();
        R r3 = factory.createR();
        FldChar fldchar3 = factory.createFldChar();
        fldchar3.setFldCharType(STFldCharType.END);
        r3.getContent().add(WordUtils.getWrappedFldChar(fldchar3));
        p3.getContent().add(r3);
        return p3;
    }

    public static P createTOC(ObjectFactory factory, Map<String, String> map) throws JAXBException {
        P p = factory.createP();
        PPr ppr = factory.createPPr();
        Tabs tabs = factory.createTabs();
        CTTabStop cttab = factory.createCTTabStop();
        cttab.setVal(STTabJc.RIGHT);
        cttab.setLeader(STTabTlc.DOT);
        cttab.setPos(new BigInteger("9350"));
        tabs.getTab().add(cttab);
        ppr.setTabs(tabs);
        p.setPPr(ppr);
        String title = map.get("TOC_TITLE");
        String bookmark = map.get("TOC_BOOKMARK");
        P.Hyperlink link = WordUtils.createHyperlink(title, bookmark);
        p.getContent().add(link);
        return p;
    }

    public static P createPageBreak(ObjectFactory factory) {
        Br breakObj = new Br();
        breakObj.setType(STBrType.PAGE);
        P p = factory.createP();
        p.getContent().add(breakObj);
        return p;
    }

    private static void bookmarkRun(P p, R r, String name, int id) {
        int index = p.getContent().indexOf(r);
        if (index < 0) {
            System.out.println("P does not contain R!");
            return;
        }
        ObjectFactory factory = Context.getWmlObjectFactory();
        BigInteger ID = BigInteger.valueOf(id);
        CTMarkupRange mr = factory.createCTMarkupRange();
        mr.setId(ID);
        JAXBElement bmEnd = factory.createBodyBookmarkEnd(mr);
        p.getContent().add(index + 1, bmEnd);
        CTBookmark bm = factory.createCTBookmark();
        bm.setId(ID);
        bm.setName(name);
        JAXBElement bmStart = factory.createBodyBookmarkStart(bm);
        p.getContent().add(index, bmStart);
    }

    public static P createPara(WordprocessingMLPackage wordprocessingMLPackage, ObjectFactory factory, Paragraph para) throws Exception {
        return WordUtils.createPara(wordprocessingMLPackage, factory, null, para);
    }

    public static P createPara(WordprocessingMLPackage wordprocessingMLPackage, ObjectFactory factory, HeaderPart part, Paragraph para) throws Exception {
        P p = factory.createP();
        Double indFirstLine = para.getIndFirstLine();
        Double indLeft = para.getIndLeft();
        String align = para.getAlign();
        PPr ppr = factory.createPPr();
        PPrBase.Spacing spacing = factory.createPPrBaseSpacing();
        spacing.setAfter(new BigInteger(para.getAfter()));
        ppr.setSpacing(spacing);
        if (indFirstLine != null || indLeft != null) {
            PPrBase.Ind ind = factory.createPPrBaseInd();
            if (indLeft != null) {
                indLeft = indLeft * 567.0;
                ind.setLeft(BigInteger.valueOf(indLeft.intValue()));
            }
            if (indFirstLine != null) {
                indFirstLine = indFirstLine * 567.0;
                ind.setFirstLine(BigInteger.valueOf(indFirstLine.intValue()));
            }
            ppr.setInd(ind);
        }
        SectPr docSectPr = ((org.docx4j.wml.Document)wordprocessingMLPackage.getMainDocumentPart().getJaxbElement()).getBody().getSectPr();
        BigInteger pageWidth = docSectPr.getPgSz().getW();
        BigInteger pageHeight = docSectPr.getPgSz().getH();
        String orientation = para.getOrientation();
        SectPr sectPr = factory.createSectPr();
        sectPr.getEGHdrFtrReferences().addAll(docSectPr.getEGHdrFtrReferences());
        SectPr.PgSz pgSz = factory.createSectPrPgSz();
        if ("portrait".equals(orientation)) {
            pgSz.setW(pageWidth);
            pgSz.setH(pageHeight);
            sectPr.setPgSz(pgSz);
            ppr.setSectPr(sectPr);
        } else if ("landscape".equals(orientation)) {
            pgSz.setW(pageHeight);
            pgSz.setH(pageWidth);
            sectPr.setPgSz(pgSz);
            ppr.setSectPr(sectPr);
        }
        Long numId = para.getNumId();
        Long ilvl = para.getIlvl();
        if (numId != null && ilvl != null) {
            Long runNumId = (Long)WordUtils.getObject(KEY_RUN_NUMID);
            if (runNumId == null) {
                runNumId = numId;
                WordUtils.putObject(KEY_RUN_NUMID, new Long(1L));
            }
            if (numId > runNumId) {
                NumberingDefinitionsPart ndp = (NumberingDefinitionsPart)WordUtils.getObject(KEY_NUMBERING_DEFINITION_PART);
                long rid = 0L;
                while (rid < numId) {
                    rid = ndp.restart(runNumId.longValue(), 0L, 1L);
                }
                WordUtils.putObject(KEY_RUN_NUMID, numId);
            }
            PPrBase.NumPr numPr = factory.createPPrBaseNumPr();
            ppr.setNumPr(numPr);
            PPrBase.NumPr.Ilvl ilvlElement = factory.createPPrBaseNumPrIlvl();
            numPr.setIlvl(ilvlElement);
            ilvlElement.setVal(BigInteger.valueOf(ilvl));
            PPrBase.NumPr.NumId numIdElement = factory.createPPrBaseNumPrNumId();
            numPr.setNumId(numIdElement);
            numIdElement.setVal(BigInteger.valueOf(numId));
        }
        if (align != null) {
            Jc jc = factory.createJc();
            jc.setVal(JcEnumeration.fromValue((String)align));
            ppr.setJc(jc);
        }
        p.setPPr(ppr);
        List<Object> objs = para.getObjects();
        int i = 0;
        boolean hasImg = false;
        for (Object obj : objs) {
            R run;
            if (obj instanceof Text) {
                Text text = (Text)obj;
                run = WordUtils.createRun(factory, text);
                p.getContent().add(run);
                if (para.getToc().booleanValue()) {
                    WordUtils.bookmarkRun(p, run, para.getTocBookMark(), 1);
                }
            } else if (obj instanceof PTab) {
                PTab ptab = (PTab)obj;
                run = factory.createR();
                R.Ptab pt = factory.createRPtab();
                pt.setRelativeTo(STPTabRelativeTo.fromValue((String)ptab.getRelativeTo()));
                pt.setAlignment(STPTabAlignment.fromValue((String)ptab.getAlignment()));
                pt.setLeader(STPTabLeader.fromValue((String)ptab.getLeader()));
                run.getContent().add(pt);
                p.getContent().add(run);
            } else if (obj instanceof PBdr) {
                PBdr pbdr = (PBdr)obj;
                PPrBase.PBdr pdr = factory.createPPrBasePBdr();
                ppr.setPBdr(pdr);
                WordUtils.createPDBorder(factory, pdr, pbdr.getTop());
                WordUtils.createPDBorder(factory, pdr, pbdr.getBottom());
                WordUtils.createPDBorder(factory, pdr, pbdr.getRight());
                WordUtils.createPDBorder(factory, pdr, pbdr.getLeft());
            } else if (obj instanceof Image) {
                File folder;
                hasImg = true;
                Image img = (Image)obj;
                File file = "relative".equals(img.getType()) ? ((folder = (File)WordUtils.getObject(KEY_TEMPLATE_FILE)) == null ? new File(img.getSrc()) : new File(folder.getParent(), img.getSrc())) : new File(img.getSrc());
                p.getContent().add(WordUtils.createImage(wordprocessingMLPackage, factory, part, file));
            }
            ++i;
        }
        if (!hasImg) {
            String line = para.getLine();
            String lineRule = para.getLineRule();
            if (line != null || lineRule != null) {
                spacing.setLine(new BigInteger(line));
                spacing.setLineRule(STLineSpacingRule.fromValue((String)lineRule));
            }
        }
        return p;
    }

    private static void createPDBorder(ObjectFactory factory, PPrBase.PBdr pdr, Object obj) {
        if (obj == null) {
            return;
        }
        CTBorder ctborder = factory.createCTBorder();
        PBdr.Border border = (PBdr.Border)obj;
        ctborder.setVal(STBorder.fromValue((String)border.getValue()));
        ctborder.setColor(border.getColor());
        ctborder.setSz(new BigInteger(border.getSz()));
        ctborder.setSpace(new BigInteger(border.getSpace()));
        if (border instanceof PBdr.Top) {
            pdr.setTop(ctborder);
        } else if (border instanceof PBdr.Left) {
            pdr.setLeft(ctborder);
        } else if (border instanceof PBdr.Right) {
            pdr.setRight(ctborder);
        } else if (border instanceof PBdr.Bottom) {
            pdr.setBottom(ctborder);
        }
    }

    public static R createRun(ObjectFactory factory, Text text) {
        R run = factory.createR();
        RPr rpr = factory.createRPr();
        Boolean isBold = text.isBold();
        if (isBold.booleanValue()) {
            BooleanDefaultTrue bdt = Context.getWmlObjectFactory().createBooleanDefaultTrue();
            rpr.setBCs(bdt);
            rpr.setB(bdt);
        }
        String fontFamily = text.getFontFamily();
        RFonts rf = new RFonts();
        rf.setHint(STHint.EAST_ASIA);
        rf.setAscii(fontFamily);
        rf.setHAnsi(fontFamily);
        rpr.setRFonts(rf);
        Boolean italic = text.isItalic();
        if (italic.booleanValue()) {
            BooleanDefaultTrue bdt = Context.getWmlObjectFactory().createBooleanDefaultTrue();
            rpr.setI(bdt);
        }
        Color color = new Color();
        color.setVal(text.getFontColor());
        rpr.setColor(color);
        HpsMeasure sz = new HpsMeasure();
        sz.setVal(new BigInteger(text.getFontSize()));
        rpr.setSz(sz);
        rpr.setSzCs(sz);
        String underline = text.getUnderline();
        if (underline != null) {
            U u = factory.createU();
            u.setVal(UnderlineEnumeration.fromValue((String)underline));
            rpr.setU(u);
        }
        run.setRPr(rpr);
        org.docx4j.wml.Text t = factory.createText();
        String space = text.getSpace();
        if (space != null) {
            t.setSpace(space);
        }
        t.setValue(text.getText());
        run.getContent().add(t);
        return run;
    }

    public static HeaderPart addHeader(ObjectFactory factory, WordprocessingMLPackage wordprocessingMLPackage, Paragraph para) throws Exception {
        HeaderPart headerPart = new HeaderPart();
        headerPart.setPackage((OpcPackage)wordprocessingMLPackage);
        Hdr hdr = factory.createHdr();
        hdr.getContent().add(WordUtils.createPara(wordprocessingMLPackage, factory, headerPart, para));
        headerPart.setJaxbElement((Object)hdr);
        Relationship relationship = wordprocessingMLPackage.getMainDocumentPart().addTargetPart((Part)headerPart);
        List sections = wordprocessingMLPackage.getDocumentModel().getSections();
        SectPr sectPr = ((SectionWrapper)sections.get(sections.size() - 1)).getSectPr();
        if (sectPr == null) {
            sectPr = factory.createSectPr();
            wordprocessingMLPackage.getMainDocumentPart().addObject((Object)sectPr);
            ((SectionWrapper)sections.get(sections.size() - 1)).setSectPr(sectPr);
        }
        HeaderReference headerReference = factory.createHeaderReference();
        headerReference.setId(relationship.getId());
        headerReference.setType(HdrFtrRef.DEFAULT);
        sectPr.getEGHdrFtrReferences().add(headerReference);
        return headerPart;
    }

    public static void addFooter(ObjectFactory factory, WordprocessingMLPackage wordprocessingMLPackage) throws Exception {
        FooterPart footer = new FooterPart(new PartName("/word/myfooter.xml"));
        footer.setPackage((OpcPackage)wordprocessingMLPackage);
        Ftr ftr = factory.createFtr();
        P p = factory.createP();
        WordUtils.addFieldBegin(factory, p);
        Jc jc = factory.createJc();
        jc.setVal(JcEnumeration.CENTER);
        PPr ppr = factory.createPPr();
        ppr.setJc(jc);
        p.setPPr(ppr);
        R run = factory.createR();
        org.docx4j.wml.Text txt = new org.docx4j.wml.Text();
        txt.setSpace("preserve");
        txt.setValue(" PAGE   \\* MERGEFORMAT ");
        run.getContent().add(factory.createRInstrText(txt));
        p.getContent().add(run);
        WordUtils.addFieldEnd(factory, p);
        ftr.getContent().add(p);
        footer.setJaxbElement((Object)ftr);
        Relationship relationship = wordprocessingMLPackage.getMainDocumentPart().addTargetPart((Part)footer);
        List sections = wordprocessingMLPackage.getDocumentModel().getSections();
        SectPr sectPr = ((SectionWrapper)sections.get(sections.size() - 1)).getSectPr();
        if (sectPr == null) {
            sectPr = factory.createSectPr();
            wordprocessingMLPackage.getMainDocumentPart().addObject((Object)sectPr);
            ((SectionWrapper)sections.get(sections.size() - 1)).setSectPr(sectPr);
        }
        FooterReference footerReference = factory.createFooterReference();
        footerReference.setId(relationship.getId());
        footerReference.setType(HdrFtrRef.DEFAULT);
        sectPr.getEGHdrFtrReferences().add(footerReference);
    }

    private static void addFieldBegin(ObjectFactory factory, P paragraph) {
        R run = factory.createR();
        FldChar fldchar = factory.createFldChar();
        fldchar.setFldCharType(STFldCharType.BEGIN);
        run.getContent().add(fldchar);
        paragraph.getContent().add(run);
    }

    private static void addFieldEnd(ObjectFactory factory, P paragraph) {
        FldChar fldcharend = factory.createFldChar();
        fldcharend.setFldCharType(STFldCharType.END);
        R run3 = factory.createR();
        run3.getContent().add(fldcharend);
        paragraph.getContent().add(run3);
    }

    public static void addWaterMark(HeaderPart headerPart, ObjectFactory factory, WordprocessingMLPackage wordprocessingMLPackage, String watermark) throws Exception {
        boolean createHeaderPart = headerPart == null;
        Relationship relationship = null;
        Hdr hdr = null;
        if (createHeaderPart) {
            headerPart = new HeaderPart();
            hdr = factory.createHdr();
            headerPart.setJaxbElement((Object)hdr);
            relationship = wordprocessingMLPackage.getMainDocumentPart().addTargetPart((Part)headerPart);
        } else {
            hdr = (Hdr)headerPart.getJaxbElement();
        }
        WordUtils.addWaterMarkToP(hdr, factory, wordprocessingMLPackage, (Part)headerPart, watermark);
        List sections = wordprocessingMLPackage.getDocumentModel().getSections();
        SectPr sectPr = ((SectionWrapper)sections.get(sections.size() - 1)).getSectPr();
        if (sectPr == null) {
            sectPr = factory.createSectPr();
            wordprocessingMLPackage.getMainDocumentPart().addObject((Object)sectPr);
            ((SectionWrapper)sections.get(sections.size() - 1)).setSectPr(sectPr);
        }
        if (createHeaderPart) {
            HeaderReference headerReference = factory.createHeaderReference();
            headerReference.setId(relationship.getId());
            headerReference.setType(HdrFtrRef.DEFAULT);
            sectPr.getEGHdrFtrReferences().add(headerReference);
        }
    }

    public static void setReadOnly(WordprocessingMLPackage wordPackage, boolean isReadOnly) throws Exception {
        CTDocProtect cp;
        CTSettings cs;
        byte[] bt = "".getBytes();
        if (isReadOnly) {
            bt = "123456".getBytes();
        }
        ObjectFactory factory = Context.getWmlObjectFactory();
        DocumentSettingsPart ds = wordPackage.getMainDocumentPart().getDocumentSettingsPart();
        if (ds == null) {
            ds = new DocumentSettingsPart();
        }
        if ((cs = (CTSettings)ds.getJaxbElement()) == null) {
            cs = factory.createCTSettings();
        }
        if ((cp = cs.getDocumentProtection()) == null) {
            cp = new CTDocProtect();
        }
        cp.setCryptProviderType(STCryptProv.RSA_FULL);
        cp.setCryptAlgorithmClass(STAlgClass.HASH);
        cp.setCryptAlgorithmType(STAlgType.TYPE_ANY);
        cp.setCryptAlgorithmSid(new BigInteger("4"));
        cp.setCryptSpinCount(new BigInteger("50000"));
        if (isReadOnly) {
            cp.setEdit(STDocProtect.READ_ONLY);
            cp.setHash(bt);
            cp.setSalt(bt);
            cp.setEnforcement(Boolean.valueOf(true));
            cp.setFormatting(Boolean.valueOf(true));
        } else {
            cp.setEdit(STDocProtect.NONE);
            cp.setHash(null);
            cp.setSalt(null);
            cp.setEnforcement(Boolean.valueOf(false));
            cp.setFormatting(Boolean.valueOf(false));
        }
        cs.setDocumentProtection(cp);
        ds.setJaxbElement((Object)cs);
        wordPackage.getMainDocumentPart().addTargetPart((Part)ds);
    }

    private static void addWaterMarkToP(Hdr hdr, ObjectFactory factory, WordprocessingMLPackage wordprocessingMLPackage, Part sourcePart, String watermark) throws Exception {
        String openXML = "<w:p xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:w10=\"urn:schemas-microsoft-com:office:word\"><w:sdt><w:sdtPr><w:id w:val=\"-1589924921\"/><w:lock w:val=\"sdtContentLocked\"/><w:docPartObj><w:docPartGallery w:val=\"Watermarks\"/><w:docPartUnique/></w:docPartObj></w:sdtPr><w:sdtEndPr/><w:sdtContent><w:r><w:rPr><w:noProof/><w:lang w:eastAsia=\"zh-TW\"/></w:rPr><w:pict><v:shapetype adj=\"10800\" coordsize=\"21600,21600\" id=\"_x0000_t136\" o:spt=\"136\" path=\"m@7,l@8,m@5,21600l@6,21600e\"><v:formulas><v:f eqn=\"sum #0 0 10800\"/><v:f eqn=\"prod #0 2 1\"/><v:f eqn=\"sum 21600 0 @1\"/><v:f eqn=\"sum 0 0 @2\"/><v:f eqn=\"sum 21600 0 @3\"/><v:f eqn=\"if @0 @3 0\"/><v:f eqn=\"if @0 21600 @1\"/><v:f eqn=\"if @0 0 @2\"/><v:f eqn=\"if @0 @4 21600\"/><v:f eqn=\"mid @5 @6\"/><v:f eqn=\"mid @8 @5\"/><v:f eqn=\"mid @7 @8\"/><v:f eqn=\"mid @6 @7\"/><v:f eqn=\"sum @6 0 @5\"/></v:formulas><v:path o:connectangles=\"270,180,90,0\" o:connectlocs=\"@9,0;@10,10800;@11,21600;@12,10800\" o:connecttype=\"custom\" textpathok=\"t\"/><v:textpath fitshape=\"t\" on=\"t\"/><v:handles><v:h position=\"#0,bottomRight\" xrange=\"6629,14971\"/></v:handles><o:lock shapetype=\"t\" text=\"t\" v:ext=\"edit\"/></v:shapetype><v:shape fillcolor=\"silver\" id=\"PowerPlusWaterMarkObject357476642\" o:allowincell=\"f\" o:spid=\"_x0000_s2049\" stroked=\"f\" style=\"position:absolute;margin-left:0;margin-top:0;width:527.85pt;height:131.95pt;rotation:315;z-index:-251658752;mso-position-horizontal:center;mso-position-horizontal-relative:margin;mso-position-vertical:center;mso-position-vertical-relative:margin\" type=\"#_x0000_t136\"><v:fill opacity=\".5\"/><v:textpath string=\"" + watermark + "\" style=\"font-family:&quot;Calibri&quot;;font-size:1pt\"/>" + "<w10:wrap anchorx=\"margin\" anchory=\"margin\"/>" + "</v:shape>" + "</w:pict>" + "</w:r>" + "</w:sdtContent>" + "</w:sdt>" + "</w:p>";
        P wp = (P)XmlUtils.unmarshalString((String)openXML);
        List list = hdr.getContent();
        P p = null;
        if (list != null && list.size() > 0) {
            p = (P)list.get(0);
        } else {
            p = factory.createP();
            hdr.getContent().add(p);
        }
        if (p != null) {
            p.getContent().add(wp.getContent().get(0));
        }
    }
}

