/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.excelreport;

import aurora.plugin.excelreport.ExcelFactory;
import aurora.plugin.excelreport.SubtotalConfig;
import aurora.plugin.excelreport.TableColumn;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.composite.transform.GroupConfig;
import uncertain.composite.transform.GroupTransformer;

public class DynamicContent {
    String cell = "A";
    int row = 1;
    String dataModel;
    TableColumn[] tableColumns;
    boolean freezeEnable = false;
    boolean displayTitle = true;
    int totalCount = -1;
    private int rowIndex = 0;
    private Sheet excelSheet;
    ExcelFactory excelFactory;
    Map<String, TableColumn> columnsMap = new HashMap<String, TableColumn>();
    CompositeMap groupMap = new CompositeMap();
    final String KEY_LEVEL_NAME = "level";

    public void createGroupMap() {
        if (this.getColumns() == null) {
            return;
        }
        int level = 0;
        LinkedList<SubtotalConfig> list = new LinkedList<SubtotalConfig>();
        for (TableColumn column : this.getColumns()) {
            SubtotalConfig[] groupConfigs = column.getGroups();
            if (groupConfigs == null) continue;
            for (SubtotalConfig config : groupConfigs) {
                String[] groupFields = config.getGroupField().split(",");
                if (groupFields == null) {
                    throw new RuntimeException("groupField is null");
                }
                for (String groupField : groupFields) {
                    TableColumn groupColumn = this.columnsMap.get(groupField);
                    level = groupColumn.getGroupLevel();
                    if (level == 0) {
                        throw new RuntimeException("groupField:" + groupField + ";groupLevel is null or 0");
                    }
                    CompositeMap record = this.groupMap.getChild(this.KEY_LEVEL_NAME + level);
                    SubtotalConfig configClone = new SubtotalConfig();
                    configClone.setGroupDesc(config.getGroupDesc());
                    configClone.setGroupField(config.getGroupField());
                    configClone.setGroupFormula(config.getGroupFormula());
                    configClone.setTotalDesc(config.getTotalDesc());
                    configClone.setGroupStyle(config.getGroupStyle());
                    configClone.setColumnField(column.getField());
                    configClone.setGroupColumnFild(groupColumn.getField());
                    configClone.setFormulaStyle(config.getFormulaStyle());
                    configClone.setLineStyle(config.getLineStyle());
                    list = (LinkedList<SubtotalConfig>)record.get((Object)"list");
                    if (list == null) {
                        list = new LinkedList<SubtotalConfig>();
                    }
                    list.add(configClone);
                    record.put((Object)"list", list);
                }
            }
        }
    }

    public int createContent(ExcelFactory excelFactory, Sheet excelSheet) {
        this.excelSheet = excelSheet;
        this.excelFactory = excelFactory;
        CompositeMap data = (CompositeMap)excelFactory.getContext().getObject(this.getDataModel());
        if (data == null) {
            this.createTableTitle(excelFactory.getContext());
            return this.rowIndex;
        }
        GroupConfig[] groupConfig = this.createGroupConfig(data);
        this.createTableTitle(excelFactory.getContext());
        if (groupConfig != null) {
            CompositeMap target = GroupTransformer.transform((CompositeMap)data, (GroupConfig[])groupConfig);
            this.createGroupMap();
            this.createTableGroup(target);
        } else {
            Iterator rowIt = data.getChildIterator();
            if (rowIt == null) {
                return this.rowIndex;
            }
            while (rowIt.hasNext()) {
                CompositeMap record = (CompositeMap)rowIt.next();
                this.createRecord(record);
            }
        }
        return this.rowIndex;
    }

    void createTableTitle(CompositeMap context) {
        if (!this.getDisplayTitle()) {
            return;
        }
        if (this.getColumns() == null) {
            return;
        }
        this.rowIndex = this.getRow();
        Row row = ExcelFactory.createRow(this.excelSheet, this.rowIndex);
        int cellnum = CellReference.convertColStringToIndex((String)this.getCell());
        for (TableColumn column : this.getColumns()) {
            Cell cell = ExcelFactory.createCell(row, cellnum++);
            this.excelFactory.setCellValue(cell, TextParser.parse((String)column.getTitle(), (CompositeMap)context));
            CellStyle style = this.excelFactory.getStyle(column.getTitleStyle());
            if (!ExcelFactory.isNotNull(style)) continue;
            cell.setCellStyle(style);
        }
        if (this.getFreezeEnable()) {
            this.excelSheet.createFreezePane(0, this.rowIndex);
        }
    }

    CompositeMap createRecord(CompositeMap record) {
        if (this.getColumns() == null) {
            return null;
        }
        Row row = ExcelFactory.createRow(this.excelSheet, ++this.rowIndex);
        int cellnum = CellReference.convertColStringToIndex((String)this.getCell());
        for (TableColumn column : this.getColumns()) {
            Cell cell = ExcelFactory.createCell(row, cellnum++);
            Object value = record.get((Object)column.getField());
            this.excelFactory.setCellValue(cell, value);
            if (column.getCellStyle() == null || "".equals(column.getCellStyle())) continue;
            cell.setCellStyle(this.excelFactory.getStyle(column.getCellStyle()));
        }
        CompositeMap map = new CompositeMap();
        map.put((Object)"rownum", (Object)this.rowIndex);
        map.put((Object)"record", (Object)record);
        return map;
    }

    GroupConfig[] createGroupConfig(CompositeMap dataModel) {
        if (this.getColumns() == null) {
            return null;
        }
        CompositeMap record = null;
        StringBuffer buffer = null;
        int level = 0;
        int index = CellReference.convertColStringToIndex((String)this.getCell());
        if (this.getColumns()[0].isSubtotalSelf() && index == 0) {
            this.setCell(CellReference.convertNumToColString((int)(++index)));
        }
        CompositeMap levelMap = new CompositeMap();
        for (TableColumn column : this.getColumns()) {
            column.setIndex(index);
            this.putColumnsMap(column.getField(), column);
            level = column.getGroupLevel();
            if (level != 0) {
                buffer = (StringBuffer)levelMap.get((Object)level);
                if (buffer == null) {
                    buffer = new StringBuffer();
                }
                if (buffer.length() != 0) {
                    buffer.append(",");
                }
                buffer.append(column.getField());
                levelMap.put((Object)level, (Object)buffer);
            }
            ++index;
        }
        TreeSet keySet = new TreeSet(levelMap.keySet());
        Iterator iterator = keySet.descendingIterator();
        while (iterator.hasNext()) {
            level = (Integer)iterator.next();
            buffer = (StringBuffer)levelMap.get((Object)level);
            record = new CompositeMap(this.KEY_LEVEL_NAME + level);
            record.put((Object)"group_key_fields", (Object)buffer.toString());
            record.put((Object)"record_name", (Object)(this.KEY_LEVEL_NAME + level));
            this.groupMap.addChild(record);
        }
        if (this.groupMap.getChildIterator() != null) {
            GroupConfig[] configs;
            for (GroupConfig config : configs = GroupConfig.createGroupConfigs((CompositeMap)this.groupMap)) {
                config.setExtendParentAttributes(false);
            }
            return configs;
        }
        return null;
    }

    CompositeMap createGroupData(List<SubtotalConfig> groupList, List<CompositeMap> rowList, boolean is_total) {
        Map<String, TableColumn> columnMap = this.getColumnsMap();
        Iterator<SubtotalConfig> colIt = groupList.iterator();
        String curGroupFormula = null;
        String curField = null;
        Row row = null;
        int firstRownum = 0;
        int endRownum = 0;
        boolean is_flag = false;
        boolean is_group = false;
        while (colIt.hasNext()) {
            SubtotalConfig stConfig = colIt.next();
            TableColumn column = this.getColumnsMap().get(stConfig.getColumnField());
            if (stConfig.getColumnField().equals(curField) || !stConfig.getGroupFormula().equals(curGroupFormula) || stConfig.getColumnField().equals(column.getField())) {
                curGroupFormula = stConfig.getGroupFormula();
                curField = stConfig.getColumnField();
                row = ExcelFactory.createRow(this.excelSheet, ++this.rowIndex);
                is_flag = true;
                is_group = true;
                if (is_total) {
                    ++this.totalCount;
                }
            }
            if (stConfig.getGroupFormula() != null) {
                Cell cell = ExcelFactory.createCell(row, column.getIndex());
                StringBuffer colBuffer = new StringBuffer("SUBTOTAL(");
                colBuffer.append(stConfig.getGroupFormula());
                colBuffer.append(",");
                String ref1 = null;
                String ref2 = null;
                Iterator<CompositeMap> iterator = rowList.iterator();
                String value = null;
                boolean is_first = true;
                while (iterator.hasNext()) {
                    CompositeMap map1 = iterator.next();
                    value = ((CompositeMap)map1.get((Object)"record")).getString((Object)stConfig.getGroupColumnFild());
                    if (is_first) {
                        firstRownum = map1.getInt((Object)"rownum");
                        ref1 = CellReference.convertNumToColString((int)cell.getColumnIndex()) + firstRownum;
                        colBuffer.append(ref1);
                        colBuffer.append(":");
                        is_first = false;
                        continue;
                    }
                    endRownum = map1.getInt((Object)"rownum");
                    ref2 = CellReference.convertNumToColString((int)cell.getColumnIndex()) + endRownum;
                }
                if (ref2 == null) {
                    ref2 = ref1;
                    endRownum = firstRownum;
                }
                colBuffer.append(ref2);
                colBuffer.append(")");
                cell.setCellFormula(colBuffer.toString());
                if (is_flag) {
                    String field = stConfig.getGroupColumnFild();
                    TableColumn groupColumn = columnMap.get(field);
                    int groupColumnFildIndex = groupColumn.getIndex();
                    if (field != null && field.equals(column.getField())) {
                        --groupColumnFildIndex;
                    }
                    Cell groupCell = ExcelFactory.createCell(row, groupColumnFildIndex);
                    if (is_total) {
                        groupCell.setCellValue(stConfig.getTotalDesc());
                    } else {
                        groupCell.setCellValue(value + " " + stConfig.getGroupDesc());
                    }
                    if (ExcelFactory.isNotNull(this.excelFactory.getStyle(stConfig.getGroupStyle()))) {
                        groupCell.setCellStyle(this.excelFactory.getStyle(stConfig.getGroupStyle()));
                    }
                    if (ExcelFactory.isNotNull(this.excelFactory.getStyle(stConfig.getFormulaStyle()))) {
                        cell.setCellStyle(this.excelFactory.getStyle(stConfig.getFormulaStyle()));
                    }
                    int cellnum = CellReference.convertColStringToIndex((String)this.getCell());
                    int tIndex = this.tableColumns.length + cellnum;
                    for (int i = 0 + cellnum; i < tIndex; ++i) {
                        Cell blankCell = row.getCell(i);
                        if (blankCell != null) continue;
                        blankCell = ExcelFactory.createCell(row, i);
                        if (!ExcelFactory.isNotNull(this.excelFactory.getStyle(stConfig.getLineStyle()))) continue;
                        blankCell.setCellStyle(this.excelFactory.getStyle(stConfig.getLineStyle()));
                    }
                }
            }
            if (!is_group) continue;
            if (!is_total) {
                this.excelSheet.groupRow(firstRownum - 1, this.rowIndex - 2);
            }
            is_group = false;
        }
        if (is_total) {
            CompositeMap map = new CompositeMap();
            map.put((Object)"first", (Object)firstRownum);
            map.put((Object)"end", (Object)endRownum);
            return map;
        }
        return null;
    }

    void setMergedRegion(List<CompositeMap> rowList, CompositeMap dataModel) {
        if (dataModel == null) {
            return;
        }
        Iterator<CompositeMap> iterator = rowList.iterator();
        int firstLine = 0;
        int endLine = 0;
        boolean is_first = true;
        while (iterator.hasNext()) {
            int rownum;
            CompositeMap record = iterator.next();
            endLine = rownum = record.getInt((Object)"rownum").intValue();
            if (!is_first) continue;
            firstLine = rownum;
            is_first = false;
        }
        Set keySet = dataModel.keySet();
        for (String levelName : keySet) {
            TableColumn tableColumn = this.getColumnsMap().get(levelName);
            if (!tableColumn.getMerged()) break;
            String colString = CellReference.convertNumToColString((int)tableColumn.getIndex());
            StringBuffer buffer = new StringBuffer();
            buffer.append("$");
            buffer.append(colString);
            buffer.append("$");
            buffer.append(firstLine);
            buffer.append(":");
            buffer.append("$");
            buffer.append(colString);
            buffer.append("$");
            buffer.append(endLine);
            this.excelSheet.addMergedRegion(CellRangeAddress.valueOf((String)buffer.toString()));
        }
    }

    List<CompositeMap> createTableGroup(CompositeMap dataModel) {
        Iterator it = dataModel.getChildIterator();
        LinkedList<CompositeMap> rowList = new LinkedList<CompositeMap>();
        if (it != null) {
            while (it.hasNext()) {
                CompositeMap childMap = (CompositeMap)it.next();
                if (childMap.getChildIterator() != null) {
                    rowList.addAll(this.createTableGroup(childMap));
                    continue;
                }
                rowList.add(this.createRecord(childMap));
            }
            if (rowList.size() != 0) {
                if (dataModel.getName().startsWith(this.KEY_LEVEL_NAME)) {
                    CompositeMap groupMap = this.getGroupMap();
                    String levelName = dataModel.getName();
                    this.setMergedRegion(rowList, dataModel);
                    List list = (List)groupMap.getChild(levelName).get((Object)"list");
                    if (list != null) {
                        this.createGroupData(list, rowList, false);
                    }
                } else {
                    CompositeMap m = null;
                    List a = this.groupMap.getChildsNotNull();
                    int i = 0;
                    for (int l = a.size(); i < l; --l) {
                        CompositeMap record = (CompositeMap)a.get(l - 1);
                        String levelName = record.getName();
                        List list1 = (List)record.get((Object)"list");
                        if (list1 == null) continue;
                        m = this.createGroupData(list1, rowList, true);
                    }
                    if (m != null) {
                        int firstRownum = m.getInt((Object)"first");
                        int endRownum = m.getInt((Object)"end");
                        this.excelSheet.groupRow(firstRownum - 1, endRownum + this.totalCount);
                    }
                }
            }
        }
        return rowList;
    }

    public Map<String, TableColumn> getColumnsMap() {
        return this.columnsMap;
    }

    public void putColumnsMap(String name, TableColumn tableColumn) {
        this.columnsMap.put(name, tableColumn);
    }

    public String getCell() {
        return this.cell;
    }

    public void setCell(String cell) {
        this.cell = cell;
    }

    public String getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(String dataModel) {
        this.dataModel = dataModel;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public void setColumns(TableColumn[] tableColumns) {
        this.tableColumns = tableColumns;
    }

    public TableColumn[] getColumns() {
        return this.tableColumns;
    }

    public CompositeMap getGroupMap() {
        return this.groupMap;
    }

    public boolean getFreezeEnable() {
        return this.freezeEnable;
    }

    public void setFreezeEnable(boolean freezeEnable) {
        this.freezeEnable = freezeEnable;
    }

    public boolean getDisplayTitle() {
        return this.displayTitle;
    }

    public void setDisplayTitle(boolean displayTitle) {
        this.displayTitle = displayTitle;
    }
}

