/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.entity;

import aurora.database.service.BusinessModelService;
import aurora.database.service.DatabaseServiceFactory;
import aurora.plugin.entity.AbstractBMModelCreator;
import aurora.plugin.entity.model.BMModel;
import aurora.plugin.entity.model.DataType;
import aurora.plugin.entity.model.EditorType;
import aurora.plugin.entity.model.ModelUtil;
import aurora.plugin.entity.model.PkRecord;
import aurora.plugin.entity.model.Record;
import aurora.plugin.entity.model.Relation;
import aurora.plugin.source.gen.screen.model.asm.PageGenerator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class BMModelCreator
extends AbstractBMModelCreator {
    private BMModel model;
    private CompositeMap parentEntityMap;
    private CompositeMap fieldsMap;
    private CompositeMap entityMap;

    public BMModelCreator(DatabaseServiceFactory svcFactory, CompositeMap context) {
        super(svcFactory, context);
    }

    @Override
    public BMModel create(CompositeMap entityMap) throws Exception {
        this.entityMap = entityMap;
        this.fieldsMap = this.getEntityFields(entityMap.get((Object)"entity_id"));
        this.parentEntityMap = this.getEntity(entityMap.get((Object)"parent_entity"));
        this.model = new BMModel();
        List<CompositeMap> list = this.fieldsMap.getChilds();
        if (list == null) {
            list = Collections.emptyList();
        }
        PkRecord pkr = new PkRecord();
        String pk_name = this.getParsedPattern(this.config.getPkRecordNamePattern(), entityMap);
        pkr.setName(pk_name);
        this.model.setPkRecord(pkr);
        String entity_name = this.getParsedPattern(this.config.getEntityNamePattern(), entityMap);
        entityMap.put((Object)"name", (Object)entity_name);
        entityMap.put((Object)"status", (Object)"GEN");
        this.model.setName(entity_name);
        boolean findFirstTextField = false;
        for (CompositeMap m : list) {
            Record r = this.createRecordFromMap(this.model, m);
            this.model.add(r);
            if (findFirstTextField || !r.getType().equals(DataType.TEXT.getDisplayType())) continue;
            findFirstTextField = true;
            this.model.setDefaultDisplay(r.getPrompt());
        }
        return this.model;
    }

    @Override
    public void updateBack() throws Exception {
        this.updateEntity(this.entityMap);
        BusinessModelService service = this.getDatabaseServiceFactory().getModelService(this.config.entityFieldModel, this.getContext());
        List list = this.fieldsMap.getChildsNotNull();
        for (CompositeMap m : list) {
            service.updateByPK((Map)m);
        }
    }

    private Record createRecordFromMap(BMModel model, CompositeMap map) throws Exception {
        Record r = new Record();
        r.setPrompt(map.getString((Object)"prompt"));
        String type = map.getString((Object)"type");
        DataType dt = DataType.fromString(type);
        if (dt == null) {
            dt = DataType.TEXT;
        }
        r.setType(dt.getDisplayType());
        String pattern = this.config.getEntityColumnNamePattern();
        CompositeMap para = map;
        if (r.getType().equals("reference")) {
            CompositeMap m_ = this.getOptionParent(map.get((Object)"source"));
            pattern = this.config.getPkRecordNamePattern();
            para = m_;
            if (ModelUtil.eq(m_.get((Object)"entity_id"), this.parentEntityMap.get((Object)"entity_id"))) {
                r.setInsertExpression("${../../@" + this.getParsedPattern(pattern, para) + "}");
                r.put("queryfield", true);
                r.put("query_op", "=");
                r.setForUpdate(false);
            } else {
                Relation rel = new Relation();
                rel.setName("rel_" + this.getParsedPattern(pattern, para));
                rel.setLocalField(r.getPrompt());
                rel.setSrcField("");
                rel.setJoinType("LEFT OUTER");
                rel.setRefPrompts("");
                model.add(rel);
            }
        }
        r.setName(this.getParsedPattern(pattern, para));
        map.put((Object)"name", (Object)r.getName());
        r.setEditor(EditorType.toNormalCase(map.getString((Object)"editor")));
        String query_op = map.getString((Object)"query_op");
        if (query_op != null) {
            query_op = query_op.toLowerCase();
            r.put("queryfield", true);
            r.put("query_op", query_op);
        }
        Object options = map.get((Object)"source");
        if (r.getType().equals("reference")) {
            r.put("options", this.config.getEntityPath() + "." + this.getOptionName(options));
        } else {
            r.put("options", options);
        }
        r.put("field_id", map.getInt((Object)"field_id"));
        return r;
    }

    private String getOptionName(Object entityId) {
        try {
            CompositeMap map = this.getEntity(entityId);
            return this.getExtEntityName(map);
        }
        catch (Exception exception) {
            return "_exception_";
        }
    }

    private CompositeMap getOptionParent(Object source) throws Exception {
        CompositeMap entity = this.getEntity(source);
        entity = this.getEntity(entity.get((Object)"parent_entity"));
        return entity;
    }

    private String getParsedPattern(String pattern, CompositeMap para) {
        return TextParser.parse((String)pattern, (CompositeMap)para);
    }

    private CompositeMap getEntityFields(Object entityId) throws Exception {
        CompositeMap para = new CompositeMap();
        para.put((Object)"entity_id", entityId);
        return PageGenerator.query(this.getDatabaseServiceFactory(), this.getContext(), this.config.entityFieldModel, para);
    }
}

