/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.ConfigurationFileException;
import uncertain.ocm.OCManager;
import uncertain.proc.EntryList;
import uncertain.proc.Field;
import uncertain.proc.IEntry;
import uncertain.proc.ProcedureRunner;

public class Procedure
extends EntryList {
    OCManager oc_manager;
    HashMap field_map;
    LinkedList field_list;
    Field return_field;
    LinkedList input_fields;
    Collection exception_handles;
    String participants;
    LinkedList participant_class_list;
    boolean Debug = false;

    public Procedure() {
    }

    public Procedure(OCManager om) {
        this.oc_manager = om;
    }

    void populateContextFields(ProcedureRunner runner) throws Exception {
        List inputs = this.getInputFieldList();
        if (inputs == null) {
            return;
        }
        runner.transferContextFields(inputs, true);
    }

    void addDefaultParticipants(ProcedureRunner runner) throws Exception {
        for (Class cls : this.participant_class_list) {
            Object p = null;
            p = this.oc_manager != null ? this.oc_manager.getObjectCreator().createInstance(cls) : (Object)cls.newInstance();
            runner.getConfiguration().addParticipant(p);
        }
    }

    void clearFields(CompositeMap map) {
        if (this.field_list == null) {
            return;
        }
        for (Field f : this.field_list) {
            if (f.isInputField()) continue;
            map.putObject(f.getPath(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(ProcedureRunner runner) throws Exception {
        boolean need_pop = false;
        try {
            this.populateContextFields(runner);
            if (this.exception_handles != null) {
                runner.pushExceptionHandle(this.exception_handles);
                need_pop = true;
            }
            if (this.participant_class_list != null) {
                this.addDefaultParticipants(runner);
            }
            runner.run(this);
        }
        finally {
            if (need_pop) {
                runner.popExceptionHandle();
            }
        }
    }

    @Override
    public void addChild(CompositeMap child) {
        if (this.oc_manager == null) {
            return;
        }
        if (!this.oc_manager.canCreateInstance(child)) {
            throw BuiltinExceptionFactory.createUnknownChild(child);
        }
        Object o = this.oc_manager.createObject(child);
        if (o != null) {
            if (o instanceof IEntry) {
                this.addEntry((IEntry)o);
            } else {
                String text = child.toXML();
                ConfigurationFileException ex = new ConfigurationFileException("uncertain.proc.child_not_entry", new Object[]{text}, null, child);
                throw ex;
            }
        }
    }

    public void addField(Field f) {
        if (this.field_map == null) {
            this.field_map = new HashMap();
            this.field_list = new LinkedList();
            this.input_fields = new LinkedList();
        }
        this.field_map.put(f.getName(), f);
        this.field_list.add(f);
        if (f.isReturnField()) {
            this.return_field = f;
        } else if (f.isInputField()) {
            this.input_fields.add(f);
        }
    }

    public Field getField(String name) {
        Procedure parent_proc;
        Field f = null;
        if (this.field_map != null) {
            f = (Field)this.field_map.get(name);
        }
        if (f != null) {
            return f;
        }
        IEntry root = this.getRootOwner();
        if (root != null && root instanceof Procedure) {
            f = ((Procedure)root).getField(name);
        }
        if (f == null && (parent_proc = this.getParentProcedure()) != null) {
            f = parent_proc.getField(name);
        }
        return f;
    }

    public Procedure getParentProcedure() {
        for (IEntry p = this.getOwner(); p != null; p = p.getOwner()) {
            if (!(p instanceof Procedure)) continue;
            return (Procedure)p;
        }
        return null;
    }

    public Field getReturnField() {
        return this.return_field;
    }

    public void setFields(Field[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            this.addField(fields[i]);
        }
    }

    public Field[] getFields() {
        if (this.field_map == null) {
            return null;
        }
        Object[] o = this.field_list.toArray();
        Field[] f = new Field[o.length];
        System.arraycopy(o, 0, f, 0, o.length);
        return f;
    }

    public Map getContextFieldMap() {
        return this.field_map;
    }

    public List getInputFieldList() {
        return this.input_fields;
    }

    public void setExceptionHandles(Collection handles) {
        if (this.exception_handles == null) {
            this.exception_handles = handles;
        } else {
            this.exception_handles.addAll(handles);
        }
        for (IEntry entry : handles) {
            entry.setOwner(this);
        }
    }

    public Collection getExceptionHandles() {
        return this.exception_handles;
    }

    public String getParticipants() {
        return this.participants;
    }

    public void setParticipants(String participants) throws ClassNotFoundException {
        this.participants = participants;
        if (this.participant_class_list != null) {
            this.participant_class_list.clear();
        } else {
            this.participant_class_list = new LinkedList();
        }
        String[] classes = participants.split(",");
        for (int i = 0; i < classes.length; ++i) {
            String cls = classes[i].trim();
            this.participant_class_list.add(Class.forName(cls));
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this.field_map != null) {
            this.field_map.clear();
        }
        if (this.field_list != null) {
            this.field_list.clear();
        }
        if (this.input_fields != null) {
            this.input_fields.clear();
        }
        if (this.exception_handles != null) {
            this.exception_handles.clear();
        }
        if (this.participant_class_list != null) {
            this.participant_class_list.clear();
        }
    }
}

