/*
 * Decompiled with CFR 0.152.
 */
package uncertain.ocm.mbean;

import java.lang.reflect.Constructor;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import uncertain.mbean.IMBeanNameProvider;
import uncertain.mbean.IMBeanRegister;
import uncertain.mbean.IMBeanRegistrable;
import uncertain.ocm.ObjectRegistryImpl;
import uncertain.ocm.mbean.InstanceMapping;
import uncertain.ocm.mbean.ObjectRegistryImplWrapperMBean;

public class ObjectRegistryImplWrapper
implements ObjectRegistryImplWrapperMBean,
IMBeanRegistrable {
    ObjectRegistryImpl objectRegistry;

    public ObjectRegistryImplWrapper(ObjectRegistryImpl objectRegistry) {
        this.objectRegistry = objectRegistry;
    }

    @Override
    public String getConstructorName(String class_name) throws ClassNotFoundException {
        Class<?> cls = Class.forName(class_name);
        Constructor cst = this.objectRegistry.getConstructor(cls);
        return cst == null ? null : cst.toGenericString();
    }

    @Override
    public boolean canCreateInstance(String class_name) throws ClassNotFoundException {
        Class<?> cls = Class.forName(class_name);
        return this.objectRegistry.canCreateInstance(cls);
    }

    @Override
    public int getInstanceMappingCount() {
        return this.objectRegistry.getInstanceMapping().size();
    }

    @Override
    public void registerMBean(IMBeanRegister register, IMBeanNameProvider name_provider) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        String reg_name = name_provider.getMBeanName("BuiltinInstances", "instanceType=IObjectRegistry");
        register.register(reg_name, this);
        Map mappings = this.objectRegistry.getInstanceMapping();
        for (Map.Entry entry : mappings.entrySet()) {
            Class cls = (Class)entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            String by_type = cls.isInterface() ? "By_Interface" : "By_Class";
            String n = name_provider.getMBeanName("BuiltinInstances", "instanceType=IObjectRegistry,Array=InstanceMappings,RegistrationType=" + by_type + ",className=" + cls.getName());
            register.register(n, new InstanceMapping(cls, value));
        }
    }
}

