/*
 * Decompiled with CFR 0.152.
 */
package uncertain.datatype;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import uncertain.datatype.AbstractDataType;
import uncertain.datatype.ConvertionException;
import uncertain.datatype.DataType;

public class BigDecimalType
extends AbstractDataType
implements DataType {
    @Override
    public Class getJavaType() {
        return BigDecimal.class;
    }

    @Override
    public int getSqlType() {
        return -5;
    }

    @Override
    public Object getObject(CallableStatement stmt, int id) throws SQLException {
        return stmt.getBigDecimal(id);
    }

    @Override
    public Object getObject(ResultSet rs, int id) throws SQLException {
        return rs.getBigDecimal(id);
    }

    @Override
    public void registerParameter(CallableStatement stmt, int id) throws SQLException {
        stmt.registerOutParameter(id, -5);
    }

    @Override
    public void setParameter(PreparedStatement stmt, int id, Object value) throws SQLException {
        if (value == null) {
            stmt.setNull(id, this.getSqlType());
        } else {
            stmt.setBigDecimal(id, (BigDecimal)value);
        }
    }

    @Override
    public Object convert(Object value) throws ConvertionException {
        if (value instanceof String) {
            if (((String)value).length() == 0) {
                return null;
            }
            try {
                return new BigDecimal((String)value);
            }
            catch (NumberFormatException ex) {
                throw new ConvertionException("Can't convert from string to BigDecimal", ex);
            }
        }
        if (value instanceof Number) {
            return new BigDecimal(((Number)value).toString());
        }
        return null;
    }
}

