/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.http;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ImageCodeServlet
extends HttpServlet {
    public static final String VALIDATE_CODE = "validate_code";
    private static final long serialVersionUID = 1L;
    private static int WIDTH = 78;
    private static int HEIGHT = 20;
    private static int LENGTH = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        response.setContentType("image/jpeg");
        ServletOutputStream sos = response.getOutputStream();
        response.setHeader("cache-control", "must-revalidate");
        response.setHeader("pragma", "public");
        response.setHeader("Expires", "0");
        BufferedImage image = new BufferedImage(WIDTH, HEIGHT, 1);
        Graphics g = image.getGraphics();
        char[] rands = ImageCodeServlet.generateCheckCode();
        try {
            this.drawBackground(g);
            this.drawRands(g, rands);
            g.dispose();
            ImageIO.write((RenderedImage)image, "jpg", (OutputStream)sos);
            sos.flush();
        }
        finally {
            sos.close();
        }
        session.setAttribute(VALIDATE_CODE, (Object)new String(rands));
    }

    private static char[] generateCheckCode() {
        String chars = "23456789ABCDEFGHJKLMNPQRSTUVWXYZ";
        char[] rands = new char[LENGTH];
        for (int i = 0; i < LENGTH; ++i) {
            int rand = (int)(Math.random() * 32.0);
            rands[i] = chars.charAt(rand);
        }
        return rands;
    }

    private void drawRands(Graphics g, char[] rands) {
        g.setColor(Color.BLACK);
        g.setFont(new Font(null, 3, 18));
        g.drawString("" + rands[0], 1, 17);
        g.drawString("" + rands[1], 16, 15);
        g.drawString("" + rands[2], 31, 18);
        g.drawString("" + rands[3], 46, 16);
        g.drawString("" + rands[4], 61, 14);
    }

    private void drawBackground(Graphics g) {
        g.setColor(new Color(0xFFFFFF));
        g.fillRect(0, 0, WIDTH, HEIGHT);
        for (int i = 0; i < 120; ++i) {
            int x = (int)(Math.random() * (double)WIDTH);
            int y = (int)(Math.random() * (double)HEIGHT);
            int red = (int)(Math.random() * 255.0);
            int green = (int)(Math.random() * 255.0);
            int blue = (int)(Math.random() * 255.0);
            g.setColor(new Color(red, green, blue));
            g.drawOval(x, y, 1, 0);
        }
        g.drawLine(0, 5, 100, 5);
        g.drawLine(0, 10, 100, 10);
        g.drawLine(0, 15, 100, 15);
    }
}

