/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.markup;

import aurora.presentation.ViewContext;
import aurora.presentation.markup.Attributes;
import java.util.Map;

public class HTMLContent {
    public static final String KEY_CLASS = "class";
    public static final String KEY_STYLE = "html.style";
    public static final String KEY_NAME = "name";
    public static final String KEY_ID = "id";
    public static final String KEY_ATTRIBUTES = "attributes";
    public static final String KEY_HTML_EVENT_HANDLES = "html.event.handles";
    Map context_map;

    public HTMLContent(ViewContext context) {
        this.context_map = context.getMap();
    }

    public HTMLContent(Map map) {
        this.context_map = map;
    }

    public Attributes getAttributes(String key) {
        Attributes a = (Attributes)this.context_map.get(key);
        if (a == null) {
            a = new Attributes();
            this.context_map.put(key, a);
        }
        return a;
    }

    public Attributes getHtmlAttributes() {
        return this.getAttributes(KEY_ATTRIBUTES);
    }

    public void setName(String name) {
        this.context_map.put(KEY_NAME, name);
    }

    public void setHtmlClass(String class_name) {
        this.context_map.put(KEY_CLASS, class_name);
    }

    public void addEventHandle(String event_name, String script_content) {
        event_name = event_name.toLowerCase();
        Attributes events = this.getAttributes(KEY_HTML_EVENT_HANDLES);
        StringBuffer buf = (StringBuffer)events.get(event_name);
        if (buf == null) {
            buf = new StringBuffer();
            events.put(event_name, buf);
        }
        buf.append(script_content);
    }

    public Map getEventHandles() {
        return (Map)this.context_map.get(KEY_HTML_EVENT_HANDLES);
    }
}

