/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std.config;

import aurora.presentation.component.std.config.ComponentConfig;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;

public class DashboardConfig
extends ComponentConfig {
    public static final String VERSION = "$Revision: 6976 $";
    public static final String TAG_NAME = "dashboard";
    public static final String PROPERTITY_CHART = "chart";
    private static final String PROPERTITY_ALIGN = "align";
    private static final String PROPERTITY_VERTICAL_ALIGN = "verticalAlign";
    private static final String PROPERTITY_PADDING = "padding";
    private static final String PROPERTITY_MAX = "max";
    private static final String PROPERTITY_MIN = "min";
    private static final String PROPERTITY_MARGIN_TOP = "marginTop";
    private static final String PROPERTITY_MARGIN_LEFT = "marginLeft";
    private static final String PROPERTITY_MARGIN_BOTTOM = "marginBottom";
    private static final String PROPERTITY_MARGIN_RIGHT = "marginRight";
    private static final String PROPERTITY_BORDER_COLOR = "borderColor";
    private static final String PROPERTITY_BORDER_WIDTH = "borderWidth";
    private static final String PROPERTITY_BORDER_RADIUS = "borderRadius";
    private static final String PROPERTITY_BACKGROUND_COLOR = "backgroundColor";
    public static final String PROPERTITY_BOARD = "board";
    private static final String PROPERTITY_BOARD_START_ANGLE = "startAngle";
    private static final String PROPERTITY_BOARD_END_ANGLE = "endAngle";
    private static final String PROPERTITY_BOARD_WIDTH = "width";
    private static final String PROPERTITY_BOARD_FILL_COLOR = "fillColor";
    private static final String PROPERTITY_BOARD_FILL_OPACITY = "fillOpacity";
    private static final String PROPERTITY_BOARD_BORDER_COLOR = "borderColor";
    private static final String PROPERTITY_BOARD_BORDER_WIDTH = "borderWidth";
    private static final String PROPERTITY_BOARD_ALLOW_DECIMALS = "allowDecimals";
    private static final String PROPERTITY_BOARD_TICK_COLOR = "tickColor";
    private static final String PROPERTITY_BOARD_TICK_LENGTH = "tickLength";
    private static final String PROPERTITY_BOARD_TICK_WIDTH = "tickWidth";
    private static final String PROPERTITY_BOARD_TICK_POSITION = "tickPosition";
    private static final String PROPERTITY_BOARD_TICK_INTERVAL = "tickInterval";
    private static final String PROPERTITY_BOARD_TICK_ANGLE_INTERVAL = "tickAngleInterval";
    private static final String PROPERTITY_BOARD_TICK_START_ANGLE = "tickStartAngle";
    private static final String PROPERTITY_BOARD_TICK_END_ANGLE = "tickEndAngle";
    private static final String PROPERTITY_BOARD_MINOR_TICK_COLOR = "minorTickColor";
    private static final String PROPERTITY_BOARD_MINOR_TICK_WIDTH = "minorTickWidth";
    private static final String PROPERTITY_BOARD_MINOR_TICK_LENGTH = "minorTickLength";
    private static final String PROPERTITY_BOARD_MINOR_TICK_POSITION = "minorTickPosition";
    private static final String PROPERTITY_BOARD_MARGINAL_TICK_COLOR = "marginalTickColor";
    private static final String PROPERTITY_BOARD_MARGINAL_TICK_WIDTH = "marginalTickWidth";
    private static final String PROPERTITY_BOARD_MARGINAL_TICK_LENGTH = "marginalTickLength";
    private static final String PROPERTITY_BOARD_START_ON_TICK = "startOntick";
    private static final String PROPERTITY_BOARD_END_ON_TICK = "endOntick";
    private static final String PROPERTITY_BOARD_SHOW_FIRST_LABEL = "showFirstLabel";
    private static final String PROPERTITY_BOARD_SHOW_LAST_LABEL = "showLastLabel";
    private static final String PROPERTITY_LABELS = "labels";
    private static final String PROPERTITY_LABELS_ENABLED = "enabled";
    private static final String PROPERTITY_LABELS_ROTATION = "rotation";
    private static final String PROPERTITY_LABELS_X = "x";
    private static final String PROPERTITY_LABELS_Y = "y";
    private static final String PROPERTITY_LABELS_STYLE = "style";
    public static final String PROPERTITY_POINTER = "pointer";
    private static final String PROPERTITY_POINTER_WIDTH = "width";
    private static final String PROPERTITY_POINTER_DIST = "dist";
    private static final String PROPERTITY_POINTER_FILLCOLOR = "fillColor";
    private static final String PROPERTITY_POINTER_FILL_OPACITY = "fillOpacity";
    private static final String PROPERTITY_POINTER_BORDER_COLOR = "borderColor";
    private static final String PROPERTITY_POINTER_BORDER_WIDTH = "borderWidth";
    public static final String PROPERTITY_TITLE = "title";
    private static final String PROPERTITY_TITLE_TEXT = "text";
    private static final String PROPERTITY_TITLE_ALIGN = "align";
    private static final String PROPERTITY_TITLE_VERTICAL_ALIGN = "verticalAlign";
    private static final String PROPERTITY_TITLE_MARGIN = "margin";
    private static final String PROPERTITY_TITLE_X = "x";
    private static final String PROPERTITY_TITLE_Y = "y";
    private static final String PROPERTITY_TITLE_STYLE = "style";
    public static final int DEFAULT_WIDTH = 300;
    public static final int DEFAULT_HEIGHT = 300;

    public static DashboardConfig getInstance() {
        DashboardConfig model = new DashboardConfig();
        model.initialize(DashboardConfig.createContext(null, TAG_NAME));
        return model;
    }

    public static DashboardConfig getInstance(CompositeMap context) {
        DashboardConfig model = new DashboardConfig();
        model.initialize(DashboardConfig.createContext(context, TAG_NAME));
        return model;
    }

    private void putStringCfg(CompositeMap view, String key, Map map) {
        String value = view.getString(key.toLowerCase());
        if (value != null) {
            map.put(key, value);
        }
    }

    private void putIntCfg(CompositeMap view, String key, Map map) {
        Integer value = view.getInt(key.toLowerCase());
        if (value != null) {
            map.put(key, value);
        }
    }

    private void putFloatCfg(CompositeMap view, String key, Map map) {
        Float value = view.getFloat(key.toLowerCase());
        if (value != null) {
            map.put(key, value);
        }
    }

    private void putLongCfg(CompositeMap view, String key, Map map) {
        Long value = view.getLong(key.toLowerCase());
        if (value != null) {
            map.put(key, value);
        }
    }

    private void putBooleanCfg(CompositeMap view, String key, Map map) {
        Boolean value = view.getBoolean(key.toLowerCase());
        if (value != null) {
            map.put(key, value);
        }
    }

    private String hump(String str) {
        String[] strs = str.split("-");
        int length = strs.length;
        if (length == 1) {
            return strs[0];
        }
        StringBuffer sb = new StringBuffer(strs[0]);
        for (int i = 1; i < length; ++i) {
            sb.append(strs[i].replaceAll("^.", new String(new char[]{strs[i].charAt(0)}).toUpperCase()));
        }
        return sb.toString();
    }

    private void putStyleCfg(CompositeMap view, String key, Map map) {
        String value = view.getString(key.toLowerCase());
        if (value != null) {
            JSONObject smap = new JSONObject();
            String[] sts = value.split(";");
            for (int i = 0; i < sts.length; ++i) {
                String style = sts[i];
                if ("".equals(style) || style.indexOf(":") == -1) continue;
                String[] vs = style.split(":");
                String k = this.hump(vs[0]);
                String v = vs[1];
                v = v.replaceAll("'", "");
                Integer iv = null;
                try {
                    iv = Integer.valueOf(v);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (iv == null) {
                        smap.put(k, v);
                        continue;
                    }
                    smap.put(k, iv);
                    continue;
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            map.put(key, smap);
        }
    }

    public JSONObject getChart() {
        CompositeMap view = this.getObjectContext();
        HashMap<String, Integer> cfg = new HashMap<String, Integer>();
        cfg.put("width", new Integer(view.getInt("width", 300)));
        cfg.put("height", new Integer(view.getInt("height", 300)));
        this.putStringCfg(view, "align", cfg);
        this.putStringCfg(view, "verticalAlign", cfg);
        this.putIntCfg(view, PROPERTITY_PADDING, cfg);
        this.putIntCfg(view, PROPERTITY_MAX, cfg);
        this.putIntCfg(view, PROPERTITY_MIN, cfg);
        this.putIntCfg(view, PROPERTITY_MARGIN_TOP, cfg);
        this.putIntCfg(view, PROPERTITY_MARGIN_LEFT, cfg);
        this.putIntCfg(view, PROPERTITY_MARGIN_BOTTOM, cfg);
        this.putIntCfg(view, PROPERTITY_MARGIN_RIGHT, cfg);
        this.putStringCfg(view, "borderColor", cfg);
        this.putIntCfg(view, "borderWidth", cfg);
        this.putIntCfg(view, PROPERTITY_BORDER_RADIUS, cfg);
        this.putStringCfg(view, PROPERTITY_BACKGROUND_COLOR, cfg);
        return new JSONObject(cfg);
    }

    public JSONObject getBoard() {
        CompositeMap view = this.getObjectContext().getChild(PROPERTITY_BOARD);
        HashMap cfg = new HashMap();
        if (null != view) {
            this.putIntCfg(view, PROPERTITY_BOARD_START_ANGLE, cfg);
            this.putIntCfg(view, PROPERTITY_BOARD_END_ANGLE, cfg);
            this.putStringCfg(view, "width", cfg);
            this.putStringCfg(view, "fillColor", cfg);
            this.putFloatCfg(view, "fillOpacity", cfg);
            this.putStringCfg(view, "borderColor", cfg);
            this.putIntCfg(view, "borderWidth", cfg);
            this.putBooleanCfg(view, PROPERTITY_BOARD_ALLOW_DECIMALS, cfg);
            this.putStringCfg(view, PROPERTITY_BOARD_TICK_COLOR, cfg);
            this.putIntCfg(view, PROPERTITY_BOARD_TICK_LENGTH, cfg);
            this.putIntCfg(view, PROPERTITY_BOARD_TICK_WIDTH, cfg);
            this.putStringCfg(view, PROPERTITY_BOARD_TICK_POSITION, cfg);
            this.putFloatCfg(view, PROPERTITY_BOARD_TICK_INTERVAL, cfg);
            this.putFloatCfg(view, PROPERTITY_BOARD_TICK_ANGLE_INTERVAL, cfg);
            this.putIntCfg(view, PROPERTITY_BOARD_TICK_START_ANGLE, cfg);
            this.putIntCfg(view, PROPERTITY_BOARD_TICK_END_ANGLE, cfg);
            this.putStringCfg(view, PROPERTITY_BOARD_MINOR_TICK_COLOR, cfg);
            this.putIntCfg(view, PROPERTITY_BOARD_MINOR_TICK_WIDTH, cfg);
            this.putIntCfg(view, PROPERTITY_BOARD_MINOR_TICK_LENGTH, cfg);
            this.putStringCfg(view, PROPERTITY_BOARD_MINOR_TICK_POSITION, cfg);
            this.putStringCfg(view, PROPERTITY_BOARD_MARGINAL_TICK_COLOR, cfg);
            this.putIntCfg(view, PROPERTITY_BOARD_MARGINAL_TICK_WIDTH, cfg);
            this.putIntCfg(view, PROPERTITY_BOARD_MARGINAL_TICK_LENGTH, cfg);
            this.putBooleanCfg(view, PROPERTITY_BOARD_START_ON_TICK, cfg);
            this.putBooleanCfg(view, PROPERTITY_BOARD_END_ON_TICK, cfg);
            this.putBooleanCfg(view, PROPERTITY_BOARD_SHOW_FIRST_LABEL, cfg);
            this.putBooleanCfg(view, PROPERTITY_BOARD_SHOW_LAST_LABEL, cfg);
            this.processLabels(view, cfg);
        }
        if (cfg.isEmpty()) {
            return null;
        }
        return new JSONObject(cfg);
    }

    public JSONObject getPointer() {
        CompositeMap view = this.getObjectContext().getChild(PROPERTITY_POINTER);
        HashMap cfg = new HashMap();
        if (null != view) {
            this.putIntCfg(view, "width", cfg);
            this.putIntCfg(view, PROPERTITY_POINTER_DIST, cfg);
            this.putStringCfg(view, "fillColor", cfg);
            this.putFloatCfg(view, "fillOpacity", cfg);
            this.putStringCfg(view, "borderColor", cfg);
            this.putIntCfg(view, "borderWidth", cfg);
            this.processLabels(view, cfg);
        }
        if (cfg.isEmpty()) {
            return null;
        }
        return new JSONObject(cfg);
    }

    public JSONObject getTitle() {
        CompositeMap view = this.getObjectContext().getChild(PROPERTITY_TITLE);
        HashMap cfg = new HashMap();
        if (null != view) {
            this.putStringCfg(view, PROPERTITY_TITLE_TEXT, cfg);
            this.putStringCfg(view, "align", cfg);
            this.putStringCfg(view, "verticalAlign", cfg);
            this.putIntCfg(view, PROPERTITY_TITLE_MARGIN, cfg);
            this.putFloatCfg(view, "x", cfg);
            this.putFloatCfg(view, "y", cfg);
            this.putStringCfg(view, "borderColor", cfg);
            this.putStyleCfg(view, "style", cfg);
        }
        if (cfg.isEmpty()) {
            return null;
        }
        return new JSONObject(cfg);
    }

    private void processLabels(CompositeMap parent, Map map) {
        CompositeMap view = parent.getChild(PROPERTITY_LABELS);
        HashMap cfg = new HashMap();
        if (null != view) {
            this.putBooleanCfg(view, PROPERTITY_LABELS_ENABLED, cfg);
            this.putIntCfg(view, PROPERTITY_LABELS_ROTATION, cfg);
            this.putStyleCfg(view, "style", cfg);
            this.putIntCfg(view, "x", cfg);
            this.putIntCfg(view, "y", cfg);
        }
        if (!cfg.isEmpty()) {
            map.put(PROPERTITY_LABELS, new JSONObject(cfg));
        }
    }
}

