/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.config.TreeConfig;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;

public class Tree
extends Component {
    public static final String VERSION = "$Revision: 7048 $";
    private static final String DEFAULT_CLASS = "item-tree";
    public static final String CONFIG_CONTEXT = "context";

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return DEFAULT_CLASS;
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addStyleSheet(session, context, "tree/Tree-min.css");
        this.addJavaScript(session, context, "tree/Tree-min.js");
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        String height;
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        CompositeMap view = context.getView();
        TreeConfig tc = TreeConfig.getInstance(view);
        String size = "";
        String width = tc.getWidthStr();
        if (!"".endsWith(width)) {
            size = size + "width:" + width + "px;";
            this.addConfig("width", width);
        }
        if (!"".endsWith(height = tc.getHeightStr())) {
            size = size + "height:" + height + "px;";
            this.addConfig("height", height);
        }
        map.put("size", size);
        if (session.getContextPath() != null) {
            this.addConfig(CONFIG_CONTEXT, session.getContextPath() + "/");
        }
        this.addConfig("displayfield", tc.getDisplayField());
        if (tc.getRenderer() != null) {
            this.addConfig("renderer", tc.getRenderer());
        }
        this.addConfig("idfield", tc.getIdField());
        this.addConfig("parentfield", tc.getParentField());
        this.addConfig("showcheckbox", new Boolean(tc.isShowCheckBox()));
        this.addConfig("checkfield", tc.getCheckField());
        this.addConfig("expandfield", tc.getExpandField());
        this.addConfig("sequencefield", tc.getSequenceField());
        this.addConfig("iconfield", tc.getIconField());
        map.put("config", this.getConfigString());
    }
}

