/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.application.ApplicationConfig;
import aurora.application.ApplicationViewConfig;
import aurora.application.IApplicationConfig;
import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.IDGenerator;
import aurora.presentation.component.std.config.GridColumnConfig;
import aurora.presentation.component.std.config.GridConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeUtil;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class Grid
extends Component {
    public static final String VERSION = "$Revision: 7126 $";
    public static final String HTML_LOCKAREA = "lockarea";
    public static final String HTML_UNLOCKAREA = "unlockarea";
    private static final int DEFALUT_HEAD_HEIGHT = 25;
    private static final int COLUMN_WIDTH = 100;
    private static final String DEFAULT_CLASS = "item-grid-wrap";
    private static final String MAX_ROWS = "maxRow";
    private static final String ROW_SPAN = "rowspan";
    private static final String COL_SPAN = "colspan";
    private static final String ROW_HEIGHT = "rowHeight";
    private static final String HEAD_HEIGHT = "headHeight";
    private static final String LOCK_WIDTH = "lockwidth";
    private static final String UNLOCK_WIDTH = "unlockwidth";
    private static final String BODY_HEIGHT = "bodyHeight";
    private static final String TABLE_HEIGHT = "tableHeight";
    private static final String FOOTER_BAR = "footerBar";
    private static final String LOCK_COLUMNS = "lockcolumns";
    private static final String UNLOCK_COLUMNS = "unlockcolumns";
    private static final String COLUMN_TYPE = "type";
    private static final String TYPE_CELL_CHECKBOX = "cellcheck";
    private static final String TYPE_ROW_CHECKBOX = "rowcheck";
    private static final String TYPE_ROW_RADIO = "rowradio";
    private static final String TYPE_ROW_NUMBER = "rownumber";
    private IObjectRegistry mRegistry;
    private ApplicationConfig mApplicationConfig;

    public Grid(IObjectRegistry registry) {
        this.mRegistry = registry;
        this.mApplicationConfig = (ApplicationConfig)this.mRegistry.getInstanceOfType(IApplicationConfig.class);
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addStyleSheet(session, context, "grid/Grid-min.css");
        this.addJavaScript(session, context, "grid/Grid-min.js");
    }

    @Override
    protected int getDefaultWidth() {
        return 800;
    }

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return DEFAULT_CLASS;
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        CompositeMap view = context.getView();
        int mDefaultMarginSize = -1;
        ApplicationViewConfig view_config = this.mApplicationConfig.getApplicationViewConfig();
        if (view_config != null) {
            mDefaultMarginSize = view_config.getDefaultMarginWidth();
        }
        if (mDefaultMarginSize != -1) {
            view.putInt("marginwidth", mDefaultMarginSize);
        }
        CompositeMap model = context.getModel();
        super.onCreateViewContent(session, context);
        GridConfig gc = GridConfig.getInstance(view);
        Map map = context.getMap();
        boolean hasToolBar = this.creatToolBar(session, context);
        boolean hasFooterBar = this.hasFooterBar(gc.getColumns());
        boolean hasNavBar = this.createNavgationToolBar(session, context);
        String style = "";
        if (hasToolBar) {
            style = style + "border-top:none;";
        }
        if (hasNavBar || hasFooterBar) {
            style = style + "border-bottom:none;";
        }
        Integer height = (Integer)map.get("height");
        int sh = 0;
        if (hasToolBar) {
            sh += 25;
        }
        if (hasFooterBar) {
            sh += 25;
        }
        if (hasNavBar) {
            sh += 25;
        }
        map.put(TABLE_HEIGHT, new Integer(height - sh));
        String rowRenderer = gc.getRowRenderer();
        if (rowRenderer != null) {
            this.addConfig("rowrenderer", rowRenderer);
        }
        if (!gc.isAutoFocus()) {
            this.addConfig("autofocus", new Boolean(gc.isAutoFocus()));
        }
        this.addConfig("autoappend", gc.isAutoAppend() == null ? view_config.getDefaultAutoAppend() : gc.isAutoAppend().booleanValue());
        this.addConfig("submask", gc.getSubMask() == null ? view_config.getDefaultGridSubmask() : gc.getSubMask().booleanValue());
        this.addConfig("canpaste", new Boolean(gc.isCanPaste()));
        this.addConfig("canwheel", new Boolean(gc.isCanWheel()));
        this.processRowNumber(map, view);
        this.processSelectable(map, view);
        this.createGridColumns(map, view, session, model);
        if (hasFooterBar) {
            this.creatFooterBar(session, context);
        }
        map.put("gridstyle", style);
        this.createGridEditors(session, context);
    }

    private void processRowNumber(Map map, CompositeMap view) {
        GridConfig gc = GridConfig.getInstance(view);
        Boolean showRowNumber = gc.isShowRowNumber();
        map.put("showrownumber", showRowNumber);
        this.addConfig("showrownumber", showRowNumber);
    }

    private void processSelectable(Map map, CompositeMap view) {
        GridConfig gc = GridConfig.getInstance(view);
        Boolean selectable = new Boolean(false);
        Boolean showCheckAll = new Boolean(true);
        String selectionmodel = "multiple";
        CompositeMap root = view.getRoot();
        List list = CompositeUtil.findChilds(root, "dataSet");
        if (list != null) {
            String dds = gc.getBindTarget();
            for (CompositeMap ds : list) {
                String id = ds.getString("id", "");
                if ("".equals(id)) {
                    id = IDGenerator.getInstance().generate();
                }
                if (!id.equals(dds)) continue;
                selectable = new Boolean(ds.getBoolean("selectable", false));
                showCheckAll = new Boolean(ds.getBoolean("showcheckall", true));
                selectionmodel = ds.getString("selectionmodel", "multiple");
                break;
            }
        }
        map.put("selectable", selectable);
        map.put("showcheckall", showCheckAll);
        map.put("selectionmodel", selectionmodel);
        this.addConfig("selectable", selectable);
        this.addConfig("selectionmodel", selectionmodel);
    }

    private void createGridColumns(Map map, CompositeMap view, BuildSession session, CompositeMap model) {
        JSONArray jsons = new JSONArray();
        ArrayList cols = new ArrayList();
        HashMap<String, Integer> lkpro = new HashMap<String, Integer>();
        ApplicationViewConfig view_config = this.mApplicationConfig.getApplicationViewConfig();
        lkpro.put(LOCK_WIDTH, new Integer(0));
        lkpro.put(ROW_SPAN, new Integer(1));
        HashMap<String, Integer> ukpro = new HashMap<String, Integer>();
        ukpro.put(ROW_SPAN, new Integer(1));
        CompositeMap columns = view.getChild("columns");
        ArrayList<CompositeMap> lks = new ArrayList<CompositeMap>();
        ArrayList<CompositeMap> uks = new ArrayList<CompositeMap>();
        ArrayList locks = new ArrayList();
        ArrayList unlocks = new ArrayList();
        int maxRow = 1;
        Integer height = (Integer)map.get(TABLE_HEIGHT);
        Integer width = (Integer)map.get("width");
        Integer viewWidth = (Integer)map.get("oldwidth");
        float bl = 1.0f;
        GridConfig gc = GridConfig.getInstance(view);
        Boolean isAutoAdjust = gc.isAutoAdjust() == null ? view_config.getDefaultAutoAdjustGrid() : gc.isAutoAdjust().booleanValue();
        if (isAutoAdjust.booleanValue() && viewWidth != null && viewWidth != 0) {
            bl = width.floatValue() / viewWidth.floatValue();
        }
        if (columns != null) {
            List ukFirstList;
            boolean showRowNumber = (Boolean)map.get("showrownumber");
            if (showRowNumber) {
                CompositeMap column = new CompositeMap("column");
                column.setNameSpaceURI("http://www.aurora-framework.org/application");
                column.putBoolean("lock", true);
                column.putInt("width", 35);
                column.putString("align", "center");
                column.putBoolean("resizable", false);
                column.putBoolean("sortable", false);
                column.putString("prompt", "#");
                column.putString("renderer", "Aurora.RowNumberRenderer");
                column.putString(COLUMN_TYPE, TYPE_ROW_NUMBER);
                lks.add(column);
            }
            boolean selectable = (Boolean)map.get("selectable");
            String selectmodel = (String)map.get("selectionmodel");
            if (selectable) {
                CompositeMap column = new CompositeMap("column");
                column.setNameSpaceURI("http://www.aurora-framework.org/application");
                column.putBoolean("lock", true);
                column.putInt("width", 25);
                column.putBoolean("resizable", false);
                column.putBoolean("sortable", false);
                if ("multiple".equals(selectmodel)) {
                    column.putString(COLUMN_TYPE, TYPE_ROW_CHECKBOX);
                } else {
                    column.putString(COLUMN_TYPE, TYPE_ROW_RADIO);
                }
                lks.add(column);
            }
            Iterator cit = columns.getChildIterator();
            while (cit.hasNext()) {
                CompositeMap column = (CompositeMap)cit.next();
                boolean isLock = column.getBoolean("lock", false);
                if (isLock) {
                    lks.add(column);
                    continue;
                }
                uks.add(column);
            }
            this.processColumns(null, lks, locks, lkpro);
            this.processColumns(null, uks, unlocks, ukpro);
            int lr = (Integer)lkpro.get(ROW_SPAN);
            int ur = (Integer)ukpro.get(ROW_SPAN);
            if (ur >= lr) {
                maxRow = ur;
                ukpro.put(MAX_ROWS, new Integer(maxRow));
                ukpro.put(ROW_HEIGHT, new Integer(25));
                lkpro.put(MAX_ROWS, new Integer(maxRow));
                lkpro.put(ROW_HEIGHT, lr == 0 ? new Integer(25) : new Integer(ur * 25 / lr));
            } else {
                maxRow = lr;
                lkpro.put(MAX_ROWS, new Integer(maxRow));
                ukpro.put(MAX_ROWS, new Integer(maxRow));
                lkpro.put(ROW_HEIGHT, new Integer(25));
                ukpro.put(ROW_HEIGHT, ur == 0 ? new Integer(25) : new Integer(lr * 25 / ur));
            }
            List lkFirstList = (List)lkpro.get("l1");
            if (lkFirstList != null) {
                for (CompositeMap column : lkFirstList) {
                    column.put(ROW_SPAN, lkpro.get(MAX_ROWS));
                    this.addRowSpan(column);
                }
            }
            if ((ukFirstList = (List)ukpro.get("l1")) != null) {
                for (CompositeMap column : ukFirstList) {
                    column.put(ROW_SPAN, ukpro.get(MAX_ROWS));
                    this.addRowSpan(column);
                }
            }
            cols.addAll(locks);
            cols.addAll(unlocks);
            for (CompositeMap column : cols) {
                if (column.getChilds() != null) continue;
                String dataindex = column.getString("name", "");
                if (!"".equals(dataindex)) {
                    column.putString("name", dataindex);
                }
                column.putBoolean("lock", column.getBoolean("lock", false));
                boolean hidden = column.getBoolean("hidden", false);
                if (hidden) {
                    column.putBoolean("visiable", false);
                }
                column.putBoolean("hidden", hidden);
                column.putBoolean("resizable", column.getBoolean("resizable", true));
                column.putBoolean("sortable", column.getBoolean("sortable", false));
                column.putBoolean("forexport", hidden ? false : column.getBoolean("forexport", column.getString(COLUMN_TYPE) == null));
                column.putBoolean("autoadjust", column.getBoolean("autoadjust", true));
                column.putInt("maxadjustwidth", column.getInt("maxadjustwidth", 300));
                String editorFunction = column.getString("editorfunction");
                if (editorFunction != null) {
                    column.put("editorfunction", TextParser.parse(editorFunction, model));
                }
                float cwidth = column.getInt("width", 100);
                String type = column.getString(COLUMN_TYPE);
                if (!(TYPE_ROW_CHECKBOX.equals(type) || TYPE_ROW_RADIO.equals(type) || TYPE_ROW_NUMBER.equals(type))) {
                    cwidth *= bl;
                }
                column.putInt("width", Math.round(cwidth));
                String editor = column.getString("editor", "");
                if (this.isCheckBoxEditor(editor, view)) {
                    column.putString(COLUMN_TYPE, TYPE_CELL_CHECKBOX);
                }
                if (!"".equals(editor)) {
                    column.put("editor", TextParser.parse(editor, model));
                }
                this.toJSONForParentColumn(column);
                JSONObject json = new JSONObject(column);
                jsons.put(json);
            }
        }
        String bindTarget = gc.getBindTarget();
        map.put(HEAD_HEIGHT, new Integer(maxRow * 25));
        map.put(LOCK_COLUMNS, locks);
        map.put(UNLOCK_COLUMNS, unlocks);
        map.put(HTML_LOCKAREA, this.generateLockArea(map, locks, lkpro, session, bindTarget, model));
        map.put(HTML_UNLOCKAREA, this.generateUnlockArea(map, unlocks, ukpro, session, bindTarget, model));
        Integer lockWidth = (Integer)lkpro.get(LOCK_WIDTH);
        map.put(LOCK_WIDTH, lockWidth);
        map.put(UNLOCK_WIDTH, new Integer(width - lockWidth));
        map.put(BODY_HEIGHT, new Integer(height - maxRow * 25));
        this.addConfig("columns", jsons);
        this.addConfig("width", map.get("width"));
        this.addConfig("height", map.get("height"));
        map.put("config", this.getConfigString());
    }

    private void toJSONForParentColumn(CompositeMap column) {
        CompositeMap parent = null;
        if (column.get("_parent") instanceof CompositeMap && (parent = (CompositeMap)column.get("_parent")) != null) {
            if (!parent.getBoolean("forexport", true)) {
                parent.putBoolean("forexport", parent.getBoolean("forexport", true));
            }
            this.toJSONForParentColumn(parent);
            column.put("_parent", new JSONObject(parent));
        }
    }

    private void createGridEditors(BuildSession session, ViewContext context) throws IOException {
        CompositeMap view = context.getView();
        Map map = context.getMap();
        CompositeMap model = context.getModel();
        CompositeMap editors = view.getChild("editors");
        StringBuffer sb = new StringBuffer();
        if (editors != null && editors.getChilds() != null) {
            Iterator it = editors.getChildIterator();
            while (it.hasNext()) {
                CompositeMap editor = (CompositeMap)it.next();
                editor.put("iscust", new Boolean(false));
                editor.put("style", "position:absolute;left:-1000px;top:-1000px;");
                try {
                    sb.append(session.buildViewAsString(model, editor));
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
        map.put("editors", sb.toString());
    }

    private boolean isCheckBoxEditor(String id, CompositeMap view) {
        boolean isChecBox = false;
        CompositeMap editors = view.getChild("editors");
        if (editors != null && editors.getChilds() != null) {
            Iterator it = editors.getChildIterator();
            while (it.hasNext()) {
                CompositeMap editor = (CompositeMap)it.next();
                String eid = editor.getString("id", "");
                if (!id.equals(eid) || !"checkBox".equals(editor.getName())) continue;
                isChecBox = true;
                break;
            }
        }
        return isChecBox;
    }

    private boolean creatToolBar(BuildSession session, ViewContext context) throws IOException {
        CompositeMap view = context.getView();
        Map map = context.getMap();
        CompositeMap model = context.getModel();
        CompositeMap toolbar = view.getChild("toolBar");
        String dataset = (String)map.get("bindtarget");
        StringBuffer sb = new StringBuffer();
        boolean hasToolBar = false;
        if (toolbar != null && toolbar.getChilds() != null) {
            hasToolBar = true;
            CompositeMap tb = new CompositeMap("toolBar");
            tb.setNameSpaceURI("http://www.aurora-framework.org/application");
            Integer width = (Integer)map.get("width");
            tb.put("id", map.get("id") + "_tb");
            tb.put("width", new Integer(width));
            tb.put("classname", "grid-toolbar");
            Iterator it = toolbar.getChildIterator();
            while (it.hasNext()) {
                String type;
                CompositeMap item = (CompositeMap)it.next();
                if ("button".equals(item.getName()) && !"".equals(type = item.getString(COLUMN_TYPE))) {
                    if ("add".equalsIgnoreCase(type)) {
                        item = this.createButton(item, session.getLocalizedPrompt("HAP_NEW"), "grid-add", "background-position:0px 0px;", "function(){$('" + dataset + "').create()}");
                    } else if ("delete".equalsIgnoreCase(type)) {
                        item = this.createButton(item, session.getLocalizedPrompt("HAP_DELETE"), "grid-delete", "background-position:0px -35px;", "function(){$('" + map.get("id") + "').remove()}");
                    } else if ("save".equalsIgnoreCase(type)) {
                        item = this.createButton(item, session.getLocalizedPrompt("HAP_SAVE"), "grid-save", "background-position:0px -17px;", "function(){$('" + dataset + "').submit()}");
                    } else if ("clear".equalsIgnoreCase(type)) {
                        item = this.createButton(item, session.getLocalizedPrompt("HAP_CLEAR"), "grid-clear", "background-position:0px -53px;", "function(){$('" + map.get("id") + "').clear()}");
                    } else if ("excel".equalsIgnoreCase(type)) {
                        item = this.createButton(item, session.getLocalizedPrompt("HAP_EXPORT"), "grid-excel", "background-position:0px -69px;", "function(){$('" + map.get("id") + "')._export()}");
                    } else if ("customize".equalsIgnoreCase(type)) {
                        item = this.createButton(item, session.getLocalizedPrompt("HAP_CUST"), "grid-cust", "background-position:0px -88px;", "function(){$('" + map.get("id") + "').customize()}");
                    }
                }
                tb.addChild(item);
            }
            sb.append("<tr><td>");
            try {
                sb.append(session.buildViewAsString(model, tb));
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            sb.append("</td></tr>");
        }
        map.put("toolBar", sb.toString());
        return hasToolBar;
    }

    private CompositeMap createButton(CompositeMap button, String text, String clz, String style, String function) {
        if ("".equals(button.getString("icon", ""))) {
            button.put("icon", "null");
            button.put("btnclass", clz);
            button.put("btnstyle", style);
        }
        button.put("text", button.getString("text", text));
        if (!"".equals(function)) {
            button.put("click", function);
        }
        return button;
    }

    public boolean hasFooterBar(CompositeMap column) {
        boolean hasFooterBar = false;
        GridColumnConfig gcc = GridColumnConfig.getInstance(column);
        String footerRenderer = gcc.getFooterRenderer();
        if (footerRenderer != null) {
            return true;
        }
        List childs = column.getChilds();
        if (childs != null) {
            for (CompositeMap col : childs) {
                if (!this.hasFooterBar(col)) continue;
                hasFooterBar = true;
                break;
            }
        }
        return hasFooterBar;
    }

    private void creatFooterBar(BuildSession session, ViewContext context) throws IOException {
        Iterator it;
        Map map = context.getMap();
        int lockWidth = (Integer)map.get(LOCK_WIDTH);
        StringBuffer sb = new StringBuffer();
        sb.append("<tr><td><div class='grid-footerbar' atype='grid.fb' style='width:" + map.get("width") + "px'>");
        if (lockWidth != 0) {
            sb.append("<div atype='grid.lf' style='float:left;width:" + (lockWidth - 1) + "px'>");
            List locks = (List)map.get(LOCK_COLUMNS);
            if (locks != null) {
                sb.append("<table cellSpacing='0' cellPadding='0' border='0' atype='fb.lbt' ");
                it = locks.iterator();
                sb.append(this.createFooterBarTable(it, false));
            }
            sb.append("</div>");
        }
        sb.append("<div class='grid-ua' atype='grid.uf' style='width:" + map.get(UNLOCK_WIDTH) + "px'>");
        List unlocks = (List)map.get(UNLOCK_COLUMNS);
        if (unlocks != null) {
            sb.append("<table cellSpacing='0' cellPadding='0' border='0' atype='fb.ubt' ");
            it = unlocks.iterator();
            sb.append(this.createFooterBarTable(it, true));
        }
        sb.append("</div>");
        sb.append("</div></td></tr>");
        map.put(FOOTER_BAR, sb.toString());
    }

    private String createFooterBarTable(Iterator it, boolean hasSpan) {
        int i = 0;
        int w = 0;
        StringBuffer sb = new StringBuffer();
        StringBuffer tb = new StringBuffer();
        StringBuffer th = new StringBuffer();
        th.append("<tr class='grid-hl'>");
        while (it.hasNext()) {
            CompositeMap column = (CompositeMap)it.next();
            if (column.getChilds() != null) continue;
            GridColumnConfig gcc = GridColumnConfig.getInstance(column);
            w += gcc.getWidth();
            th.append("<th style='width:" + gcc.getWidth() + "px;' dataindex='" + gcc.getName() + "'></th>");
            tb.append("<td style='text-align:" + gcc.getAlign() + ";");
            tb.append("'");
            if (gcc.getName() != null) {
                tb.append("dataindex='" + gcc.getName() + "'");
            }
            tb.append(">&#160;</td>");
            ++i;
        }
        if (hasSpan) {
            th.append("<th style='width:17px;'></th>");
        }
        sb.append("style='width:" + w + "px;table-layout:fixed;'>");
        sb.append(th.toString()).append("</tr><tr>");
        sb.append(tb.toString());
        sb.append("</tr></table>");
        return sb.toString();
    }

    private boolean createNavgationToolBar(BuildSession session, ViewContext context) throws IOException {
        boolean hasNavBar = false;
        CompositeMap view = context.getView();
        GridConfig gc = GridConfig.getInstance(view);
        Map map = context.getMap();
        CompositeMap model = context.getModel();
        StringBuffer sb = new StringBuffer();
        String dataset = (String)map.get("bindtarget");
        boolean hasNav = gc.hasNavBar();
        if (hasNav) {
            hasNavBar = true;
            CompositeMap navbar = new CompositeMap("navBar");
            navbar.setNameSpaceURI("http://www.aurora-framework.org/application");
            Integer width = (Integer)map.get("width");
            navbar.put("id", map.get("id") + "_navbar");
            navbar.put("iscust", new Boolean(false));
            navbar.put("width", new Integer(width));
            navbar.put("classname", "grid-navbar");
            navbar.put("dataset", dataset);
            navbar.put("navbartype", view.getString("navbartype", "complex"));
            navbar.put("maxpagecount", new Integer(view.getInt("maxpagecount", 10)));
            navbar.put("enablepagesize", new Boolean(view.getBoolean("enablepagesize", true)));
            sb.append("<tr><td>");
            try {
                sb.append(session.buildViewAsString(model, navbar));
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            sb.append("</td></tr>");
            map.put("navbar", sb.toString());
        }
        return hasNavBar;
    }

    private void processColumns(CompositeMap parent, List children, List cols, Map pro) {
        boolean plock;
        Iterator it = children.iterator();
        boolean bl = parent != null ? (parent.getBoolean("lock") != null ? parent.getBoolean("lock") : false) : (plock = false);
        while (it.hasNext()) {
            int rows;
            int level;
            CompositeMap column = (CompositeMap)it.next();
            if (plock) {
                column.putBoolean("lock", true);
            }
            if ((level = parent == null ? 1 : parent.getInt("_level") + 1) > (rows = ((Integer)pro.get(ROW_SPAN)).intValue())) {
                pro.put(ROW_SPAN, new Integer(level));
            }
            column.put("_level", new Integer(level));
            column.put("_parent", parent);
            ArrayList<CompositeMap> hlist = (ArrayList<CompositeMap>)pro.get("l" + level);
            if (hlist == null) {
                hlist = new ArrayList<CompositeMap>();
                pro.put("l" + level, hlist);
            }
            hlist.add(column);
            cols.add(column);
            if (column.getChilds() != null && column.getChilds().size() > 0) {
                this.processColumns(column, column.getChilds(), cols, pro);
                continue;
            }
            this.addColSpan(column);
        }
    }

    private void addRowSpan(CompositeMap column) {
        List children = column.getChilds();
        Integer psp = column.getInt(ROW_SPAN);
        if (children != null && children.size() > 0) {
            this.minusRowSpan(column);
            for (CompositeMap child : children) {
                child.put(ROW_SPAN, new Integer(psp - 1));
                this.addRowSpan(child);
            }
        }
    }

    private void minusRowSpan(CompositeMap column) {
        CompositeMap parent;
        if (column == null) {
            return;
        }
        Integer rowspan = column.getInt(ROW_SPAN);
        if (rowspan != null) {
            int cs = Math.max(rowspan - 1, 1);
            column.put(ROW_SPAN, new Integer(cs));
        }
        if ((parent = (CompositeMap)column.get("_parent")) != null) {
            this.minusRowSpan(parent);
        }
    }

    private void addColSpan(CompositeMap column) {
        if (column == null) {
            return;
        }
        CompositeMap parent = (CompositeMap)column.get("_parent");
        if (parent != null) {
            Integer colspan = parent.getInt(COL_SPAN);
            if (colspan == null) {
                parent.put(COL_SPAN, new Integer(1));
            } else {
                int cs = colspan + 1;
                parent.put(COL_SPAN, new Integer(cs));
            }
        }
        this.addColSpan(parent);
    }

    private String generateLockArea(Map map, List columns, Map pro, BuildSession session, String dataSet, CompositeMap model) {
        StringBuffer sb = new StringBuffer();
        StringBuffer th = new StringBuffer();
        boolean hasLockColumn = false;
        Integer rows = (Integer)pro.get(ROW_SPAN);
        Iterator it = columns.iterator();
        int lockWidth = 0;
        while (it.hasNext()) {
            boolean hidden;
            CompositeMap column = (CompositeMap)it.next();
            if (!column.getBoolean("lock", false)) continue;
            hasLockColumn = true;
            List children = column.getChilds();
            if (children != null || (hidden = column.getBoolean("hidden", false))) continue;
            float cwidth = hidden ? 0.0f : (float)column.getInt("width", 100);
            th.append("<th style='width:" + cwidth + "px;' dataindex='" + column.getString("name", "") + "'></th>");
            lockWidth = (int)((float)lockWidth + cwidth);
        }
        pro.put(LOCK_WIDTH, new Integer(lockWidth));
        if (hasLockColumn) {
            sb.append("<DIV class='grid-la' atype='grid.lc' style='width:" + (lockWidth - 1) + "px;'>");
            sb.append("<DIV class='grid-lh' atype='grid.lh' unselectable='on' onselectstart='return false;' style='height:" + rows * (Integer)pro.get(ROW_HEIGHT) + "px;'>");
            StringBuffer hsb = new StringBuffer();
            for (int i = 1; i <= rows; ++i) {
                List list = (List)pro.get("l" + i);
                hsb.append("<TR height=" + pro.get(ROW_HEIGHT) + ">");
                if (list != null) {
                    for (CompositeMap column : list) {
                        String ct = column.getString(COLUMN_TYPE);
                        boolean showCheckAll = (Boolean)map.get("showcheckall");
                        if (TYPE_ROW_CHECKBOX.equals(ct)) {
                            if (showCheckAll) {
                                hsb.append("<TD class='grid-hc' atype='grid.rowcheck' rowspan='" + column.getInt(ROW_SPAN) + "'><center><div atype='grid.headcheck' class='grid-ckb item-ckb-u'></div></center></TD>");
                                continue;
                            }
                            hsb.append("<TD class='grid-hc' atype='grid.rowcheck' rowspan='" + column.getInt(ROW_SPAN) + "'></TD>");
                            continue;
                        }
                        if (TYPE_ROW_RADIO.equals(ct)) {
                            hsb.append("<TD class='grid-hc' atype='grid.rowradio' rowspan='" + column.getInt(ROW_SPAN) + "'><div>&nbsp;</div></TD>");
                            continue;
                        }
                        boolean hidden = column.getBoolean("hidden", false);
                        if (hidden) continue;
                        String prompt = this.getFieldPrompt(session, column, dataSet);
                        String headTitle = session.getLocalizedPrompt(prompt);
                        if (headTitle != null && headTitle.equals(prompt)) {
                            headTitle = TextParser.parse(prompt, model);
                        }
                        hsb.append("<TD class='grid-hc' atype='grid.head' style='visibility:" + (hidden ? "hidden" : "") + "' colspan='" + column.getInt(COL_SPAN, 1) + "' rowspan='" + column.getInt(ROW_SPAN) + "' dataindex='" + column.getString("name", "") + "'><div>" + headTitle + "</div></TD>");
                    }
                }
                hsb.append("</TR>");
            }
            sb.append("<TABLE cellSpacing='0' atype='grid.lht' cellPadding='0' border='0' style='width:" + lockWidth + "px'><TBODY>");
            sb.append("<TR class='grid-hl'>");
            sb.append(th.toString());
            sb.append("</TR>");
            sb.append(hsb);
            sb.append("</TBODY></TABLE>");
            Integer height = (Integer)map.get(TABLE_HEIGHT);
            sb.append("</DIV><DIV class='grid-lb' atype='grid.lb' style='width:100%;height:" + (height - rows * (Integer)pro.get(ROW_HEIGHT)) + "px'>");
            sb.append("</DIV></DIV>");
        }
        return sb.toString();
    }

    private String generateUnlockArea(Map map, List columns, Map pro, BuildSession session, String dataSet, CompositeMap model) {
        StringBuffer sb = new StringBuffer();
        StringBuffer th = new StringBuffer();
        Integer rows = (Integer)pro.get(ROW_SPAN);
        Iterator it = columns.iterator();
        int unlockWidth = 0;
        while (it.hasNext()) {
            boolean hidden;
            List children;
            CompositeMap column = (CompositeMap)it.next();
            if (column.getBoolean("lock", false) || (children = column.getChilds()) != null || (hidden = column.getBoolean("hidden", false))) continue;
            float cwidth = hidden ? 0.0f : (float)column.getInt("width", 100);
            th.append("<th style='width:" + cwidth + "px;' dataindex='" + column.getString("name", "") + "'></th>");
            unlockWidth = (int)((float)unlockWidth + cwidth);
        }
        sb.append("<TABLE cellSpacing='0' atype='grid.uht' cellPadding='0' border='0' style='width:" + unlockWidth + "px'><TBODY>");
        sb.append("<TR class='grid-hl'>");
        sb.append(th.toString());
        sb.append("<TH WIDTH='20'> </TH>");
        sb.append("</TR>");
        StringBuffer hsb = new StringBuffer();
        for (int i = 1; i <= rows; ++i) {
            List list = (List)pro.get("l" + i);
            hsb.append("<TR height=" + pro.get(ROW_HEIGHT) + ">");
            if (list != null) {
                for (CompositeMap column : list) {
                    boolean hidden = column.getBoolean("hidden", false);
                    if (hidden) continue;
                    String prompt = this.getFieldPrompt(session, column, dataSet);
                    String headTitle = session.getLocalizedPrompt(prompt);
                    if (headTitle != null && headTitle.equals(prompt)) {
                        headTitle = TextParser.parse(prompt, model);
                    }
                    hsb.append("<TD class='grid-hc' atype='grid.head' style='visibility:" + (hidden ? "hidden" : "") + "' colspan='" + column.getInt(COL_SPAN, 1) + "' rowspan='" + column.getInt(ROW_SPAN) + "' dataindex='" + column.getString("name", "") + "'><div>" + headTitle + "</div></TD>");
                }
            }
            hsb.append("</TR>");
        }
        sb.append(hsb);
        sb.append("</TBODY></TABLE>");
        return sb.toString();
    }
}

