/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation;

import aurora.presentation.ViewComponent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.ocm.ClassRegistry;
import uncertain.pkg.ComponentPackage;
import uncertain.pkg.PackageConfigurationError;

public class ViewComponentPackage
extends ComponentPackage {
    public static final String ELEMENT_VIEW_COMPONENT = "view-component";
    public static final String THEME_PATH = "theme";
    public static final String TEMPLATE_PATH = "template";
    public static final String RESOURCE_PATH = "resource";
    public static final String DEFAULT_THEME = "default";
    public static final String FILE_COMPONENTS_CONFIG = "components.xml";
    File mBaseThemePath;
    File mDefaultSchemePath;
    Map mComponentMap = new HashMap();

    public static void loadBuiltInRegistry(ClassRegistry reg) {
        reg.addClassMapping(ELEMENT_VIEW_COMPONENT, ViewComponent.class);
    }

    public ViewComponentPackage() {
    }

    protected void loadComponents() {
        File component_file = new File(this.getConfigPath(), FILE_COMPONENTS_CONFIG);
        if (!component_file.exists()) {
            throw new PackageConfigurationError("components.xml not exists in config directory");
        }
        CompositeLoader loader = super.getPackageManager().getCompositeLoader();
        try {
            CompositeMap components = loader.loadByFullFilePath(component_file.getPath());
            super.getPackageManager().getOCManager().populateObject(components, this);
        }
        catch (Exception ex) {
            throw new PackageConfigurationError("Error when loading components.xml", ex);
        }
    }

    @Override
    public void load(String base_path) throws IOException {
        super.load(base_path);
        this.mBaseThemePath = new File(this.mBasePathFile, THEME_PATH);
        if (!this.mBaseThemePath.exists()) {
            throw new PackageConfigurationError("package directory doesn't contains theme directory");
        }
        this.mDefaultSchemePath = new File(this.mBaseThemePath, DEFAULT_THEME);
        if (!this.mDefaultSchemePath.exists()) {
            throw new PackageConfigurationError("package directory doesn't contains theme/default/ directory");
        }
        this.loadComponents();
    }

    public ViewComponentPackage(String base_path) throws IOException {
        this();
        this.load(base_path);
    }

    public boolean isResourceExist(String theme, String resource_name) {
        File theme_dir = new File(this.mBaseThemePath, theme);
        File resource_base_path = new File(theme_dir, RESOURCE_PATH);
        File resource_file = new File(resource_base_path, resource_name);
        return resource_file.exists();
    }

    protected File getFileByTheme(String theme, String base_path, String file_name) {
        File resource_file;
        File resource_base_path;
        File theme_dir;
        if (theme == null) {
            theme = DEFAULT_THEME;
        }
        if ((theme_dir = new File(this.mBaseThemePath, theme)).exists()) {
            resource_base_path = new File(theme_dir, base_path);
            resource_file = new File(resource_base_path, file_name);
            if (resource_file.exists()) {
                return resource_file;
            }
            theme_dir = this.mDefaultSchemePath;
        } else {
            theme_dir = this.mDefaultSchemePath;
        }
        resource_base_path = new File(theme_dir, base_path);
        resource_file = new File(resource_base_path, file_name);
        if (resource_file.exists()) {
            return resource_file;
        }
        return null;
    }

    public File getResourceFile(String theme, String file_name) {
        return this.getFileByTheme(theme, RESOURCE_PATH, file_name);
    }

    public File getResourceFile(String file_name) {
        return this.getResourceFile(null, file_name);
    }

    public File getTemplateFile(String theme, String file_name) {
        return this.getFileByTheme(theme, TEMPLATE_PATH, file_name);
    }

    public File getTemplateFile(String file_name) {
        return this.getTemplateFile(null, file_name);
    }

    public void addComponents(ViewComponent[] components) {
        for (int i = 0; i < components.length; ++i) {
            this.addComponent(components[i]);
        }
    }

    public void addComponent(ViewComponent component) {
        this.mComponentMap.put(component.getElementIdentifier(), component);
        component.setOwner(this);
    }

    public ViewComponent getComponent(CompositeMap view) {
        return (ViewComponent)this.mComponentMap.get(view.getQName());
    }

    protected Map getComponentMap() {
        return this.mComponentMap;
    }

    public Collection getAllComponents() {
        return this.mComponentMap.values();
    }
}

