/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.features;

import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.bm.IModelFactory;
import aurora.bm.Operation;
import aurora.database.DBUtil;
import aurora.database.FetchDescriptor;
import aurora.database.ParsedSql;
import aurora.database.ResultSetLoader;
import aurora.database.SqlRunner;
import aurora.database.features.CacheBasedMultiLanguageDisplay;
import aurora.database.profile.IDatabaseFactory;
import aurora.database.rsconsumer.CompositeMapCreator;
import aurora.database.service.BusinessModelService;
import aurora.database.service.BusinessModelServiceContext;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.List;
import java.util.Set;
import uncertain.composite.CompositeMap;
import uncertain.core.ConfigurationError;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class CacheBasedMultiLanguageStorage
extends CacheBasedMultiLanguageDisplay {
    static final String KEY_ML_MODEL = "model";
    static final String KEY_ML_SEQUENCE = "sequence";
    static final String KEY_ML_REF_TABLE = "ref_table";
    static final String KEY_ML_REF_FIELD = "ref_field";
    static final String KEY_ML_DESCRIPTION = "description";
    static final String KEY_ML_PK_ID = "pk_id";
    String mlModelString = null;
    String refTable = null;
    String refField = null;
    String mlDescription = null;
    String pkId = null;
    String sequence = null;
    BusinessModel mlModel = null;
    String mlTable = null;
    CompositeMap dbProperties = null;
    ILogger mLogger = null;

    public CacheBasedMultiLanguageStorage(IObjectRegistry objectRegistry, IModelFactory modelFactory, IDatabaseFactory databaseFactory) throws IOException {
        super(objectRegistry, databaseFactory);
        this.dbProperties = databaseFactory.getProperties();
        if (this.dbProperties == null) {
            throw new ConfigurationError("Database Properties undifined");
        }
        CompositeMap mlProperties = this.dbProperties.getChild("multi-language-storage");
        if (mlProperties == null) {
            throw new ConfigurationError("multi-language-storage Properties undifined");
        }
        this.refTable = mlProperties.getString(KEY_ML_REF_TABLE);
        if (this.refTable == null) {
            throw new ConfigurationError("multi-language-storage ref_table undifined");
        }
        this.refField = mlProperties.getString(KEY_ML_REF_FIELD);
        if (this.refField == null) {
            throw new ConfigurationError("multi-language-storage ref_field undifined");
        }
        this.mlDescription = mlProperties.getString(KEY_ML_DESCRIPTION);
        if (this.mlDescription == null) {
            throw new ConfigurationError("multi-language-storage description undifined");
        }
        this.pkId = mlProperties.getString(KEY_ML_PK_ID);
        if (this.pkId == null) {
            throw new ConfigurationError("multi-language-storage pk_id undifined");
        }
        this.mlModelString = mlProperties.getString(KEY_ML_MODEL);
        if (this.mlModelString == null) {
            throw new ConfigurationError("multi-language-storage model undifined");
        }
        this.sequence = mlProperties.getString(KEY_ML_SEQUENCE);
        if (this.sequence == null) {
            throw new ConfigurationError("multi-language-storage sequence undifined");
        }
        this.mlModel = modelFactory.getModelForRead(this.mlModelString);
        this.mlTable = this.mlModel.getBaseTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCreateInsertStatement(BusinessModel model, BusinessModelServiceContext context) throws Exception {
        if (!this.hasMlFields) {
            return;
        }
        if (this.mLogger == null) {
            this.mLogger = LoggingContext.getLogger(context.getObjectContext(), "aurora.database");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        Field[] fields = model.getFields();
        int count = 0;
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.getMultiLanguage()) continue;
            if (count != 0) {
                sql.append(",");
            }
            sql.append(this.sequence + " as " + field.getName());
            ++count;
        }
        sql.append(" from dual");
        ParsedSql s = new ParsedSql(sql.toString());
        SqlRunner runner = new SqlRunner(context, s);
        runner.setConnectionName(context.getBusinessModel().getDataSourceName());
        ResultSet rs = null;
        try {
            rs = runner.query(new CompositeMap());
            ResultSetLoader loader = new ResultSetLoader();
            loader.setFieldNameCase((byte)2);
            FetchDescriptor desc = FetchDescriptor.fetchAll();
            CompositeMapCreator consumer = new CompositeMapCreator();
            loader.loadByResultSet(rs, desc, consumer);
            CompositeMap result = consumer.getCompositeMap();
            CompositeMap currParamMap = context.getCurrentParameter();
            List list = result.getChilds();
            CompositeMap child = (CompositeMap)list.get(0);
            Set kSet = child.keySet();
            for (String key : kSet) {
                currParamMap.put(key, child.get(key));
            }
            context.setCurrentParameter(currParamMap);
        }
        finally {
            DBUtil.printTraceInfo("MultiLanguageStorage Insert", this.mLogger, runner);
            DBUtil.closeResultSet(rs);
        }
    }

    public void postExecuteDmlStatement(BusinessModelServiceContext context) throws Exception {
        if (!this.hasMlFields) {
            return;
        }
        BusinessModel model = context.getBusinessModel();
        String operation = context.getOperation();
        Field[] fields = model.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (field.isReferenceField() || !field.getMultiLanguage()) continue;
            if ("insert".equalsIgnoreCase(operation.toLowerCase()) && field.isForInsert() && model.getOperation("insert") == null) {
                this.createMultiLanguageSql(context, field, "update");
                continue;
            }
            if ("update".equalsIgnoreCase(operation.toLowerCase()) && field.isForUpdate() && model.getOperation("update") == null) {
                this.createMultiLanguageSql(context, field, "update");
                continue;
            }
            this.createMultiLanguageSql(context, field, "delete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createMultiLanguageSql(BusinessModelServiceContext context, Field mlFiled, String operation) throws Exception {
        if (this.mLogger == null) {
            this.mLogger = LoggingContext.getLogger(context.getObjectContext(), "aurora.database");
        }
        CompositeMap currentParameter = context.getCurrentParameter();
        BusinessModel bm = context.getBusinessModel();
        currentParameter.putString(this.refTable, bm.getBaseTable().toUpperCase());
        currentParameter.putString(this.refField, mlFiled.getName().toUpperCase());
        currentParameter.putString(this.mlDescription, currentParameter.getString(mlFiled.getMultiLanguageDescField()));
        currentParameter.putString(this.pkId, currentParameter.getString(mlFiled.getName()));
        Operation op = this.mlModel.getOperation(operation);
        String sql = op.getSql();
        ParsedSql s = new ParsedSql();
        s.parse(sql);
        SqlRunner runner = BusinessModelService.createSqlRunner(context, s);
        try {
            runner.update(context.getCurrentParameter());
        }
        finally {
            DBUtil.printTraceInfo("MultiLanguageStorage " + operation, this.mLogger, runner);
        }
    }
}

