/*
 * Decompiled with CFR 0.152.
 */
package aurora.database;

import aurora.service.validation.Parameter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import uncertain.datatype.DataType;
import uncertain.datatype.DataTypeRegistry;

public class BindParameter {
    String input_path;
    String output_path;
    int position = 0;
    boolean is_sql_statement = false;
    boolean is_input = true;
    boolean is_output = false;
    DataType data_type;
    String database_type_name;
    boolean isAutoGeneratedKey = false;

    public BindParameter(String access_path, int data_type) {
        this.input_path = access_path;
    }

    public BindParameter(String access_path) {
        this(access_path, 1111);
    }

    public void copyFrom(Parameter p) {
        this.input_path = p.getInputPath();
        this.output_path = p.getOutputPath();
        this.is_input = p.getInput();
        this.is_output = p.getOutput();
        this.data_type = DataTypeRegistry.getInstance().getDataType(p.getDataType());
        this.database_type_name = p.getDatabaseTypeName();
        this.isAutoGeneratedKey = p.isAutoGeneratedKey();
    }

    public BindParameter() {
    }

    public DataType getDataType() {
        return this.data_type;
    }

    public void setDataType(DataType data_type) {
        this.data_type = data_type;
    }

    public String getDataTypeName() {
        return this.data_type == null ? null : this.data_type.getClass().getName();
    }

    public void setDataTypeName(String name) {
        this.data_type = DataTypeRegistry.getInstance().getType(name);
        if (this.data_type == null) {
            throw new IllegalArgumentException("Unknown data type: " + name);
        }
    }

    public int getJdbcDataType() {
        return this.data_type == null ? 1111 : this.data_type.getSqlType();
    }

    public void setJdbcDataType(int jdbc_data_type) {
        this.data_type = DataTypeRegistry.getInstance().getType(jdbc_data_type);
        if (this.data_type == null) {
            throw new IllegalArgumentException("Unknown JDBC type: " + jdbc_data_type);
        }
    }

    public void setStatement(int index, PreparedStatement stmt, Object value) throws SQLException {
        DataType dt = this.data_type;
        if (dt == null) {
            if (value == null || value.equals(null)) {
                stmt.setNull(index, 12);
                return;
            }
            dt = DataTypeRegistry.getInstance().getDataType(value.getClass());
            if (dt == null) {
                throw new IllegalArgumentException("Can't get data type for value [" + value + "] class: " + value.getClass().getName());
            }
        }
        dt.setParameter(stmt, index, value);
    }

    public boolean isInput() {
        return this.is_input;
    }

    public boolean isSQLStatement() {
        return this.is_sql_statement;
    }

    public String getPath() {
        return this.input_path;
    }

    public void setPath(String path) {
        this.input_path = path;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<parameter inputPath=\"").append(this.input_path).append("\" output_path=\"").append(this.output_path).append("\" DataType=\"").append(this.data_type).append("\" />");
        return buf.toString();
    }
}

