/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.cstm.bm;

import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.bm.QueryField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class LovBMCustomSourceCode {
    public static final String KEY_RECORD_ID = "record_id";
    public static final String KEY_BM_SELECT_VALUE = "bm_select_value";
    public static final String KEY_BM_DATA_SOURCE = "bm_data_source";
    public static final String KEY_BM_WHERE_CLAUSE = "bm_where_clause";
    public static final String KEY_BM_ORDER_BY = "bm_order_by";
    public static final String KEY_BM_QUERY_CONDITION = "bm_query_condition";
    public static final String FIELD_SEPERATOR = ",";

    public static void custom(BusinessModel bm, CompositeMap customRecords, IObjectRegistry registry) {
        if (registry == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, IObjectRegistry.class, LovBMCustomSourceCode.class.getCanonicalName());
        }
        ILogger logger = LoggingContext.getLogger(LovBMCustomSourceCode.class.getCanonicalName(), registry);
        if (bm == null || customRecords == null || customRecords.getChilds() == null) {
            return;
        }
        Iterator it = customRecords.getChildIterator();
        while (it.hasNext()) {
            int i;
            String bm_query_condition;
            String bm_where_clause;
            String bm_select_value;
            String bm_order_by;
            CompositeMap record = (CompositeMap)it.next();
            String bm_data_source = record.getString(KEY_BM_DATA_SOURCE);
            if (bm_data_source != null) {
                bm.setBaseTable(bm_data_source);
            }
            if ((bm_order_by = record.getString(KEY_BM_ORDER_BY)) != null) {
                bm.setDefaultOrderby(bm_order_by);
            }
            if ((bm_select_value = record.getString(KEY_BM_SELECT_VALUE)) != null) {
                int i2;
                String[] forDisplayfields = bm_select_value.split(FIELD_SEPERATOR);
                Field[] fields = bm.getFields();
                for (i2 = 0; i2 < fields.length; ++i2) {
                    fields[i2].setForDisplay(false);
                }
                for (i2 = 0; i2 < forDisplayfields.length; ++i2) {
                    String fieldName = forDisplayfields[i2];
                    Field field = bm.getField(fieldName);
                    if (field == null) {
                        field = Field.createField(fieldName);
                        bm.addField(field);
                    }
                    field.setForDisplay(true);
                }
            }
            if ((bm_where_clause = record.getString(KEY_BM_WHERE_CLAUSE)) != null) {
                CompositeMap dataFilters = new CompositeMap("data-filters");
                CompositeMap dataFilter = new CompositeMap("bm", "http://www.aurora-framework.org/schema/bm", "data-filter");
                dataFilter.put("name", "cust_query");
                dataFilter.put("enforceoperations", "query");
                dataFilter.put("expression", bm_where_clause);
                dataFilters.addChild(dataFilter);
                bm.setDataFilters(dataFilters);
            }
            if ((bm_query_condition = record.getString(KEY_BM_QUERY_CONDITION)) == null) continue;
            String[] forQueryfields = bm_query_condition.split(FIELD_SEPERATOR);
            Field[] fields = bm.getFields();
            for (int i3 = 0; i3 < fields.length; ++i3) {
                fields[i3].setForQuery(false);
            }
            QueryField[] queryFields = bm.getQueryFieldsArray();
            ArrayList<String> queryFieldNameList = new ArrayList<String>();
            if (queryFields != null) {
                for (i = 0; i < queryFields.length; ++i) {
                    String field = queryFields[i].getField();
                    if (field == null) continue;
                    queryFieldNameList.add(field);
                }
            }
            for (i = 0; i < forQueryfields.length; ++i) {
                String fieldName = forQueryfields[i];
                Field field = bm.getField(fieldName);
                if (field == null) {
                    field = Field.createField(fieldName);
                    bm.addField(field);
                }
                field.setForQuery(true);
                if (queryFieldNameList.contains(fieldName)) continue;
                CompositeMap queryField = new CompositeMap("bm", "http://www.aurora-framework.org/schema/bm", "query-field");
                queryField.put("field", fieldName);
                queryField.put("queryoperator", "like");
                bm.addQueryField(queryField);
            }
        }
        logger.log(Level.CONFIG, "customBM " + bm.getName() + ":" + bm.getObjectContext().toXML());
    }
}

