/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.cache;

import aurora.application.features.cache.ICacheProvider;
import aurora.application.features.cache.IEventHandler;
import aurora.application.features.msg.IConsumer;
import aurora.application.features.msg.IMessage;
import aurora.application.features.msg.IMessageStub;
import aurora.application.features.msg.INoticerConsumer;
import aurora.database.FetchDescriptor;
import aurora.database.service.BusinessModelService;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import aurora.service.IServiceFactory;
import aurora.service.ServiceInvoker;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import uncertain.cache.ICache;
import uncertain.cache.ITransactionCache;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.composite.transform.GroupTransformer;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;

public class RecordReloadHandler
extends AbstractLocatableObject
implements IEventHandler {
    protected String topic;
    private String operation;
    private String event;
    protected String reloadBM;
    protected String reloadProc;
    protected String groupByFields;
    protected ICacheProvider provider;
    protected IDatabaseServiceFactory dsFactory;
    protected ILogger logger;
    protected IProcedureManager procedureManager;
    protected IServiceFactory serviceFactory;

    @Override
    public void init(ICacheProvider provider, IObjectRegistry registry) {
        this.provider = provider;
        IMessageStub stub = (IMessageStub)registry.getInstanceOfType(IMessageStub.class);
        if (stub == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IMessageStub.class, this.getClass().getName());
        }
        IConsumer consumer = stub.getConsumer(this.topic);
        if (!(consumer instanceof INoticerConsumer)) {
            throw BuiltinExceptionFactory.createInstanceTypeWrongException(this.getOriginSource(), INoticerConsumer.class, IConsumer.class);
        }
        ((INoticerConsumer)consumer).addListener(this.event, this);
        this.dsFactory = (IDatabaseServiceFactory)registry.getInstanceOfType(IDatabaseServiceFactory.class);
        if (this.dsFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, DatabaseServiceFactory.class, this.getClass().getName());
        }
        if (this.operation == null) {
            if (this.event == null) {
                throw new IllegalArgumentException("event can't be null!");
            }
            String[] parts = this.event.split("/");
            this.operation = parts[parts.length - 1];
        }
        this.logger = LoggingContext.getLogger(this.getClass().getCanonicalName(), registry);
        this.procedureManager = (IProcedureManager)registry.getInstanceOfType(IProcedureManager.class);
        if (this.procedureManager == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IProcedureManager.class, this.getClass().getName());
        }
        this.serviceFactory = (IServiceFactory)registry.getInstanceOfType(IServiceFactory.class);
        if (this.serviceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IServiceFactory.class, this.getClass().getName());
        }
    }

    @Override
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public void onMessage(IMessage message) {
        this.beginCacheTransaction();
        try {
            if (IEventHandler.OPERATIONS.delete.name().equals(this.operation)) {
                this.delete(message);
            } else if (IEventHandler.OPERATIONS.update.name().equals(this.operation)) {
                this.update(message);
            } else if (IEventHandler.OPERATIONS.insert.name().equals(this.operation)) {
                this.insert(message);
            } else if (IEventHandler.OPERATIONS.reload.name().equals(this.operation)) {
                this.reload(message);
            } else {
                throw new IllegalArgumentException("operation:" + this.operation + " not support!");
            }
            this.commitCache();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "handle message exception", e);
            this.rollbackCache();
        }
    }

    public void delete(IMessage message) throws Exception {
        ICache cache = this.provider.getCache();
        if (cache == null) {
            throw new IllegalArgumentException("Can't find cache instance from provier:" + this.provider.getCacheName());
        }
        String messageKey = TextParser.parse(this.provider.getKey(), message.getProperties());
        cache.remove(messageKey);
        if (this.reloadBM != null) {
            this.executeBM(message);
        } else if (this.reloadProc != null) {
            this.executeProc(this.reloadProc, message.getProperties());
        }
    }

    private void executeBM(IMessage message) throws Exception {
        block16: {
            List childs;
            String type;
            CompositeMap data;
            ICache cache;
            block19: {
                block18: {
                    block17: {
                        cache = this.provider.getCache();
                        if (cache == null) {
                            throw new IllegalArgumentException("Can't find cache instance from provier:" + this.provider.getCacheName());
                        }
                        if (this.reloadBM == null) break block16;
                        data = this.queryBM(this.reloadBM, message.getProperties());
                        if (data == null) {
                            return;
                        }
                        if (this.groupByFields != null) {
                            CompositeMap config = new CompositeMap();
                            CompositeMap level1 = new CompositeMap();
                            level1.put("group_key_fields", this.groupByFields);
                            level1.put("record_name", "level1");
                            config.addChild(level1);
                            data = GroupTransformer.transformByConfig((CompositeMap)data.clone(), config);
                        }
                        type = this.provider.getType();
                        childs = data.getChilds();
                        if (!ICacheProvider.VALUE_TYPE.value.name().equals(type)) break block17;
                        if (childs == null) {
                            String key = TextParser.parse(this.provider.getKey(), data);
                            String value = TextParser.parse(this.provider.getValue(), data);
                            cache.setValue(key, value);
                        } else {
                            for (Object child : data.getChilds()) {
                                CompositeMap record = (CompositeMap)child;
                                String key = TextParser.parse(this.provider.getKey(), record);
                                String value = TextParser.parse(this.provider.getValue(), record);
                                cache.setValue(key, value);
                            }
                        }
                        break block16;
                    }
                    if (!ICacheProvider.VALUE_TYPE.record.name().equals(type)) break block18;
                    if (childs == null) {
                        String key = TextParser.parse(this.provider.getKey(), data);
                        cache.setValue(key, data);
                    } else {
                        for (Object child : data.getChilds()) {
                            CompositeMap record = (CompositeMap)child;
                            String key = TextParser.parse(this.provider.getKey(), record);
                            cache.setValue(key, record);
                        }
                    }
                    break block16;
                }
                if (!ICacheProvider.VALUE_TYPE.valueSet.name().equals(type)) break block19;
                if (childs == null) {
                    return;
                }
                for (Object child : data.getChilds()) {
                    CompositeMap record = (CompositeMap)child;
                    String key = TextParser.parse(this.provider.getKey(), record);
                    List new_values = record.getChilds();
                    if (new_values == null) {
                        throw new IllegalArgumentException("Value type is 'valueSet', please group by the data first!");
                    }
                    LinkedList<String> value_list = new LinkedList<String>();
                    cache.setValue(key, value_list);
                    for (Object value : new_values) {
                        CompositeMap newValue_record = (CompositeMap)value;
                        String new_value = TextParser.parse(this.provider.getValue(), newValue_record);
                        value_list.add(new_value);
                    }
                }
                break block16;
            }
            if (!ICacheProvider.VALUE_TYPE.recordSet.name().equals(type)) break block16;
            if (childs == null) {
                return;
            }
            for (Object child : data.getChilds()) {
                CompositeMap record = (CompositeMap)child;
                String key = TextParser.parse(this.provider.getKey(), record);
                List new_values = record.getChilds();
                if (new_values == null) {
                    throw new IllegalArgumentException("Value type is 'recordSet', please group by the data first!");
                }
                LinkedList value_list = new LinkedList();
                cache.setValue(key, value_list);
                value_list.addAll(new_values);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeMap queryBM(String bm_name, CompositeMap queryMap) throws Exception {
        SqlServiceContext sqlContext = this.dsFactory.createContextWithConnection();
        try {
            CompositeMap resultMap;
            CompositeMap context = sqlContext.getObjectContext();
            if (context == null) {
                context = new CompositeMap();
            }
            BusinessModelService service = this.dsFactory.getModelService(bm_name, context);
            CompositeMap compositeMap = resultMap = service.queryAsMap(queryMap, FetchDescriptor.fetchAll());
            return compositeMap;
        }
        finally {
            if (sqlContext != null) {
                sqlContext.freeConnection();
            }
        }
    }

    protected void executeProc(String procedure, CompositeMap context) {
        this.beginCacheTransaction();
        try {
            this.logger.log(Level.CONFIG, "load procedure:{0}", new Object[]{procedure});
            Procedure proc = null;
            try {
                proc = this.procedureManager.loadProcedure(procedure);
            }
            catch (Exception ex) {
                throw BuiltinExceptionFactory.createResourceLoadException(this, procedure, ex);
            }
            String name = "Cache." + procedure;
            if (context != null) {
                ServiceInvoker.invokeProcedureWithTransaction(name, proc, this.serviceFactory, context);
            } else {
                ServiceInvoker.invokeProcedureWithTransaction(name, proc, this.serviceFactory);
            }
            this.commitCache();
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Error when invoking procedure " + procedure, ex);
            this.rollbackCache();
        }
    }

    public void insert(IMessage message) throws Exception {
        this.refresh(message, IEventHandler.OPERATIONS.insert.name());
    }

    public void update(IMessage message) throws Exception {
        this.refresh(message, IEventHandler.OPERATIONS.update.name());
    }

    public void refresh(IMessage message, String operation) throws Exception {
        ICache cache = this.provider.getCache();
        CompositeMap properties = message.getProperties();
        if (cache == null) {
            throw new IllegalArgumentException("Can't find cache instance from provier:" + this.provider.getCacheName());
        }
        String messageKey = TextParser.parse(this.provider.getKey(), message.getProperties());
        if (this.reloadBM != null) {
            if (IEventHandler.OPERATIONS.update.name().equals(operation)) {
                cache.remove(messageKey);
            }
            this.executeBM(message);
        } else if (this.reloadProc != null) {
            if (IEventHandler.OPERATIONS.update.name().equals(operation)) {
                cache.remove(messageKey);
            }
            this.executeProc(this.reloadProc, properties);
        } else {
            String type = this.provider.getType();
            if (ICacheProvider.VALUE_TYPE.value.name().equals(type)) {
                String value = TextParser.parse(this.provider.getValue(), properties);
                cache.setValue(messageKey, value);
            } else if (ICacheProvider.VALUE_TYPE.valueSet.name().equals(type)) {
                List new_values = properties.getChilds();
                if (new_values == null) {
                    throw new IllegalArgumentException("Value type is 'valueSet', please group by the data first!");
                }
                LinkedList<String> value_list = new LinkedList<String>();
                cache.setValue(messageKey, value_list);
                for (Object value : new_values) {
                    CompositeMap newValue_record = (CompositeMap)value;
                    String new_value = TextParser.parse(this.provider.getValue(), newValue_record);
                    value_list.add(new_value);
                }
            } else if (ICacheProvider.VALUE_TYPE.record.name().equals(type)) {
                cache.setValue(messageKey, properties);
            } else if (ICacheProvider.VALUE_TYPE.recordSet.name().equals(type)) {
                List new_values = properties.getChilds();
                if (new_values == null) {
                    throw new IllegalArgumentException("Value type is 'recordSet', please group by the data first!");
                }
                LinkedList value_list = new LinkedList();
                cache.setValue(messageKey, value_list);
                value_list.addAll(new_values);
            }
        }
    }

    public void reload(IMessage message) throws Exception {
        this.provider.reload();
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getReloadBM() {
        return this.reloadBM;
    }

    public void setReloadBM(String reloadBM) {
        this.reloadBM = reloadBM;
    }

    public String getReloadProc() {
        return this.reloadProc;
    }

    public void setReloadProc(String reloadProc) {
        this.reloadProc = reloadProc;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getGroupByFields() {
        return this.groupByFields;
    }

    public void setGroupByFields(String groupByFields) {
        this.groupByFields = groupByFields;
    }

    public void beginCacheTransaction() {
        ICache cache = this.provider.getCache();
        if (this.isITransactionCache(cache)) {
            ((ITransactionCache)cache).beginTransaction();
        }
    }

    public void commitCache() {
        ICache cache = this.provider.getCache();
        if (this.isITransactionCache(cache)) {
            ((ITransactionCache)cache).commit();
        }
    }

    public void rollbackCache() {
        ICache cache = this.provider.getCache();
        if (this.isITransactionCache(cache)) {
            ((ITransactionCache)cache).rollback();
        }
    }

    private boolean isITransactionCache(ICache cache) {
        return cache != null && cache instanceof ITransactionCache;
    }
}

