/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features;

import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.util.Enumeration;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import uncertain.composite.CompositeMap;
import uncertain.ocm.ISingleton;

public class HttpRequestTransfer
implements ISingleton {
    private static final String KEY_REQUEST = "request";
    private static final String KEY_ADDRESS = "address";

    public static void copyParameter(HttpServletRequest request, ServiceInstance svc) {
        Enumeration ep = request.getParameterNames();
        CompositeMap params = svc.getServiceContext().getParameter();
        while (ep.hasMoreElements()) {
            String name = (String)ep.nextElement();
            String[] values = request.getParameterValues(name);
            if (values == null) {
                params.put(name, (Object)null);
                continue;
            }
            if (values.length == 1) {
                params.put(name, values[0]);
                continue;
            }
            if (values.length <= 1) continue;
            params.put(name, values);
        }
    }

    public static void copyHeader(HttpServletRequest request, ServiceInstance svc) {
        CompositeMap req_map = svc.getContextMap().getChild(KEY_REQUEST);
        if (req_map == null) {
            req_map = svc.getContextMap().createChild(KEY_REQUEST);
        }
        Enumeration head_enum = request.getHeaderNames();
        while (head_enum.hasMoreElements()) {
            String head = (String)head_enum.nextElement();
            String head_value = request.getHeader(head);
            req_map.put(head, head_value);
        }
        req_map.put(KEY_ADDRESS, request.getRemoteAddr());
    }

    public static void copyRequest(HttpServiceInstance svc) {
        HttpServletRequest request = svc.getRequest();
        CompositeMap r = svc.getContextMap().createChild(KEY_REQUEST);
        r.put(KEY_ADDRESS, request.getRemoteAddr());
        r.put("url", request.getRequestURI());
        r.put("server_name", request.getServerName());
        r.put("context_path", request.getContextPath());
        r.put("server_port", new Integer(request.getServerPort()));
        r.put("request_id", UUID.randomUUID());
        CompositeMap cookie = svc.getContextMap().createChild("cookie");
        HttpRequestTransfer.populateCookieMap(request, cookie);
        HttpRequestTransfer.copyParameter(svc.getRequest(), svc);
        HttpRequestTransfer.copyHeader(svc.getRequest(), svc);
    }

    public static void populateCookieMap(HttpServletRequest request, CompositeMap target) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                CompositeMap m = HttpRequestTransfer.createCookieMap(cookies[i]);
                target.put(cookies[i].getName(), m);
            }
        }
    }

    public static CompositeMap createCookieMap(Cookie cookie) {
        CompositeMap m = new CompositeMap("cookie");
        m.put("name", cookie.getName());
        m.put("value", cookie.getValue());
        m.put("domain", cookie.getDomain());
        m.put("path", cookie.getPath());
        m.putInt("maxage", cookie.getMaxAge());
        m.putBoolean("secure", cookie.getSecure());
        return m;
    }
}

