/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.spnego;

public final class Base64 {
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    private Base64() {
    }

    public static String encode(byte[] bytes) {
        int block;
        int length = bytes.length;
        if (length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder((int)Math.ceil((double)length / 3.0) * 4);
        int remainder = length % 3;
        length -= remainder;
        int idx = 0;
        while (idx < length) {
            block = (bytes[idx++] & 0xFF) << 16 | (bytes[idx++] & 0xFF) << 8 | bytes[idx++] & 0xFF;
            buffer.append(ALPHABET.charAt(block >>> 18));
            buffer.append(ALPHABET.charAt(block >>> 12 & 0x3F));
            buffer.append(ALPHABET.charAt(block >>> 6 & 0x3F));
            buffer.append(ALPHABET.charAt(block & 0x3F));
        }
        if (remainder == 0) {
            return buffer.toString();
        }
        if (remainder == 1) {
            block = (bytes[idx] & 0xFF) << 4;
            buffer.append(ALPHABET.charAt(block >>> 6));
            buffer.append(ALPHABET.charAt(block & 0x3F));
            buffer.append("==");
            return buffer.toString();
        }
        block = ((bytes[idx++] & 0xFF) << 8 | bytes[idx] & 0xFF) << 2;
        buffer.append(ALPHABET.charAt(block >>> 12));
        buffer.append(ALPHABET.charAt(block >>> 6 & 0x3F));
        buffer.append(ALPHABET.charAt(block & 0x3F));
        buffer.append("=");
        return buffer.toString();
    }

    public static byte[] decode(String string) {
        int length = string.length();
        if (length == 0) {
            return new byte[0];
        }
        int pad = string.charAt(length - 2) == '=' ? 2 : (string.charAt(length - 1) == '=' ? 1 : 0);
        int size = length * 3 / 4 - pad;
        byte[] buffer = new byte[size];
        int idx = 0;
        int index = 0;
        while (idx < length) {
            int block = (ALPHABET.indexOf(string.charAt(idx++)) & 0xFF) << 18 | (ALPHABET.indexOf(string.charAt(idx++)) & 0xFF) << 12 | (ALPHABET.indexOf(string.charAt(idx++)) & 0xFF) << 6 | ALPHABET.indexOf(string.charAt(idx++)) & 0xFF;
            buffer[index++] = (byte)(block >>> 16);
            if (index < size) {
                buffer[index++] = (byte)(block >>> 8 & 0xFF);
            }
            if (index >= size) continue;
            buffer[index++] = (byte)(block & 0xFF);
        }
        return buffer;
    }
}

