/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.poi;

import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelCellStyles {
    private CellStyle dateStyle;
    private CellStyle headerStyle;
    private CellStyle warningStyle;

    public ExcelCellStyles(Workbook wb) {
        CreationHelper helper = wb.getCreationHelper();
        DataFormat fmt = helper.createDataFormat();
        this.dateStyle = wb.createCellStyle();
        this.dateStyle.setDataFormat(fmt.getFormat("yyyy-mm-dd hh:mm:ss"));
        this.headerStyle = wb.createCellStyle();
        Font headerFont = wb.createFont();
        headerFont.setFontName("\u5b8b\u4f53");
        headerFont.setBoldweight((short)700);
        headerFont.setFontHeightInPoints((short)12);
        this.headerStyle.setFont(headerFont);
        this.headerStyle.setAlignment((short)2);
        this.headerStyle.setVerticalAlignment((short)1);
        this.warningStyle = wb.createCellStyle();
        Font warningFont = wb.createFont();
        warningFont.setBoldweight((short)700);
        warningFont.setColor((short)10);
        this.warningStyle.setFont(warningFont);
    }

    public CellStyle getDateStyle() {
        return this.dateStyle;
    }

    public CellStyle getHeaderStyle() {
        return this.headerStyle;
    }

    public CellStyle getWarningStyle() {
        return this.warningStyle;
    }
}

