/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.mail;

import aurora.plugin.mail.Attachment;
import aurora.plugin.mail.SendMailException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class SendMail {
    private String ttitle;
    private String tcontent;
    private String smtpServer;
    private String tto;
    private String cto;
    private String tfrom;
    private String password;
    private String userName;
    private String port;
    private Attachment[] attachments;
    private boolean auth = false;

    public void check() {
        if (this.smtpServer == null || "".equals(this.smtpServer)) {
            throw new SendMailException("\u6536\u4ef6\u4eba\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.tfrom == null || "".equals(this.tfrom)) {
            throw new SendMailException("\u53d1\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.password == null || "".equals(this.password)) {
            throw new SendMailException("\u670d\u52a1\u5668\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.tcontent == null || "".equals(this.tcontent)) {
            throw new SendMailException("\u90ae\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.tto == null || "".equals(this.tto)) {
            throw new SendMailException("\u6536\u4ef6\u4eba\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public void sendMail() throws Exception {
        Properties props = new Properties();
        props.put("mail.smtp.host", this.smtpServer);
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.port", this.port);
        Session s = null;
        if (this.auth) {
            props.put("mail.smtp.auth", "true");
            SmtpAuth smtpAuth = new SmtpAuth(this.userName, this.password);
            s = Session.getDefaultInstance((Properties)props, (Authenticator)smtpAuth);
        } else {
            props.put("mail.smtp.auth", "false");
            s = Session.getDefaultInstance((Properties)props, null);
        }
        MimeMessage message = new MimeMessage(s);
        InternetAddress from = new InternetAddress(this.tfrom);
        message.setFrom((Address)from);
        message.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.tto));
        if (this.cto != null && !"".equals(this.cto)) {
            message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)this.cto));
        }
        message.setSubject(this.ttitle);
        message.setSentDate(new Date());
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart mbp = new MimeBodyPart();
        mbp.setContent((Object)this.tcontent, "text/html;charset=utf-8");
        mp.addBodyPart((BodyPart)mbp);
        this.addAttachment((Multipart)mp);
        message.setContent((Multipart)mp);
        Transport.send((Message)message, (Address[])message.getAllRecipients());
    }

    protected void addAttachment(Multipart mp) throws MessagingException, UnsupportedEncodingException {
        if (this.attachments != null) {
            for (int i = 0; i < this.attachments.length; ++i) {
                MimeBodyPart mbp = new MimeBodyPart();
                String fileName = this.attachments[i].getPath();
                FileDataSource fds = new FileDataSource(fileName);
                mbp.setDataHandler(new DataHandler((DataSource)fds));
                String encodeFileName = MimeUtility.encodeText((String)this.attachments[i].getName());
                mbp.setFileName(encodeFileName);
                mp.addBodyPart((BodyPart)mbp);
            }
        }
    }

    public String getTtitle() {
        return this.ttitle;
    }

    public void setTtitle(String ttitle) {
        this.ttitle = ttitle;
    }

    public String getTcontent() {
        return this.tcontent;
    }

    public void setTcontent(String tcontent) {
        this.tcontent = tcontent;
    }

    public String getTfrom() {
        return this.tfrom;
    }

    public void setTfrom(String tfrom) {
        this.tfrom = tfrom;
    }

    public String getTto() {
        return this.tto;
    }

    public void setTto(String tto) {
        this.tto = tto;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    public String getCto() {
        return this.cto;
    }

    public void setCto(String cto) {
        this.cto = cto;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setAttachments(Attachment[] attaches) {
        this.attachments = attaches;
    }

    public boolean isAuth() {
        return this.auth;
    }

    public void setAuth(boolean auth) {
        this.auth = auth;
    }

    class SmtpAuth
    extends Authenticator {
        private String username;
        private String password;

        public SmtpAuth(String username, String password) {
            this.username = username;
            this.password = password;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

