/*
 * Decompiled with CFR 0.152.
 */
package uncertain.util.reflect;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import uncertain.util.reflect.MethodCache;
import uncertain.util.reflect.MethodDeclareClassFilter;
import uncertain.util.reflect.MethodFilter;

public class MethodNameFilter
implements MethodFilter {
    Class[] params;
    String prefix;
    String postfix;

    public MethodNameFilter(String prefix, String postfix, Class[] params) {
        this.prefix = prefix;
        this.postfix = postfix;
        this.params = params;
    }

    public boolean accepts(Class owner, Method m) {
        boolean accept = true;
        String name = m.getName();
        Class<?>[] pms = m.getParameterTypes();
        if (this.prefix != null) {
            boolean bl = accept = accept && name.startsWith(this.prefix);
        }
        if (this.postfix != null) {
            boolean bl = accept = accept && name.endsWith(this.postfix);
        }
        if (this.params != null) {
            if (this.params.length != pms.length) {
                accept = false;
            } else {
                int i = 0;
                while (i < this.params.length) {
                    if (!this.params[i].equals(pms[i])) {
                        accept = false;
                        break;
                    }
                    ++i;
                }
            }
        }
        return accept;
    }

    public static void main(String[] args) throws Exception {
        MethodCache cache = new MethodCache();
        MethodNameFilter filter = new MethodNameFilter("get", null, null);
        cache.addFilter(filter);
        cache.addFilter(new MethodDeclareClassFilter());
        Collection clt = cache.getMethods(Class.forName("javax.servlet.http.HttpServletRequest"));
        Iterator it = clt.iterator();
        while (it.hasNext()) {
            System.out.println(((Method)it.next()).getName());
        }
    }
}

