/*
 * Decompiled with CFR 0.152.
 */
package uncertain.util.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import uncertain.util.reflect.ClassIterateHandle;

public class ClassIterator {
    public void iterate(Class cls, ClassIterateHandle handle) throws SecurityException {
        handle.beginIterate(cls);
        Method[] methods = cls.getMethods();
        int n = 0;
        while (n < methods.length) {
            handle.onMethod(cls, methods[n]);
            ++n;
        }
        Class<?>[] itfcs = cls.getInterfaces();
        n = 0;
        while (n < itfcs.length) {
            handle.onInterface(cls, itfcs[n]);
            ++n;
        }
        Constructor<?>[] cts = cls.getConstructors();
        n = 0;
        while (n < cts.length) {
            handle.onConstructor(cls, cts[n]);
            ++n;
        }
        Field[] flds = cls.getFields();
        n = 0;
        while (n < flds.length) {
            handle.onField(cls, flds[n]);
            ++n;
        }
        handle.endIterate(cls);
    }
}

