/*
 * Decompiled with CFR 0.152.
 */
package uncertain.util;

import uncertain.composite.CompositeMap;
import uncertain.util.IRecordFilter;

public class StringFieldFilter
implements IRecordFilter {
    Object mKey;
    String mSearchText;
    boolean mNoSearchText = false;
    boolean mSearchFromStart = false;
    boolean mCaseSensitive = false;

    public StringFieldFilter(Object key, boolean searchFromStart, boolean caseSensitive) {
        this.mKey = key;
        this.mSearchFromStart = searchFromStart;
        this.mCaseSensitive = caseSensitive;
    }

    public boolean accepts(CompositeMap record) {
        if (this.mNoSearchText) {
            return true;
        }
        Object value = record.get(this.mKey);
        if (value == null) {
            return this.mNoSearchText;
        }
        String text = value.toString();
        if (!this.mCaseSensitive) {
            text = text.toUpperCase();
        }
        if (this.mSearchFromStart) {
            return text.startsWith(this.mSearchText);
        }
        return text.indexOf(this.mSearchText) >= 0;
    }

    public String getSearchText() {
        return this.mSearchText;
    }

    public void setSearchText(String searchText) {
        this.mNoSearchText = false;
        this.mSearchText = searchText;
        if (this.mSearchText == null) {
            this.mNoSearchText = true;
        } else {
            if (this.mSearchText.length() == 0) {
                this.mNoSearchText = true;
            }
            if (!this.mCaseSensitive) {
                this.mSearchText = this.mSearchText.toUpperCase();
            }
        }
    }
}

