/*
 * Decompiled with CFR 0.152.
 */
package uncertain.pkg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import uncertain.composite.CompositeLoader;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.ClassRegistry;
import uncertain.ocm.ClassRegistryMBean;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;
import uncertain.pkg.ComponentPackage;
import uncertain.pkg.IInstanceCreationListener;
import uncertain.pkg.IPackageManager;
import uncertain.pkg.InstanceConfig;
import uncertain.pkg.PackagePath;
import uncertain.schema.SchemaManager;
import uncertain.util.FileUtil;

public class PackageManager
implements IPackageManager {
    public static final String FILE_PACKAGE_XML = "package.xml";
    public static final String KEY_CONFIG = "config";
    CompositeLoader mCompositeLoader;
    OCManager mOCManager;
    HashMap<String, ComponentPackage> mPackageNameMap = new HashMap();
    ClassRegistry mClassRegistry;
    SchemaManager mSchemaManager;
    HashMap<String, ComponentPackage> mLoadedPackagePaths = new HashMap();
    String mTempPath;

    public static boolean isPackageDirectory(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        File config_dir = new File(dir, KEY_CONFIG);
        if (!config_dir.exists() || !config_dir.isDirectory()) {
            return false;
        }
        File pkg_xml = new File(config_dir, FILE_PACKAGE_XML);
        return pkg_xml.exists();
    }

    public PackageManager() {
        this.mCompositeLoader = CompositeLoader.createInstanceForOCM(null);
        this.mOCManager = OCManager.getInstance();
        this.mClassRegistry = this.mOCManager.getClassRegistry();
        this.mSchemaManager = new SchemaManager();
    }

    public PackageManager(CompositeLoader loader, OCManager oc_manager, SchemaManager schema_manager) {
        this.mCompositeLoader = loader;
        this.mOCManager = oc_manager;
        this.mClassRegistry = this.mOCManager.getClassRegistry();
        this.mSchemaManager = schema_manager;
    }

    public CompositeLoader getCompositeLoader() {
        return this.mCompositeLoader;
    }

    public ClassRegistryMBean getClassRegistry() {
        return this.mClassRegistry;
    }

    public void setClassRegistry(ClassRegistry mClassRegistry) {
        this.mClassRegistry = mClassRegistry;
    }

    public OCManager getOCManager() {
        return this.mOCManager;
    }

    public ComponentPackage loadPackage(String path) throws IOException {
        return this.loadPackage(path, ComponentPackage.class);
    }

    protected void initPackage(ComponentPackage pkg) {
        pkg.setPackageManager(this);
    }

    public void addPackage(ComponentPackage pkg) {
        ClassRegistry reg;
        String name = pkg.getName();
        if (pkg.getName() == null) {
            throw new IllegalArgumentException("Package name can't be null");
        }
        if (this.mPackageNameMap.containsKey(name)) {
            throw new IllegalArgumentException("Package with name " + name + " is already loaded");
        }
        this.mPackageNameMap.put(name, pkg);
        this.initPackage(pkg);
        SchemaManager sm = pkg.getSchemaManager();
        if (sm != null) {
            this.mSchemaManager.addAll(sm);
        }
        if ((reg = pkg.getClassRegistry()) != null) {
            this.mClassRegistry.addAll(reg);
        }
    }

    public ComponentPackage loadPackage(String path, Class implement_cls) throws IOException {
        File f = new File(path);
        ComponentPackage pkg = this.mLoadedPackagePaths.get(path = f.getCanonicalPath());
        if (pkg != null) {
            return pkg;
        }
        try {
            pkg = (ComponentPackage)implement_cls.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't create instance of " + implement_cls.getName(), ex);
        }
        this.initPackage(pkg);
        pkg.load(path);
        this.addPackage(pkg);
        return pkg;
    }

    public ComponentPackage getPackage(String name) {
        return this.mPackageNameMap.get(name);
    }

    public SchemaManager getSchemaManager() {
        return this.mSchemaManager;
    }

    public void loadPackgeDirectory(String root_directory) throws IOException {
        File path = new File(root_directory);
        if (!path.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(root_directory) + " is not a directory");
        }
        File[] files = path.listFiles();
        List<File> file_list = FileUtil.getSortedList(files);
        for (File file : file_list) {
            if (!PackageManager.isPackageDirectory(file)) continue;
            this.loadPackage(file.getAbsolutePath());
        }
    }

    protected void extractTempZipFile(JarInputStream jis, File baseDir, String file_name) throws IOException {
        File file = new File(baseDir, file_name);
        file.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(file);
        int c = jis.read();
        while (c != -1) {
            fos.write(c);
            c = jis.read();
        }
        fos.close();
    }

    protected File createTempPackageDir(String jar_path, String pkg_name) throws IOException {
        if (jar_path == null) {
            throw new NullPointerException("jar_path parameter is null");
        }
        InputStream is = null;
        File tempDir = null;
        if (this.mTempPath != null) {
            tempDir = new File(this.mTempPath);
            if (!tempDir.exists() || !tempDir.isDirectory()) {
                throw BuiltinExceptionFactory.createInvalidPathException(null, this.mTempPath);
            }
        } else {
            tempDir = new File(System.getProperty("java.io.tmpdir"));
        }
        try {
            try {
                URL u = new URL(jar_path);
                is = u.openStream();
            }
            catch (MalformedURLException ex) {
                is = new FileInputStream(jar_path);
            }
            JarInputStream jis = new JarInputStream(is);
            ZipEntry ze = null;
            File baseDir = tempDir;
            while ((ze = jis.getNextEntry()) != null) {
                String name = ze.getName();
                if (!name.startsWith(pkg_name)) continue;
                if (ze.isDirectory()) {
                    baseDir = new File(tempDir, name);
                    if (baseDir.exists()) {
                        FileUtil.deleteDirectory(baseDir);
                    }
                    if (!baseDir.mkdirs()) {
                        throw new IOException("Can't create dir " + baseDir.getAbsolutePath());
                    }
                    baseDir.deleteOnExit();
                    continue;
                }
                this.extractTempZipFile(jis, tempDir, name);
                jis.closeEntry();
            }
            File file = new File(tempDir, pkg_name);
            return file;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private File getClassPathDirectory(String pkg_name) throws IOException {
        ClassLoader loader = PackageManager.class.getClassLoader();
        URL url = loader.getResource(pkg_name);
        if (url == null) {
            loader = Thread.currentThread().getContextClassLoader();
            url = loader.getResource(pkg_name);
        }
        if (url == null) {
            throw new IOException("Can't find " + pkg_name + " from current classpath");
        }
        String file = url.getFile();
        int index = file.indexOf("!");
        if (index > 0) {
            String jar_file = file.substring(0, index);
            File dir = this.createTempPackageDir(jar_file, pkg_name);
            return dir;
        }
        try {
            return new File(new URI(url.toString()));
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void loadPackgeFromClassPath(String pkg_name) throws IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(pkg_name);
        if (url == null) {
            throw new IOException("Can't load " + pkg_name);
        }
        String file = url.getFile();
        int index = file.indexOf("!");
        if (index > 0) {
            String jar_file = file.substring(0, index);
            File dir = this.createTempPackageDir(jar_file, pkg_name);
            this.loadPackage(dir.getAbsolutePath());
        } else {
            URI uri = null;
            try {
                uri = new URI(url.toString());
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException("Can't parse uri from resource url " + url.toString());
            }
            this.loadPackage(new File(uri).getAbsolutePath());
        }
    }

    public void loadPackageFromRootClassPath(String root_classpath) throws IOException {
        File path_file = this.getClassPathDirectory(root_classpath);
        this.loadPackgeDirectory(path_file.getAbsolutePath());
    }

    public void loadPackage(PackagePath path) throws IOException {
        if (path.getPath() != null) {
            this.loadPackage(path.getPath());
        } else if (path.getClassPath() != null) {
            this.loadPackgeFromClassPath(path.getClassPath());
        } else if (path.getRootClassPath() != null) {
            this.loadPackageFromRootClassPath(path.getRootClassPath());
        }
    }

    public void loadPackagePaths(PackagePath[] paths) throws IOException {
        int i = 0;
        while (i < paths.length) {
            this.loadPackage(paths[i]);
            ++i;
        }
    }

    public void createInstances(IObjectRegistry reg, IInstanceCreationListener listener, boolean continueWithException) {
        LinkedList<InstanceConfig> lst = new LinkedList<InstanceConfig>();
        for (ComponentPackage pkg : this.mPackageNameMap.values()) {
            InstanceConfig cfg = pkg.getInstanceConfig();
            if (cfg == null) continue;
            lst.add(cfg);
        }
        InstanceConfig.loadComponents(lst, reg, this.mCompositeLoader, this.mOCManager, listener, continueWithException);
    }

    public String getTempPath() {
        return this.mTempPath;
    }

    public void setTempPath(String tempPath) {
        this.mTempPath = tempPath;
    }
}

