/*
 * Decompiled with CFR 0.152.
 */
package uncertain.pkg;

import java.io.File;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;
import uncertain.pkg.Type;

public class ConfigurableInstance
extends AbstractLocatableObject {
    Type[] requiredInstances;
    Type[] implementTypes;
    String configFile;
    String alternativeConfigFile;
    File actualConfigFile;
    String description;

    public int getRequiredCount() {
        return this.requiredInstances == null ? 0 : this.requiredInstances.length;
    }

    public Type[] getRequiredInstances() {
        return this.requiredInstances;
    }

    public void setRequiredInstances(Type[] requiredInstances) {
        this.requiredInstances = requiredInstances;
    }

    public Type[] getImplementTypes() {
        return this.implementTypes;
    }

    public void setImplementTypes(Type[] implementTypes) {
        this.implementTypes = implementTypes;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getAlternativeConfigFile() {
        return this.alternativeConfigFile;
    }

    public void setAlternativeConfigFile(String alternativeConfigFile) {
        this.alternativeConfigFile = alternativeConfigFile;
    }

    public void addDescription(CompositeMap desc) {
        this.description = desc.getText();
    }

    public boolean canCreateInstance(IObjectRegistry reg) {
        if (this.requiredInstances == null) {
            return true;
        }
        int i = 0;
        while (i < this.requiredInstances.length) {
            if (reg.getInstanceOfType(this.requiredInstances[i].getType()) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void registerInstance(Object inst, IObjectRegistry reg) {
        if (this.implementTypes != null) {
            Type[] typeArray = this.implementTypes;
            int n = this.implementTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Type t = typeArray[n2];
                reg.registerInstance(t.getType(), inst);
                ++n2;
            }
        }
    }

    protected void setActualConfigFile(File file) {
        this.actualConfigFile = file;
    }

    protected File getActualConfigFile() {
        return this.actualConfigFile;
    }

    public Object createInstance(CompositeLoader composite_loader, OCManager oc_manager) {
        File config_file = this.getActualConfigFile();
        assert (config_file != null);
        assert (config_file.exists());
        String name = null;
        CompositeMap data = null;
        try {
            name = config_file.getCanonicalPath();
            data = composite_loader.loadByFullFilePath(name);
        }
        catch (Exception ex) {
            throw BuiltinExceptionFactory.createResourceLoadException(this, name, ex);
        }
        if (data == null) {
            throw BuiltinExceptionFactory.createResourceLoadException(this, name, null);
        }
        Object o = oc_manager.createObject(data);
        if (o == null) {
            throw BuiltinExceptionFactory.createCannotCreateInstanceFromConfigException(this, name);
        }
        return o;
    }
}

