/*
 * Decompiled with CFR 0.152.
 */
package uncertain.datatype;

import java.io.IOException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import uncertain.datatype.AbstractDataType;
import uncertain.datatype.ConvertionException;
import uncertain.datatype.DataType;

public class ClobType
extends AbstractDataType
implements DataType {
    public Class getJavaType() {
        return Clob.class;
    }

    public int getSqlType() {
        return 2005;
    }

    public Object getObject(CallableStatement stmt, int id) throws SQLException {
        return stmt.getClob(id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getObject(ResultSet rs, int id) throws SQLException {
        Clob aClob = rs.getClob(id);
        if (aClob == null) {
            return null;
        }
        try {
            StringBuffer buf = new StringBuffer();
            Reader reader = aClob.getCharacterStream();
            if (reader == null) {
                return null;
            }
            while (true) {
                int n;
                if ((n = reader.read()) == -1) {
                    return buf.toString();
                }
                buf.append((char)n);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void registerParameter(CallableStatement stmt, int id) throws SQLException {
        stmt.registerOutParameter(id, 2005);
    }

    public void setParameter(PreparedStatement stmt, int id, Object value) throws SQLException {
        if (value == null) {
            stmt.setNull(id, this.getSqlType());
        } else if (value instanceof Clob) {
            stmt.setClob(id, (Clob)value);
        } else {
            stmt.setString(id, value.toString());
        }
    }

    public Object convert(Object value) throws ConvertionException {
        return value;
    }
}

