/*
 * Decompiled with CFR 0.152.
 */
package uncertain.composite.transform;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import uncertain.composite.CompositeComparator;
import uncertain.composite.CompositeMap;
import uncertain.composite.transform.AbstractTransform;
import uncertain.core.ConfigurationError;
import uncertain.proc.ProcedureRunner;
import uncertain.util.StringSplitter;

public class MatrixTransform
extends AbstractTransform {
    final String KEY_SOURCE = "source";
    final String KEY_TARGET = "target";
    CompositeMap elementConifg;
    public static final String KEY_GROUP_FIELD = "groupfield";
    public static final String KEY_COLUMN_FIELD = "columnfield";
    public static final String KEY_VALUE_FIELD = "valuefield";
    public static final String KEY_SHARED_FIELD = "sharedfield";
    public static final String KEY_PUT_VALUE_ONLY = "putvalueonly";
    public static final String KEY_COLUMN_LIST = "_column_list";
    Object rowKeyField;
    Object colKeyField;
    String[] colValueFields;
    String[] columnFields;
    String[] sharedFields;
    boolean createMetaData = true;
    List transformedColumns;
    HashMap grouped_rows = new HashMap();
    HashMap grouped_cols = new HashMap();
    boolean fieldValueOnly = true;
    HashSet sharedFieldSet;

    public MatrixTransform(Object rowKeyField, String columnFieldStr, String colValueFieldStr, boolean fieldValueOnly) {
        this();
        this.rowKeyField = rowKeyField;
        this.colValueFields = StringSplitter.splitToArray(colValueFieldStr, ',', true);
        this.columnFields = StringSplitter.splitToArray(columnFieldStr, ',', true);
        this.colKeyField = this.columnFields[0];
        this.fieldValueOnly = fieldValueOnly;
    }

    public MatrixTransform(CompositeMap params) {
        this();
        this.init(params);
    }

    void assertParamNotNull(String name, Object v) {
        if (v == null) {
            throw new ConfigurationError("[MatrixTransformer] required parameter " + name + " is not set");
        }
    }

    public void init(CompositeMap params) {
        this.rowKeyField = params.get(KEY_GROUP_FIELD);
        this.colValueFields = StringSplitter.splitToArray(params.getString(KEY_VALUE_FIELD), ',', true);
        this.columnFields = StringSplitter.splitToArray(params.getString(KEY_COLUMN_FIELD), ',', true);
        this.sharedFields = StringSplitter.splitToArray(params.getString(KEY_SHARED_FIELD), ',', true);
        this.assertParamNotNull(KEY_GROUP_FIELD, this.rowKeyField);
        this.assertParamNotNull(KEY_COLUMN_FIELD, this.columnFields);
        this.colKeyField = this.columnFields[0];
        this.fieldValueOnly = params.getBoolean(KEY_PUT_VALUE_ONLY, true);
        if (this.sharedFields != null && this.sharedFields.length > 0) {
            this.sharedFieldSet = new HashSet();
            int i = 0;
            while (i < this.sharedFields.length) {
                this.sharedFieldSet.add(this.sharedFields[i]);
                ++i;
            }
        }
    }

    public MatrixTransform() {
        this.transformedColumns = new LinkedList();
    }

    public CompositeMap transform(CompositeMap source, CompositeMap transform_config) {
        this.init(transform_config);
        return this.transform(source);
    }

    public List getColumns() {
        return this.transformedColumns;
    }

    public CompositeMap transform(CompositeMap source) {
        if (source == null) {
            System.out.println("[MatrixTransformer] model is null");
            return null;
        }
        List lst = source.getChilds();
        if (lst == null) {
            return source;
        }
        ListIterator it = lst.listIterator();
        while (it.hasNext()) {
            CompositeMap target_map;
            boolean new_row = false;
            CompositeMap item = (CompositeMap)it.next();
            Object row_value = item.get(this.rowKeyField);
            if (row_value == null) {
                System.out.println("[MatrixTransformer] record has not key field:" + item.toXML());
            }
            if ((target_map = (CompositeMap)this.grouped_rows.get(row_value)) == null) {
                this.grouped_rows.put(row_value, item);
                target_map = item;
                new_row = true;
            } else {
                it.remove();
            }
            String col_field = item.getString(this.colKeyField);
            CompositeMap col_config = (CompositeMap)this.grouped_cols.get(col_field);
            if (col_config == null) {
                CompositeMap column = new CompositeMap("column");
                int i = 0;
                while (i < this.columnFields.length) {
                    column.put(this.columnFields[i], item.get(this.columnFields[i]));
                    ++i;
                }
                this.transformedColumns.add(column);
                col_config = column;
                this.grouped_cols.put(col_field, col_config);
            }
            if (new_row) {
                int i = 0;
                while (i < this.columnFields.length) {
                    if (this.sharedFieldSet == null || !this.sharedFieldSet.contains(this.columnFields[i])) {
                        target_map.remove(this.columnFields[i]);
                    }
                    ++i;
                }
            }
            if (this.fieldValueOnly) {
                if (this.colValueFields != null) {
                    target_map.put(col_field, item.get(this.colValueFields[0]));
                }
            } else {
                col_config = (CompositeMap)col_config.clone();
                if (this.colValueFields != null) {
                    int i = 0;
                    while (i < this.colValueFields.length) {
                        col_config.put(this.colValueFields[i], item.get(this.colValueFields[i]));
                        ++i;
                    }
                }
                if (this.sharedFields != null) {
                    int i = 0;
                    while (i < this.sharedFields.length) {
                        col_config.put(this.sharedFields[i], target_map.get(this.sharedFields[i]));
                        ++i;
                    }
                }
                target_map.put(col_field, col_config);
            }
            if (this.colValueFields == null) continue;
            int i = 0;
            while (i < this.colValueFields.length) {
                target_map.remove(this.colValueFields[i]);
                ++i;
            }
        }
        if (this.createMetaData) {
            Collections.sort(this.transformedColumns, new CompositeComparator(this.colKeyField.toString()));
            CompositeMap meta = new CompositeMap("columns");
            meta.addChilds(this.transformedColumns);
            source.put(KEY_COLUMN_LIST, meta);
        }
        return source;
    }

    public boolean isFieldValueOnly() {
        return this.fieldValueOnly;
    }

    public void setFieldValueOnly(boolean fieldValueOnly) {
        this.fieldValueOnly = fieldValueOnly;
    }

    public Object getColumnValue(CompositeMap column) {
        return column == null ? null : column.get(this.colKeyField);
    }

    public String[] getColumnValueFields() {
        return this.colValueFields;
    }

    public boolean getCreateMetaData() {
        return this.createMetaData;
    }

    public void setCreateMetaData(boolean createMetaData) {
        this.createMetaData = createMetaData;
    }

    public void run(ProcedureRunner runner) throws Exception {
        String source = this.elementConifg.getString("source");
        assert (source != null);
        String target = this.elementConifg.getString("target");
        assert (target != null);
        CompositeMap context = runner.getContext();
        CompositeMap sourceMap = (CompositeMap)context.getObject(source);
        CompositeMap targetMap = (CompositeMap)sourceMap.clone();
        context.putObject(target, (Object)targetMap, true);
        this.transform(targetMap, this.elementConifg);
    }

    public void beginConfigure(CompositeMap config) {
        this.elementConifg = config;
    }
}

