/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std.config;

import aurora.presentation.component.std.config.ComponentConfig;
import aurora.presentation.component.std.config.GridColumnConfig;
import uncertain.composite.CompositeMap;

public class TableConfig
extends ComponentConfig {
    public static final String VERSION = "$Revision: 7048 $";
    public static final String TAG_NAME = "table";
    public static final String PROPERTITY_TITLE = "title";
    public static final String PROPERTITY_COLUMNS = "columns";
    public static final String PROPERTITY_EDITORS = "editors";
    public static final String PROPERTITY_DATASET = "dataset";
    public static final String PROPERTITY_NAVBAR = "navbar";
    public static final String PROPERTITY_ROW_RENDERER = "rowrenderer";
    public static final String PROPERTITY_PERCENT_WIDTH = "percentwidth";
    public static final String PROPERTITY_SHOW_HEAD = "showhead";
    public static final String PROPERTITY_CAN_WHEEL = "canwheel";
    public static final String PROPERTITY_AUTO_APPEND = "autoappend";

    public static TableConfig getInstance() {
        TableConfig model = new TableConfig();
        model.initialize(TableConfig.createContext(null, TAG_NAME));
        return model;
    }

    public static TableConfig getInstance(CompositeMap context) {
        TableConfig model = new TableConfig();
        model.initialize(TableConfig.createContext(context, TAG_NAME));
        return model;
    }

    public boolean isShowHead() {
        return this.getBoolean(PROPERTITY_SHOW_HEAD, true);
    }

    public void setShowHead(boolean isShow) {
        this.putBoolean(PROPERTITY_SHOW_HEAD, isShow);
    }

    public String getTitle() {
        return this.getString(PROPERTITY_TITLE, "");
    }

    public void setTitle(String title) {
        this.putString(PROPERTITY_TITLE, title);
    }

    public String getRowRenderer() {
        return this.getString(PROPERTITY_ROW_RENDERER);
    }

    public void setRowRenderer(String renderer) {
        this.putString(PROPERTITY_ROW_RENDERER, renderer);
    }

    public String getPercentWidth() {
        return this.getString(PROPERTITY_PERCENT_WIDTH);
    }

    public void setPercentWidth(String percentWidth) {
        this.putString(PROPERTITY_PERCENT_WIDTH, percentWidth);
    }

    public String getDataSet() {
        return this.getString(PROPERTITY_DATASET);
    }

    public void setDataSet(String ds) {
        this.putString(PROPERTITY_DATASET, ds);
    }

    public CompositeMap getColumns() {
        CompositeMap context = this.getObjectContext();
        CompositeMap columns = context.getChild(PROPERTITY_COLUMNS);
        if (columns == null) {
            columns = new CompositeMap(PROPERTITY_COLUMNS);
            context.addChild(columns);
        }
        return columns;
    }

    public void addColumn(GridColumnConfig column) {
        CompositeMap columns = this.getColumns();
        columns.addChild(column.getObjectContext());
    }

    public CompositeMap getEditors() {
        CompositeMap context = this.getObjectContext();
        CompositeMap editors = context.getChild(PROPERTITY_EDITORS);
        if (editors == null) {
            editors = new CompositeMap(PROPERTITY_EDITORS);
            context.addChild(editors);
        }
        return editors;
    }

    public void addEditor(ComponentConfig editor) {
        CompositeMap editors = this.getEditors();
        editors.addChild(editor.getObjectContext());
    }

    public boolean hasNavBar() {
        return this.getBoolean(PROPERTITY_NAVBAR, false);
    }

    public void setNavBar(boolean nb) {
        this.putBoolean(PROPERTITY_NAVBAR, nb);
    }

    public boolean isCanWheel() {
        return this.getBoolean(PROPERTITY_CAN_WHEEL, true);
    }

    public void setCanWheel(boolean canPaste) {
        this.putBoolean(PROPERTITY_CAN_WHEEL, canPaste);
    }

    public boolean isAutoAppend() {
        return this.getBoolean(PROPERTITY_AUTO_APPEND, true);
    }

    public void setAutoAppend(boolean append) {
        this.putBoolean(PROPERTITY_AUTO_APPEND, append);
    }

    public String getWidthStr() {
        return this.getString("width");
    }
}

