/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.application.config.ScreenConfig;
import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.IDGenerator;
import aurora.presentation.component.std.JSONFunction;
import aurora.presentation.component.std.config.ComponentConfig;
import aurora.presentation.component.std.config.EventConfig;
import aurora.presentation.markup.HtmlPageContext;
import aurora.service.IService;
import aurora.service.ServiceInstance;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class Component {
    public static final String VERSION = "$Revision: 7073 $";
    protected static final String CONFIG = "config";
    protected static final String WRAP_CSS = "wrapClass";
    protected static final String BINDING = "binding";
    public static final String THEME_DEFAULT = "default";
    public static final String THEME_MAC = "mac";
    protected String id;
    private JSONObject listeners = new JSONObject();
    private StringBuffer bsb = new StringBuffer();
    private JSONObject config = new JSONObject();

    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        this.addStyleSheet(session, context, "base/Aurora-all-min.css");
        this.addJavaScript(session, context, "base/ext-core-min.js");
        this.addJavaScript(session, context, "base/Aurora-all-min.js");
        this.addJavaScript(session, context, "locale/aurora-lang-" + session.getLanguage() + ".js");
    }

    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return "";
    }

    protected int getDefaultWidth() {
        return 150;
    }

    protected int getDefaultHeight() {
        return 20;
    }

    protected Integer getComponentWidth(CompositeMap model, CompositeMap view, Map map) {
        String widthStr;
        String wstr;
        CompositeMap root = model.getRoot();
        CompositeMap vwc = null;
        ComponentConfig cc = new ComponentConfig();
        cc.initialize(view);
        String vws = null;
        Integer vw = null;
        if (root != null) {
            vws = (String)root.getObject("/parameter/@_vw");
            if (vws == null) {
                vwc = (CompositeMap)root.getObject("/cookie/@vw");
                if (vwc != null) {
                    vw = vwc.getInt("value");
                }
            } else {
                vw = Integer.valueOf(vws);
            }
        }
        Integer width = "".equals(wstr = TextParser.parse(widthStr = view.getString("width", "" + this.getDefaultWidth()), model)) ? new Integer(this.getDefaultWidth()) : Integer.valueOf(wstr);
        map.put("oldwidth", width);
        Integer marginWidth = cc.getMarginWidth();
        if (marginWidth != null && vw != null) {
            width = new Integer(vw - marginWidth > 0 ? vw - marginWidth : width);
            this.addConfig("marginwidth", marginWidth);
        }
        return width;
    }

    protected Integer getComponentHeight(CompositeMap model, CompositeMap view, Map map) {
        String heightStr;
        String hstr;
        CompositeMap root = model.getRoot();
        CompositeMap vhc = null;
        ComponentConfig cc = new ComponentConfig();
        cc.initialize(view);
        String vhs = null;
        Integer vh = null;
        if (root != null) {
            if (vhs == null) {
                vhc = (CompositeMap)root.getObject("/cookie/@vh");
                if (vhc != null) {
                    vh = vhc.getInt("value");
                }
            } else {
                vh = Integer.valueOf(vhs);
            }
        }
        Integer height = "".equals(hstr = TextParser.parse(heightStr = view.getString("height", "" + this.getDefaultHeight()), model)) ? new Integer(this.getDefaultHeight()) : Integer.valueOf(hstr);
        Integer marginHeight = cc.getMarginHeight();
        if (marginHeight != null && vh != null) {
            height = new Integer(vh - marginHeight > 0 ? vh - marginHeight : height);
            this.addConfig("marginheight", marginHeight);
        }
        return height;
    }

    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        List list;
        String name;
        CompositeMap view = context.getView();
        CompositeMap model = context.getModel();
        Map map = context.getMap();
        ComponentConfig cc = new ComponentConfig();
        cc.initialize(view);
        Boolean isCust = cc.isCust();
        this.id = cc.getId();
        if (this.id == null) {
            this.id = IDGenerator.getInstance().generate();
        } else if (isCust == null) {
            isCust = new Boolean(true);
        }
        this.addConfig("iscust", isCust);
        this.id = TextParser.parse(this.id, model);
        map.put("id", this.id);
        this.addConfig("id", this.id);
        String clazz = this.getDefaultClass(session, context);
        String className = cc.getClassName();
        if (className != null) {
            clazz = String.valueOf(clazz) + " " + className;
        }
        map.put(WRAP_CSS, clazz);
        map.put("tabindex", cc.getTabIndex());
        Integer width = this.getComponentWidth(model, view, map);
        map.put("width", width);
        this.addConfig("width", width);
        Integer height = this.getComponentHeight(model, view, map);
        if (height != 0) {
            map.put("height", height);
            this.addConfig("height", height);
        }
        if ((name = cc.getName()) == null) {
            name = IDGenerator.getInstance().generate();
        }
        map.put("name", name);
        String style = cc.getStyle();
        map.put("style", style == null ? "" : style);
        String value = cc.getValue();
        map.put("value", value == null ? "" : value);
        CompositeMap events = view.getChild("events");
        if (events != null && (list = events.getChilds()) != null) {
            for (CompositeMap event : list) {
                EventConfig eventConfig = EventConfig.getInstance(event);
                String eventName = eventConfig.getEventName();
                String handler = eventConfig.getHandler();
                if (!"".equals(eventName) && !"".equals(handler)) {
                    handler = TextParser.parse(handler, model);
                }
                this.addEvent(this.id, eventName, handler);
            }
        }
        this.addConfig("listeners", this.listeners);
        String bindTarget = cc.getBindTarget();
        if (!bindTarget.equals("")) {
            bindTarget = TextParser.parse(bindTarget, model);
            map.put("bindtarget", bindTarget);
            this.bsb.append("$('" + this.id + "').bind('" + bindTarget + "','" + name + "');\n");
            map.put(BINDING, this.bsb.toString());
        }
    }

    protected void addJavaScript(BuildSession session, ViewContext context, String javascript) {
        if (!session.includeResource(javascript)) {
            HtmlPageContext page = HtmlPageContext.getInstance(context);
            String js = session.getResourceUrl(javascript);
            page.addScript(js);
        }
    }

    protected void addStyleSheet(BuildSession session, ViewContext context, String style) {
        if (!session.includeResource(style)) {
            HtmlPageContext page = HtmlPageContext.getInstance(context);
            String styleSheet = session.getResourceUrl(style);
            page.addStyleSheet(styleSheet);
        }
    }

    protected void addEvent(String id, String eventName, String handler) {
        try {
            this.listeners.put(eventName, new JSONFunction(handler));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    protected void addConfig(String key, Object value) {
        try {
            this.config.put(key, value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getConfigString() {
        return this.config.toString();
    }

    protected JSONObject getConfig() {
        return this.config;
    }

    protected String getFieldPrompt(BuildSession session, CompositeMap field, String dataset) {
        String label = field.getString("prompt", "");
        if ("".equals(label)) {
            CompositeMap fieldcm;
            String name = field.getString("name", "");
            CompositeMap ds = this.getDataSet(session, dataset);
            if (ds != null && (fieldcm = ds.getChild("fields")) != null) {
                List fields = fieldcm.getChilds();
                for (CompositeMap fieldMap : fields) {
                    String fn = fieldMap.getString("name", "");
                    if (!name.equals(fn)) continue;
                    label = fieldMap.getString("prompt", "");
                    break;
                }
            }
        }
        return label;
    }

    private CompositeMap getDataSet(BuildSession session, String dataSetName) {
        CompositeMap dataset = null;
        ServiceInstance svc = (ServiceInstance)session.getInstanceOfType(IService.class);
        ScreenConfig screen = ScreenConfig.createScreenConfig(svc.getServiceConfigData());
        CompositeMap datasets = screen.getDataSetsConfig();
        if (datasets != null) {
            List list = datasets.getChilds();
            for (CompositeMap ds : list) {
                String dsname = ds.getString("id", "");
                if (!dataSetName.equals(dsname)) continue;
                dataset = ds;
                break;
            }
        }
        return dataset;
    }

    public boolean isHidden(CompositeMap view, CompositeMap model) {
        CompositeMap cd = model.getParent().getChild("_customization_data");
        if (cd != null) {
            List list = cd.getChilds();
            Iterator it = list.iterator();
            String fid = view.getString("id", "");
            while (it.hasNext()) {
                CompositeMap record = (CompositeMap)it.next();
                String id = record.getString("id_value");
                String mt = record.getString("mod_type");
                String ak = record.getString("attrib_key");
                String av = record.getString("attrib_value");
                String an = record.getString("array_name");
                String idf = record.getString("index_field");
                String idv = record.getString("index_value");
                if (!"set_attrib".equals(mt) || !id.equals(fid) || !"hidden".equals(ak) || !"true".equals(av) || an != null || idf != null || idv != null) continue;
                return true;
            }
        }
        return false;
    }

    public int getChildLength(CompositeMap view, CompositeMap model) {
        int count = 0;
        Iterator it = view.getChildIterator();
        while (it.hasNext()) {
            CompositeMap field = (CompositeMap)it.next();
            if (this.isHidden(field, model)) continue;
            ++count;
        }
        return count;
    }
}

