/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation;

import aurora.presentation.BuildSession;
import aurora.presentation.IViewBuilder;
import aurora.presentation.ViewComponent;
import aurora.presentation.ViewComponentPackage;
import aurora.presentation.ViewContext;
import aurora.presentation.ViewCreationException;
import java.io.IOException;
import uncertain.cache.CacheFactoryConfig;
import uncertain.cache.ICache;
import uncertain.composite.CompositeMap;
import uncertain.core.UncertainEngine;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.ISingleton;
import uncertain.util.template.TextTemplate;

public class TemplateBasedView
implements IViewBuilder,
ISingleton {
    public static final String CACHE_NAME = "ViewComponentTemplates";
    public static final String TEMPLATE_EXT = ".tplt";
    public static final String KEY_TEMPLATE = "template";
    static final String[] TEMPLATE_BASED_SEQUENCE = new String[]{"LoadTemplate", "CreateViewContent"};
    ICache mCache;
    boolean mIsCacheEnabled = false;
    String mCacheName;

    public TemplateBasedView(UncertainEngine engine) {
        this.initCache(engine);
    }

    private void initCache(UncertainEngine engine) {
        IObjectRegistry reg = engine.getObjectRegistry();
        this.mCache = CacheFactoryConfig.getNamedCache(reg, CACHE_NAME);
        this.mIsCacheEnabled = this.mCache != null;
    }

    private TextTemplate getTemplate(String name, BuildSession session) throws IOException {
        if (!this.mIsCacheEnabled || this.mCache == null) {
            return session.getTemplateByName(name);
        }
        String pkg_name = session.getCurrentPackage() == null ? "" : session.getCurrentPackage().getName();
        String theme_name = session.getTheme();
        String key_name = String.valueOf(pkg_name) + "." + name + "." + theme_name;
        TextTemplate tplt = (TextTemplate)this.mCache.getValue(key_name);
        if (tplt == null) {
            tplt = session.getTemplateByName(name);
            this.mCache.setValue(key_name, tplt);
        }
        return tplt;
    }

    @Override
    public void buildView(BuildSession session, ViewContext view_context) throws IOException, ViewCreationException {
        TextTemplate template = view_context.getTemplate();
        if (template == null) {
            String template_name;
            ViewComponentPackage pkg = session.getCurrentPackage();
            ViewComponent cpnt = pkg.getComponent(view_context.getView());
            String string = template_name = cpnt == null ? null : cpnt.getDefaultTemplate();
            if (template_name == null) {
                template_name = String.valueOf(view_context.getView().getName()) + TEMPLATE_EXT;
            }
            template = this.getTemplate(template_name, session);
        }
        if (template == null) {
            CompositeMap view = view_context.getView();
            throw new ViewCreationException("No template defined during view content creation process:" + view == null ? "" : view.toXML());
        }
        template.createOutput(session.getWriter(), view_context.getContextMap());
    }

    @Override
    public String[] getBuildSteps(ViewContext context) {
        return TEMPLATE_BASED_SEQUENCE;
    }
}

