/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.api.statistics.map;

import aurora.ide.api.statistics.map.ObjectStatisticsResult;
import aurora.ide.api.statistics.model.ProjectObject;
import aurora.ide.api.statistics.model.StatisticsProject;
import java.util.ArrayList;
import java.util.List;

public class StatisticsResult {
    private StatisticsProject project;
    private List<ProjectObject> bms = new ArrayList<ProjectObject>();
    private List<ProjectObject> screens = new ArrayList<ProjectObject>();

    public StatisticsProject getProject() {
        return this.project;
    }

    public void setProject(StatisticsProject project) {
        this.project = project;
    }

    public List<ProjectObject> getBms() {
        return this.bms;
    }

    public void setBms(List<ProjectObject> bms) {
        this.bms = bms;
    }

    public void addBm(ProjectObject bm) {
        this.bms.add(bm);
    }

    public void addScreen(ProjectObject screen) {
        this.screens.add(screen);
    }

    public List<ProjectObject> getScreens() {
        return this.screens;
    }

    public void setScreens(List<ProjectObject> screens) {
        this.screens = screens;
    }

    public void addProjectObject(ProjectObject po) {
        if ("bm".equals(po.getType())) {
            this.addBm(po);
        } else {
            this.addScreen(po);
        }
    }

    public List<ProjectObject> getProjectObjects() {
        ArrayList<ProjectObject> list = new ArrayList<ProjectObject>();
        list.addAll(this.screens);
        list.addAll(this.bms);
        return list;
    }

    public ObjectStatisticsResult getBMStatisticsResult() {
        if (this.bms == null) {
            return null;
        }
        return new ObjectStatisticsResult(this.project, this.bms, "bm");
    }

    public ObjectStatisticsResult getSVCStatisticsResult() {
        ArrayList<ProjectObject> result = new ArrayList<ProjectObject>();
        if (this.screens == null) {
            return null;
        }
        for (ProjectObject po : this.screens) {
            if (!"svc".equals(po.getType())) continue;
            result.add(po);
        }
        return new ObjectStatisticsResult(this.project, result, "svc");
    }

    public ObjectStatisticsResult getSreenStatisticsResult() {
        if (this.screens == null) {
            return null;
        }
        ArrayList<ProjectObject> result = new ArrayList<ProjectObject>();
        for (ProjectObject po : this.screens) {
            if (!"screen".equals(po.getType())) continue;
            result.add(po);
        }
        return new ObjectStatisticsResult(this.project, result, "screen");
    }
}

