/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.api.statistics.cvs;

import aurora.ide.api.statistics.Status;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class CVSTag {
    public static final int HEAD = 0;
    public static final int BRANCH = 1;
    public static final int VERSION = 2;
    public static final int DATE = 3;
    public static final CVSTag DEFAULT = new CVSTag();
    public static final CVSTag BASE = new CVSTag("BASE", 2);
    public static final String VENDOR_REVISION = "1.1.1";
    public static final String HEAD_REVISION = "1";
    public static final String UNKNOWN_BRANCH = "<n/a>";
    public static final String HEAD_BRANCH = "HEAD";
    protected String name;
    protected String branchRevision;
    protected int type;
    private static final String DATE_TAG_NAME_FORMAT = "dd MMM yyyy HH:mm:ss Z";
    private static final SimpleDateFormat tagNameFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss Z", Locale.US);

    protected static synchronized String dateToTagName(Date date) {
        tagNameFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return tagNameFormat.format(date);
    }

    protected static synchronized Date tagNameToDate(String name) {
        if (name == null) {
            return null;
        }
        try {
            return tagNameFormat.parse(name);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public CVSTag() {
        this(HEAD_BRANCH, HEAD_REVISION, 0);
    }

    public CVSTag(String name, int type) {
        this.name = name;
        this.type = type;
        this.branchRevision = null;
    }

    public CVSTag(String name, String branchRevision, int type) {
        this.name = name;
        this.branchRevision = branchRevision;
        this.type = type;
    }

    public CVSTag(Date date) {
        this(CVSTag.dateToTagName(date), 3);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CVSTag)) {
            return false;
        }
        CVSTag tag = (CVSTag)other;
        if (this.getType() != tag.getType()) {
            return false;
        }
        return this.getName().equals(tag.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getBranchRevision() {
        return this.branchRevision;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public int compareTo(CVSTag other) {
        if (this.getType() == 3 && other.getType() == 3) {
            Date date1 = this.asDate();
            Date date2 = other.asDate();
            if (date1 == null || date2 == null) {
                return -1;
            }
            return date1.compareTo(date2);
        }
        return this.getName().compareToIgnoreCase(other.getName());
    }

    public static boolean equalTags(CVSTag tag1, CVSTag tag2) {
        if (tag1 == null) {
            tag1 = DEFAULT;
        }
        if (tag2 == null) {
            tag2 = DEFAULT;
        }
        return tag1.equals(tag2);
    }

    public static Status validateTagName(String tagName) {
        if (tagName == null) {
            return null;
        }
        if (tagName.equals("")) {
            return null;
        }
        if (!Character.isLetter(tagName.charAt(0))) {
            return null;
        }
        int i = 0;
        while (i < tagName.length()) {
            char c = tagName.charAt(i);
            if (Character.isSpaceChar(c) || c == '$' || c == ',' || c == '.' || c == ':' || c == ';' || c == '@' || c == '|') {
                return null;
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public Date asDate() {
        return CVSTag.tagNameToDate(this.name);
    }

    public boolean isHeadTag() {
        return this.getType() == 0 || this.getType() == 2 && this.getName().equals(HEAD_BRANCH);
    }

    public boolean isBaseTag() {
        return this.getName().equals("BASE");
    }

    public static String getTagLabel(CVSTag tag) {
        if (tag == null) {
            return HEAD_BRANCH;
        }
        switch (tag.getType()) {
            case 0: {
                return tag.getName();
            }
            case 2: {
                return String.valueOf(tag.getName()) + " (Version)";
            }
            case 1: {
                return String.valueOf(tag.getName()) + " (Branch)";
            }
            case 3: {
                return String.valueOf(tag.getName()) + " (Date)";
            }
        }
        return tag.getName();
    }
}

