/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.profile;

import aurora.database.profile.DatabaseFactory;
import aurora.database.profile.IDatabaseFactory;
import aurora.database.profile.IDatabaseProfile;
import aurora.database.profile.ISqlBuilder;
import aurora.database.profile.ISqlBuilderRegistry;
import aurora.database.profile.SqlBuilderMapping;
import aurora.database.profile.SqlBuilderRegistry;
import aurora.database.profile.StatementMapping;
import java.util.Properties;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectCreator;

public class DatabaseProfile
implements IDatabaseProfile {
    String mDatabaseName;
    CompositeMap mProperties = new CompositeMap("properties");
    CompositeMap mKeywords = new CompositeMap("keywords");
    SqlBuilderRegistry mSqlBuilderRegistry = new SqlBuilderRegistry(this);
    IObjectCreator mObjectCreator;
    IDatabaseFactory owner;

    public static boolean getBooleanValue(IDatabaseProfile profile, String key, boolean default_value) {
        Object obj = profile.getProperty(key);
        if (obj == null) {
            return default_value;
        }
        String str = obj.toString();
        return str != null && str.equalsIgnoreCase("true");
    }

    public static boolean isUseJoinKeyword(IDatabaseProfile profile) {
        return DatabaseProfile.getBooleanValue(profile, "use_join_keyword", true);
    }

    public DatabaseProfile() {
    }

    public DatabaseProfile(IObjectCreator creator) {
        this();
        this.mObjectCreator = creator;
    }

    public DatabaseProfile(String name) {
        this();
        this.mDatabaseName = name;
    }

    public DatabaseProfile(String name, Properties props) {
        this(name);
        this.mProperties.putAll(props);
    }

    @Override
    public String getDatabaseName() {
        return this.mDatabaseName;
    }

    public void setDatabaseName(String name) {
        this.mDatabaseName = name;
    }

    @Override
    public String getKeyword(String keyword_code) {
        String keyword = this.mKeywords.getString(keyword_code);
        if (keyword != null) {
            return keyword;
        }
        return keyword_code;
    }

    @Override
    public Object getProperty(String name) {
        Object value = this.mProperties.get(name);
        return value == null ? null : value.toString();
    }

    @Override
    public void setProperty(String name, Object value) {
        this.mProperties.put(name, value);
    }

    public IObjectCreator getObjectCreator() {
        return this.mObjectCreator;
    }

    public void setObjectCreator(IObjectCreator objectCreator) {
        this.mObjectCreator = objectCreator;
    }

    protected ISqlBuilder createInstance(Class type) throws Exception {
        if (this.mObjectCreator == null) {
            return (ISqlBuilder)type.newInstance();
        }
        return (ISqlBuilder)this.mObjectCreator.createInstance(type);
    }

    public void addSqlBuilderMapping(SqlBuilderMapping mapping) {
        StatementMapping[] marray;
        Class builder_type = mapping.getSqlBuilder();
        if (builder_type == null) {
            throw new IllegalArgumentException("Must set sqlBuilder property in SqlBuilderMapping");
        }
        ISqlBuilder builder = this.mSqlBuilderRegistry.getSqlBuilderByType(builder_type);
        if (builder == null) {
            try {
                builder = this.createInstance(builder_type);
            }
            catch (Exception ex) {
                throw new RuntimeException("Error when create ISqlBuilder instance for type " + builder_type.getName(), ex);
            }
        }
        if ((marray = mapping.getMappings()) != null) {
            int i = 0;
            while (i < marray.length) {
                this.mSqlBuilderRegistry.registerSqlBuilder(marray[i].getStatementClass(), builder);
                ++i;
            }
        }
    }

    @Override
    public ISqlBuilderRegistry getSqlBuilderRegistry() {
        return this.mSqlBuilderRegistry;
    }

    public void addProperties(CompositeMap props) {
        this.mProperties.putAll(props);
    }

    public void addKeywords(CompositeMap words) {
        this.mKeywords.putAll(words);
    }

    @Override
    public CompositeMap getProperties() {
        return this.mProperties;
    }

    @Override
    public IDatabaseFactory getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(IDatabaseFactory owner) {
        ISqlBuilderRegistry default_reg;
        this.owner = owner;
        if (owner instanceof DatabaseFactory && (default_reg = ((DatabaseFactory)owner).getDefaultSqlBuilderRegistry()) != null) {
            this.mSqlBuilderRegistry.setParent(default_reg);
        }
    }
}

