/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.features;

import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.database.profile.IDatabaseFactory;
import aurora.database.profile.IDatabaseProfile;
import java.sql.Date;

public class StandardWho {
    public static final String KEY_STANDARD_WHO_ADDED = "_standard_who_added";
    String userIdPath = "/session/@user_id";
    String createdByField = "CREATED_BY";
    String creationDateField = "CREATION_DATE";
    String lastUpdatedByField = "LAST_UPDATED_BY";
    boolean forQuery = false;
    String lastUpdatedDateField = "LAST_UPDATED_DATE";
    public static Field CREATED_BY = Field.createField("CREATED_BY");
    public static Field CREATION_DATE = Field.createField("CREATION_DATE");
    public static Field LAST_UPDATED_BY = Field.createField("LAST_UPDATED_BY");
    public static Field LAST_UPDATED_DATE = Field.createField("LAST_UPDATED_DATE");
    IDatabaseFactory mFactory;

    static {
        CREATED_BY.setDataType(Long.class.getName());
        CREATED_BY.setForUpdate(false);
        CREATED_BY.setForInsert(true);
        CREATED_BY.setForSelect(false);
        CREATION_DATE.setDataType(Date.class.getName());
        CREATION_DATE.setForUpdate(false);
        CREATION_DATE.setForInsert(true);
        CREATION_DATE.setForSelect(false);
        LAST_UPDATED_BY.setDataType(Long.class.getName());
        LAST_UPDATED_BY.setForUpdate(true);
        LAST_UPDATED_BY.setForInsert(true);
        LAST_UPDATED_BY.setForSelect(false);
        LAST_UPDATED_BY.setForceUpdate(true);
        LAST_UPDATED_DATE.setDataType(Date.class.getName());
        LAST_UPDATED_DATE.setForUpdate(true);
        LAST_UPDATED_DATE.setForInsert(true);
        LAST_UPDATED_DATE.setForSelect(false);
        LAST_UPDATED_DATE.setForceUpdate(true);
    }

    public boolean getForQuery() {
        return this.forQuery;
    }

    public void setForQuery(boolean forQuery) {
        this.forQuery = forQuery;
    }

    public String getCreatedByField() {
        return this.createdByField;
    }

    public void setCreatedByField(String createdByField) {
        this.createdByField = createdByField;
    }

    public String getCreationDateField() {
        return this.creationDateField;
    }

    public void setCreationDateField(String creationDateField) {
        this.creationDateField = creationDateField;
    }

    public String getLastUpdatedByField() {
        return this.lastUpdatedByField;
    }

    public void setLastUpdatedByField(String lastUpdatedByField) {
        this.lastUpdatedByField = lastUpdatedByField;
    }

    public String getLastUpdatedDateField() {
        return this.lastUpdatedDateField;
    }

    public void setLastUpdatedDateField(String lastUpdatedDateField) {
        this.lastUpdatedDateField = lastUpdatedDateField;
    }

    String getGlobalOption(String key, String default_value) {
        String value = (String)this.mFactory.getProperty(key);
        return value == null ? default_value : value;
    }

    public StandardWho(IDatabaseFactory fact) {
        this.mFactory = fact;
        this.userIdPath = this.getGlobalOption("user_id_path", this.userIdPath);
        this.createdByField = this.getGlobalOption("created_by_field", this.createdByField);
        this.creationDateField = this.getGlobalOption("creation_date_field", this.creationDateField);
        this.lastUpdatedByField = this.getGlobalOption("last_updated_by_field", this.lastUpdatedByField);
        this.lastUpdatedDateField = this.getGlobalOption("last_updated_date_field", this.lastUpdatedDateField);
    }

    public void onPrepareBusinessModel(BusinessModel model) {
        Boolean standard_who_added;
        boolean forSelect = false;
        if (this.getForQuery()) {
            forSelect = true;
        }
        if ((standard_who_added = model.getObjectContext().getBoolean(KEY_STANDARD_WHO_ADDED)) != null) {
            return;
        }
        IDatabaseProfile profile = model.getDatabaseProfile(this.mFactory);
        String sysdate = profile.getKeyword("current_time");
        Field created_by = CREATED_BY.createCopy();
        created_by.setForSelect(forSelect);
        created_by.setParameterPath(this.userIdPath);
        created_by.setName(this.createdByField);
        model.addField(created_by);
        Field creation_date = CREATION_DATE.createCopy();
        creation_date.setForSelect(forSelect);
        creation_date.setInsertExpression(sysdate);
        creation_date.setName(this.creationDateField);
        model.addField(creation_date);
        Field last_updated_by = LAST_UPDATED_BY.createCopy();
        last_updated_by.setForSelect(forSelect);
        last_updated_by.setParameterPath(this.userIdPath);
        last_updated_by.setName(this.lastUpdatedByField);
        model.addField(last_updated_by);
        Field last_updated_date = LAST_UPDATED_DATE.createCopy();
        last_updated_date.setForSelect(forSelect);
        last_updated_date.setInsertExpression(sysdate);
        last_updated_date.setUpdateExpression(sysdate);
        last_updated_date.setName(this.lastUpdatedDateField);
        model.addField(last_updated_date);
        model.makeReady();
        model.getObjectContext().putBoolean(KEY_STANDARD_WHO_ADDED, true);
    }
}

