/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.features;

import aurora.application.features.DefaultLookupCodeProvider;
import aurora.application.features.ILookupCodeProvider;
import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.database.profile.IDatabaseFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;

public class LookUpField {
    private IDatabaseFactory factory;
    private IObjectRegistry mRegistry;

    public LookUpField(IDatabaseFactory factory, IObjectRegistry registry) {
        this.factory = factory;
        this.mRegistry = registry;
    }

    public void onPrepareBusinessModel(BusinessModel model) {
        ILookupCodeProvider lookupProvider = (ILookupCodeProvider)this.mRegistry.getInstanceOfType(ILookupCodeProvider.class);
        if (lookupProvider == null) {
            return;
        }
        if (lookupProvider instanceof DefaultLookupCodeProvider) {
            DefaultLookupCodeProvider defaultLookupProvider = (DefaultLookupCodeProvider)lookupProvider;
            String sqlTemplate = defaultLookupProvider.getLookupSql();
            Field[] fields = model.getFields();
            ArrayList<Field> lookupfields = new ArrayList<Field>();
            if (fields != null) {
                String lookupfiled;
                int len = fields.length;
                int i = 0;
                while (i < len) {
                    Field field = fields[i];
                    lookupfiled = field.getLookUpField();
                    String lookupcode = field.getLookUpCode();
                    if (lookupfiled != null && lookupcode != null) {
                        lookupfields.add(field);
                    }
                    ++i;
                }
                for (Field field : lookupfields) {
                    lookupfiled = field.getLookUpField();
                    String name = field.getName();
                    String lookupcode = field.getLookUpCode();
                    String alias = model.getAlias();
                    String value = alias != null ? String.valueOf(alias) + "." + name : name;
                    boolean h = false;
                    if (lookupfiled == null || lookupcode == null) continue;
                    int i2 = 0;
                    while (i2 < len) {
                        Field f = fields[i2];
                        if (lookupfiled.equals(f.getName())) {
                            h = true;
                            String express = f.getExpression();
                            if (express != null) break;
                            f.setExpression(this.createExpression(sqlTemplate, lookupcode, value));
                            break;
                        }
                        ++i2;
                    }
                    if (h) continue;
                    Field lfield = Field.createField(field.getLookUpField());
                    lfield.setPrompt(field.getPrompt());
                    lfield.setRequired(field.getRequired());
                    lfield.setForInsert(false);
                    lfield.setForUpdate(false);
                    lfield.setExpression(this.createExpression(sqlTemplate, lookupcode, value));
                    model.addField(lfield);
                }
            }
        }
        model.makeReady();
    }

    private String createExpression(String sqlTemplate, String code, String name) {
        String sql = null;
        String langPath = "ZHS";
        CompositeMap properties = this.factory.getProperties();
        if (properties != null) {
            langPath = "${" + properties.getString("language_path") + "}";
            if (sqlTemplate != null) {
                MessageFormat mf = new MessageFormat(sqlTemplate);
                sql = mf.format(new Object[]{code, name, langPath});
            }
        }
        return sql != null ? sql : "(select code_value_name from sys_code_vl where code = '" + code + "' and code_value=to_char(" + name + ") and language=" + langPath + ")";
    }
}

