/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import aurora.bm.BusinessModel;
import aurora.bm.ModelFactory;
import aurora.bm.Relation;
import aurora.service.validation.IParameter;
import java.io.IOException;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.ProgrammingException;

public class Field
extends DynamicObject
implements IParameter {
    public static final String KEY_IS_CACHE_JOIN_FIELD = "_iscachejoinfield";
    public static final String KEY_RELATION_NAME = "relationname";
    public static final String KEY_SOURCE_MODEL = "sourcemodel";
    public static final String KEY_SOURCE_FIELD = "sourcefield";
    public static final String KEY_EXPRESSION = "expression";
    public static final String KEY_NAME = "name";
    public static final String KEY_PARAMETER_PATH = "parameterpath";
    public static final String KEY_DATA_TYPE = "datatype";
    public static final String KEY_DATABASE_TYPE = "databasetype";
    public static final String KEY_PHYSICAL_NAME = "physicalname";
    public static final String KEY_UPDATE_EXPRESSION = "updateexpression";
    public static final String KEY_INSERT_EXPRESSION = "insertexpression";
    public static final String KEY_QUERY_EXPRESSION = "queryexpression";
    public static final String KEY_IS_PRIMARYKEY = "isprimarykey";
    public static final String KEY_REQUIRED = "required";
    public static final String KEY_DEFAULT_VALUE = "defaultvalue";
    public static final String KEY_FOR_SELECT = "forselect";
    public static final String KEY_FOR_QUERY = "forquery";
    public static final String KEY_FOR_INSERT = "forinsert";
    public static final String KEY_FOR_UPDATE = "forupdate";
    public static final String KEY_FORCE_UPDATE = "forceupdate";
    public static final String KEY_FOR_DISPLAY = "fordisplay";
    public static final String REF_FIELD = "ref-field";
    public static final String KEY_PROMPT = "prompt";
    public static final String KEY_QUERY_WIDTH = "querywidth";
    public static final String KEY_DISPLAY_WIDTH = "displaywidth";
    public static final String KEY_DISPLAY_ALIGN = "displayalign";
    public static final String KEY_EDITOR_TYPE = "editortype";
    public static final String KEY_OPTIONS = "options";
    public static final String KEY_LOOKUP_FIELD = "lookupfield";
    public static final String KEY_LOOKUP_CODE = "lookupcode";
    public static final String KEY_IS_AUTO_GENERATED_KEY = "isautogeneratedkey";
    BusinessModel owner;
    public static final String KEY_MULTI_LANGUAGE = "multilanguage";
    public static final String KEY_MULTI_LANGUAGE_DESC_FIELD = "multilanguagedescfield";

    public void setMultiLanguage(boolean multiLanguage) {
        this.putBoolean(KEY_MULTI_LANGUAGE, multiLanguage);
    }

    public boolean getMultiLanguage() {
        return this.getBoolean(KEY_MULTI_LANGUAGE, false);
    }

    public void setMultiLanguageDescField(String multiLanguageDescField) {
        this.putString(KEY_MULTI_LANGUAGE_DESC_FIELD, multiLanguageDescField);
    }

    public String getMultiLanguageDescField() {
        return this.getString(KEY_MULTI_LANGUAGE_DESC_FIELD);
    }

    public static Field getInstance(CompositeMap context) {
        Field field = new Field();
        field.initialize(context);
        return field;
    }

    public static Field createField(String name) {
        CompositeMap m = new CompositeMap();
        m.setName("field");
        m.setNameSpaceURI("http://www.aurora-framework.org/schema/bm");
        Field field = new Field();
        field.initialize(m);
        field.setName(name);
        return field;
    }

    public static String defaultParamExpression(String name) {
        return "${" + name + "}";
    }

    @Override
    public String getName() {
        return this.getString(KEY_NAME);
    }

    public void setName(String name) {
        this.putString(KEY_NAME, name);
    }

    @Override
    public String getInputPath() {
        String path = this.getString(KEY_PARAMETER_PATH);
        if (path != null) {
            return path;
        }
        return this.getString(KEY_PARAMETER_PATH, "@" + this.getName());
    }

    public void setParameterPath(String path) {
        this.putString(KEY_PARAMETER_PATH, path);
    }

    public String getParameterPath() {
        return this.getString(KEY_PARAMETER_PATH, "@" + this.getName());
    }

    public String getPrompt() {
        return this.getString(KEY_PROMPT);
    }

    public void setPrompt(String prompt) {
        this.putString(KEY_PROMPT, prompt);
    }

    @Override
    public String getDataType() {
        return this.getString(KEY_DATA_TYPE);
    }

    public void setDataType(String data_type) {
        this.putString(KEY_DATA_TYPE, data_type);
    }

    public String getDatabaseType() {
        return this.getString(KEY_DATABASE_TYPE);
    }

    public void setDatabaseType(String database_type) {
        this.putString(KEY_DATABASE_TYPE, database_type);
    }

    public String getPhysicalName() {
        String name = this.getString(KEY_PHYSICAL_NAME);
        if (name == null) {
            name = this.getName();
        }
        return name;
    }

    public void setPhysicalName(String name) {
        this.putString(KEY_PHYSICAL_NAME, name);
    }

    public boolean isReferenceField() {
        return REF_FIELD.equals(this.getObjectContext().getName());
    }

    public boolean isExpression() {
        return this.getObjectContext().containsKey(KEY_EXPRESSION);
    }

    public String getExpression() {
        return this.getString(KEY_EXPRESSION);
    }

    public void setExpression(String exp) {
        this.putString(KEY_EXPRESSION, exp);
    }

    public String getSourceField() {
        return this.getString(KEY_SOURCE_FIELD);
    }

    public void setSourceField(String field) {
        this.putString(KEY_SOURCE_FIELD, field);
    }

    public String getSourceModel() {
        return this.getString(KEY_SOURCE_MODEL);
    }

    public void setSourceModel(String model_name) {
        this.putString(KEY_SOURCE_MODEL, model_name);
    }

    public String getRelationName() {
        return this.getString(KEY_RELATION_NAME);
    }

    public String getUpdateExpression() {
        String exp = this.getString(KEY_UPDATE_EXPRESSION);
        if (exp == null) {
            exp = Field.defaultParamExpression(this.getInputPath());
        }
        return exp;
    }

    public void setUpdateExpression(String source) {
        this.putString(KEY_UPDATE_EXPRESSION, source);
    }

    public String getInsertExpression() {
        String exp = this.getString(KEY_INSERT_EXPRESSION);
        if (exp == null) {
            exp = Field.defaultParamExpression(this.getInputPath());
        }
        return exp;
    }

    public void setInsertExpression(String source) {
        this.putString(KEY_INSERT_EXPRESSION, source);
    }

    public String getQueryExpression() {
        return this.getString(KEY_QUERY_EXPRESSION);
    }

    public void setQueryExpression(String source) {
        this.putString(KEY_QUERY_EXPRESSION, source);
    }

    public void setRelationName(String name) {
        this.putString(KEY_RELATION_NAME, name);
    }

    public boolean isPrimaryKey() {
        return this.getBoolean(KEY_IS_PRIMARYKEY, false);
    }

    public void setPrimaryKey(boolean is_pk) {
        this.putBoolean(KEY_IS_PRIMARYKEY, is_pk);
    }

    public int getQueryWidth() {
        return this.getInt(KEY_QUERY_WIDTH, 150);
    }

    public void setQueryWidth(int width) {
        this.putInt(KEY_QUERY_WIDTH, width);
    }

    public int getDisplayWidth() {
        return this.getInt(KEY_DISPLAY_WIDTH, 150);
    }

    public void setDisplayWidth(int width) {
        this.putInt(KEY_DISPLAY_WIDTH, width);
    }

    public String getDisplayAlign() {
        return this.getString(KEY_DISPLAY_ALIGN, "left");
    }

    public void setDisplayAlign(String align) {
        this.putString(KEY_DISPLAY_ALIGN, align);
    }

    public String getOptions() {
        return this.getString(KEY_OPTIONS, "");
    }

    public void setOptions(String options) {
        this.putString(KEY_OPTIONS, options);
    }

    public String getEditorType() {
        return this.getString(KEY_EDITOR_TYPE, "");
    }

    public void setEditorType(String editorType) {
        this.putString(KEY_EDITOR_TYPE, editorType);
    }

    public boolean isDateType() {
        String type = this.getDataType();
        return "date".equals(type) || "java.util.Date".equals(type) || "java.sql.Date".equals(type);
    }

    public boolean isForInsert() {
        if (this.isReferenceField()) {
            return false;
        }
        return this.getBoolean(KEY_FOR_INSERT, true);
    }

    public boolean isForUpdate() {
        Boolean b = this.getBoolean(KEY_FOR_UPDATE);
        if (b == null) {
            return !this.isPrimaryKey() && !this.isExpression() && !this.isReferenceField();
        }
        return b;
    }

    public boolean isForQuery() {
        Boolean b = this.getBoolean(KEY_FOR_QUERY);
        if (b == null) {
            return false;
        }
        return b;
    }

    public boolean isForDisplay() {
        Boolean b = this.getBoolean(KEY_FOR_DISPLAY);
        if (b == null) {
            return false;
        }
        return b;
    }

    public void setForDisplay(boolean b) {
        this.putBoolean(KEY_FOR_DISPLAY, b);
    }

    public boolean isForSelect() {
        Boolean b = this.getBoolean(KEY_FOR_SELECT);
        if (b == null) {
            return true;
        }
        return b;
    }

    public boolean isForOperation(String operation) {
        return this.isForOperation(operation, false);
    }

    public boolean isForOperation(String operation, boolean default_value) {
        if (operation == null) {
            throw new IllegalArgumentException("operation name is null");
        }
        String key = "for" + operation.toLowerCase();
        Boolean b = this.getBoolean(key);
        return b == null ? default_value : b;
    }

    public boolean getRequired() {
        return this.getBoolean(KEY_REQUIRED, false);
    }

    public void setRequired(boolean required) {
        this.putBoolean(KEY_REQUIRED, required);
    }

    @Override
    public boolean isRequired() {
        return this.getRequired();
    }

    @Override
    public Object getDefaultValue() {
        return this.get(KEY_DEFAULT_VALUE);
    }

    public void setDefaultValue(Object value) {
        this.put(KEY_DEFAULT_VALUE, value);
    }

    public void setLookUpField(String field) {
        this.putString(KEY_LOOKUP_FIELD, field);
    }

    public String getLookUpField() {
        return this.getString(KEY_LOOKUP_FIELD);
    }

    public void setLookUpCode(String code) {
        this.putString(KEY_LOOKUP_CODE, code);
    }

    public String getLookUpCode() {
        return this.getString(KEY_LOOKUP_CODE);
    }

    public String getReferredModelName() {
        if (!this.isReferenceField()) {
            throw new ProgrammingException("this field is not a reference field");
        }
        if (this.owner == null) {
            throw new ProgrammingException("BusinessModel that owns this field is not set");
        }
        String model = this.getSourceModel();
        if (model == null) {
            String name = this.getRelationName();
            if (name == null) {
                throw BuiltinExceptionFactory.createOneAttributeMissing(this.object_context.asLocatable(), "sourceModel,relationName");
            }
            Relation r = this.owner.getRelation(name);
            if (r == null) {
                throw BuiltinExceptionFactory.createUnknownNodeWithName(this.object_context.asLocatable(), "relation", KEY_NAME, name);
            }
            model = r.getReferenceModel();
            if (model == null) {
                throw BuiltinExceptionFactory.createAttributeMissing(r.getObjectContext().asLocatable(), "referenceModel");
            }
        }
        return model;
    }

    public BusinessModel getRefferedModel() {
        ModelFactory factory = this.owner.getModelFactory();
        if (factory == null) {
            throw new ProgrammingException("ModelFactory instance is not set for BusinessModel");
        }
        String name = this.getReferredModelName();
        try {
            return factory.getModelForRead(name);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't load BusinessModel " + name, ex);
        }
    }

    public Field getReferredField() {
        String sf = this.getSourceField();
        if (sf == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this.object_context.asLocatable(), "sourceField");
        }
        BusinessModel model = this.getRefferedModel();
        Field f = model.getField(sf);
        if (f == null) {
            throw BuiltinExceptionFactory.createUnknownNodeWithName(this.object_context.asLocatable(), "field", KEY_NAME, sf);
        }
        return f;
    }

    public BusinessModel getOwner() {
        return this.owner;
    }

    public void setOwner(BusinessModel owner) {
        this.owner = owner;
    }

    public void setForSelect(boolean b) {
        this.putBoolean(KEY_FOR_SELECT, b);
    }

    public void setForInsert(boolean b) {
        this.putBoolean(KEY_FOR_INSERT, b);
    }

    public void setForUpdate(boolean b) {
        this.putBoolean(KEY_FOR_UPDATE, b);
    }

    public void setForQuery(boolean b) {
        this.putBoolean(KEY_FOR_QUERY, b);
    }

    public Field createCopy() {
        CompositeMap m = (CompositeMap)this.object_context.clone();
        return Field.getInstance(m);
    }

    public boolean isForceUpdate() {
        return this.getBoolean(KEY_FORCE_UPDATE, false);
    }

    public void setForceUpdate(boolean b) {
        this.putBoolean(KEY_FORCE_UPDATE, b);
    }

    @Override
    public void checkValidation() {
        if (this.isReferenceField()) {
            this.getReferredModelName();
            this.getReferredField();
        }
    }

    public boolean isCacheJoinField() {
        return this.getBoolean(KEY_IS_CACHE_JOIN_FIELD, false);
    }

    public void setCacheJoinField(boolean b) {
        this.putBoolean(KEY_IS_CACHE_JOIN_FIELD, b);
    }

    public boolean isAutoGeneratedKey() {
        return this.getBoolean(KEY_IS_AUTO_GENERATED_KEY, false);
    }

    public void setIsAutoGeneratedKey(boolean b) {
        this.putBoolean(KEY_IS_AUTO_GENERATED_KEY, b);
    }
}

