/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.cstm.bm;

import aurora.application.features.cstm.bm.IBMCustomizationDataProvider;
import aurora.application.features.cstm.bm.LovBMCustomSourceCode;
import aurora.bm.BusinessModel;
import aurora.database.DBUtil;
import aurora.database.FetchDescriptor;
import aurora.database.ParsedSql;
import aurora.database.ResultSetLoader;
import aurora.database.SqlRunner;
import aurora.database.rsconsumer.CompositeMapCreator;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import aurora.events.E_PrepareBusinessModel;
import aurora.service.ServiceInstance;
import aurora.service.ServiceThreadLocal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.logging.Level;
import javax.sql.DataSource;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.ILifeCycle;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;

public class BMCustomizationProvider
extends AbstractLocatableObject
implements E_PrepareBusinessModel,
ILifeCycle,
IBMCustomizationDataProvider {
    public static final String DEFAULT_CUSTOM_DATA = "_customization_data";
    public static final String KEY_DIMENSION_INIT_PROC = "dimension_init_proc";
    public static final String FUNCTION_ID_PATH = "${/cookie/@FUNCTION_ID/@value}";
    public static final String FUNCTION_CODE_PATH = "${/cookie/@FUNCTION_CODE/@value}";
    private IDatabaseServiceFactory databaseServiceFactory;
    private IObjectRegistry objectRegistry;
    private DataSource dataSource;
    ILogger logger;
    CompositeMap custDimensionsRecords = null;

    public BMCustomizationProvider(IDatabaseServiceFactory databaseServiceFactory, IObjectRegistry objectRegistry) {
        this.databaseServiceFactory = databaseServiceFactory;
        this.objectRegistry = objectRegistry;
    }

    @Override
    public void onPrepareBusinessModel(BusinessModel model, CompositeMap context) throws Exception {
        boolean customization_enabled = model.getCustomizationenabled();
        if (customization_enabled) {
            CompositeMap fullContext = ServiceThreadLocal.getCurrentThreadContext();
            if (fullContext == null) {
                return;
            }
            this.logger.log(Level.CONFIG, fullContext.getRoot().toXML());
            String function_code = TextParser.parse(FUNCTION_CODE_PATH, fullContext);
            if (function_code == null || "".equals(function_code)) {
                return;
            }
            CompositeMap custDetailRecords = this.getCustomizationData(model, function_code, fullContext);
            if (custDetailRecords != null) {
                LovBMCustomSourceCode.custom(model, custDetailRecords, this.objectRegistry);
            }
        }
    }

    @Override
    public CompositeMap getCustomizationData(BusinessModel model, String function_code, CompositeMap context) {
        CompositeMap result;
        ResultSet rs_details;
        ResultSet rs_exists;
        SqlServiceContext ssc;
        block29: {
            StringBuffer sb;
            block28: {
                String bm_name;
                block27: {
                    if (this.custDimensionsRecords == null || this.custDimensionsRecords.getChilds() == null) {
                        return null;
                    }
                    bm_name = model.getName();
                    ssc = null;
                    rs_exists = null;
                    rs_details = null;
                    result = new CompositeMap("result");
                    ssc = this.databaseServiceFactory.createContextWithConnection();
                    String exits_sql = "select 1   from dual  where exists  (select 1 from sys_bm_config_customization t  where t.bm_code='" + bm_name + "' and t.function_code = '" + function_code + "' and t.enable_flag='Y')";
                    ParsedSql exits_stmt = this.createStatement(exits_sql);
                    SqlRunner exits_runner = new SqlRunner(ssc, exits_stmt);
                    rs_exists = exits_runner.query(null);
                    if (rs_exists.next()) break block27;
                    DBUtil.closeResultSet(rs_exists);
                    DBUtil.closeResultSet(rs_details);
                    if (ssc != null) {
                        try {
                            ssc.freeConnection();
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return null;
                }
                String bm_tag = model.getTag();
                if (bm_tag != null) {
                    this.executeDimensionProc(bm_tag, this.custDimensionsRecords, context);
                }
                String dimenson_sql_template = "select d.order_num,record_id,head_id,function_id,function_code,bm_code,dimension_type,dimension_value, bm_select_value,bm_data_source,bm_where_clause,bm_order_by,bm_query_condition from sys_bm_config_customization t,sys_bm_config_dimension d  where t.dimension_type=d.dimension_code and t.enable_flag = 'Y' and t.bm_code='" + bm_name + "' and t.function_code = '" + function_code + "' and t.dimension_type=";
                sb = new StringBuffer("");
                boolean firstRecord = true;
                Iterator it = this.custDimensionsRecords.getChildIterator();
                while (it.hasNext()) {
                    boolean is_tag_match;
                    CompositeMap record = (CompositeMap)it.next();
                    String dimensionCode = record.getString("dimension_code");
                    String data_query_sql = record.getString("data_query_sql");
                    String dimension_tag = record.getString("dimension_tag");
                    if (dimension_tag != null && (bm_tag == null || !(is_tag_match = bm_tag.contains(dimension_tag)))) continue;
                    if (firstRecord) {
                        firstRecord = false;
                    } else {
                        sb.append(" union all ");
                    }
                    sb.append(dimenson_sql_template).append("'").append(dimensionCode).append("'");
                    if (data_query_sql == null) continue;
                    sb.append(" and ").append(data_query_sql);
                }
                if (!firstRecord) {
                    sb.append(" order by 1 ");
                }
                if (!"".equals(sb.toString())) break block28;
                DBUtil.closeResultSet(rs_exists);
                DBUtil.closeResultSet(rs_details);
                if (ssc != null) {
                    try {
                        ssc.freeConnection();
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
            try {
                String custDetailRecordsSql = sb.toString();
                this.logger.config("custDetailRecordsSql:" + custDetailRecordsSql);
                ParsedSql stmt = this.createStatement(custDetailRecordsSql);
                SqlRunner runner = new SqlRunner(ssc, stmt);
                rs_details = runner.query(context);
                ResultSetLoader mRsLoader = new ResultSetLoader();
                mRsLoader.setFieldNameCase((byte)2);
                FetchDescriptor desc = FetchDescriptor.fetchAll();
                CompositeMapCreator compositeCreator = new CompositeMapCreator(result);
                mRsLoader.loadByResultSet(rs_details, desc, compositeCreator);
                if (result.getChilds() != null) break block29;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(rs_exists);
                    DBUtil.closeResultSet(rs_details);
                    if (ssc != null) {
                        try {
                            ssc.freeConnection();
                        }
                        catch (SQLException e2) {
                            throw new RuntimeException(e2);
                        }
                    }
                    throw throwable;
                }
            }
            DBUtil.closeResultSet(rs_exists);
            DBUtil.closeResultSet(rs_details);
            if (ssc != null) {
                try {
                    ssc.freeConnection();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
        DBUtil.closeResultSet(rs_exists);
        DBUtil.closeResultSet(rs_details);
        if (ssc != null) {
            try {
                ssc.freeConnection();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        context.putObject(DEFAULT_CUSTOM_DATA, result);
        return result;
    }

    private void executeDimensionProc(String bm_tag, CompositeMap dimensionsRecords, CompositeMap context) throws Exception {
        if (dimensionsRecords == null || dimensionsRecords.getChilds() == null) {
            return;
        }
        IProcedureManager procedureManager = (IProcedureManager)this.objectRegistry.getInstanceOfType(IProcedureManager.class);
        if (procedureManager == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IProcedureManager.class);
        }
        Iterator it = dimensionsRecords.getChildIterator();
        while (it.hasNext()) {
            CompositeMap dimension = (CompositeMap)it.next();
            String dimension_init_proc = dimension.getString(KEY_DIMENSION_INIT_PROC);
            String tag = dimension.getString("dimension_tag");
            if (tag == null) continue;
            boolean is_tag_match = bm_tag.contains(tag);
            if (dimension_init_proc == null || !is_tag_match) continue;
            Procedure proc = null;
            try {
                proc = procedureManager.loadProcedure(dimension_init_proc);
            }
            catch (Exception ex) {
                throw BuiltinExceptionFactory.createResourceLoadException(context.asLocatable(), dimension_init_proc, ex);
            }
            ServiceInstance svc = ServiceInstance.getInstance(context);
            svc.invoke(proc);
        }
    }

    @Override
    public boolean startup() {
        if (!(this.databaseServiceFactory instanceof DatabaseServiceFactory)) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, DatabaseServiceFactory.class);
        }
        ((DatabaseServiceFactory)this.databaseServiceFactory).setGlobalParticipant(this);
        this.dataSource = (DataSource)this.objectRegistry.getInstanceOfType(DataSource.class);
        if (this.dataSource == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, DataSource.class);
        }
        this.logger = LoggingContext.getLogger(this.getClass().getCanonicalName(), this.objectRegistry);
        String query_dimensions_sql = " select d.dimension_code,d.data_query_sql,d.dimension_init_proc,d.dimension_tag  from sys_bm_config_dimension d where d.enabled_flag='Y' order by d.order_num ";
        this.logger.config("query_dimensions_sql:" + query_dimensions_sql);
        try {
            this.custDimensionsRecords = this.sqlQuery(query_dimensions_sql);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public void shutdown() {
    }

    private CompositeMap sqlQuery(String sql) throws Exception {
        ResultSet resultSet = null;
        SqlServiceContext sql_context = null;
        CompositeMap result = new CompositeMap("result");
        try {
            Connection conn = this.dataSource.getConnection();
            sql_context = SqlServiceContext.createSqlServiceContext(conn);
            ParsedSql stmt = this.createStatement(sql);
            SqlRunner runner = new SqlRunner(sql_context, stmt);
            resultSet = runner.query(null);
            ResultSetLoader mRsLoader = new ResultSetLoader();
            mRsLoader.setFieldNameCase((byte)2);
            FetchDescriptor desc = FetchDescriptor.fetchAll();
            CompositeMapCreator compositeCreator = new CompositeMapCreator(result);
            mRsLoader.loadByResultSet(resultSet, desc, compositeCreator);
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet(resultSet);
            if (sql_context != null) {
                sql_context.freeConnection();
            }
            throw throwable;
        }
        DBUtil.closeResultSet(resultSet);
        if (sql_context != null) {
            sql_context.freeConnection();
        }
        return result;
    }

    ParsedSql createStatement(String sql) {
        ParsedSql stmt = new ParsedSql();
        stmt.parse(sql);
        return stmt;
    }
}

