/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.script.engine;

import aurora.plugin.script.engine.AuroraScriptEngine;
import aurora.plugin.script.scriptobject.ScriptShareObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.ProcedureRunner;

public class ScriptRunner {
    private String exp;
    private CompositeMap context = null;
    private ScriptShareObject sso;
    private String optimizeLevel;

    public ScriptRunner(String script) {
        this.exp = script;
    }

    public ScriptRunner(String script, CompositeMap context) {
        this(script);
        this.context = context;
        this.sso = (ScriptShareObject)context.get((Object)"sso");
        if (this.sso == null) {
            this.sso = new ScriptShareObject();
            context.put((Object)"sso", (Object)this.sso);
        }
    }

    public ScriptRunner(String script, CompositeMap context, IObjectRegistry registry) {
        this(script, context);
        this.sso.put(registry);
    }

    public String getOriginalScript() {
        return this.exp;
    }

    public void setImport(String import1) {
        this.sso.put("import", import1);
    }

    public String getImport() {
        return (String)this.sso.get("import");
    }

    public String getParsedScript() {
        if (this.context == null) {
            return this.exp;
        }
        return TextParser.parse((String)this.exp, (CompositeMap)this.context);
    }

    public Object run() throws Exception {
        AuroraScriptEngine engine = this.sso.getEngine();
        if (engine == null) {
            engine = new AuroraScriptEngine(this.context);
            this.sso.put(engine);
        }
        String str = this.getParsedScript();
        if (this.optimizeLevel != null && this.optimizeLevel.length() > 0) {
            engine.setOptimizeLevel(Integer.parseInt(this.optimizeLevel));
        }
        return engine.eval(str);
    }

    public void setProcedureRunner(ProcedureRunner runner) {
        this.sso.put("procedure-runner", runner);
    }

    public void setOptimizeLevel(String optimizeLevel) {
        this.optimizeLevel = optimizeLevel;
    }
}

