/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.export.task;

import aurora.database.service.IDatabaseServiceFactory;
import aurora.service.IConfigurableService;
import aurora.service.IService;
import aurora.service.ServiceInstance;
import aurora.service.controller.ControllerProcedures;
import aurora.service.http.AbstractFacadeServlet;
import uncertain.composite.CompositeMap;
import uncertain.event.Configuration;
import uncertain.event.IParticipantManager;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;
import uncertain.proc.AbstractEntry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureRunner;

public class ModelExportTask
extends AbstractEntry {
    public final String PARTICIPANT_LIST_EXPORT_CATEGORY = "export";
    public final String KEY_COLUMN_CONFIG = "_column_config_";
    public final String KEY_FILE_NAME = "_file_name_";
    public final String KEY_CHARSET = "GBK";
    public final String KEY_PROMPT = "prompt";
    public final String KEY_DATA_INDEX = "name";
    public final String KEY_COLUMN = "column";
    public final String KEY_WIDTH = "width";
    public final String KEY_GENERATE_STATE = "_generate_state_task";
    public final String KEY_FORMAT = "_format";
    public final String KEY_URL = "${/parameter/@url}";
    private IObjectRegistry mObjectRegistry;
    private CompositeMap context;

    public ModelExportTask(IObjectRegistry registry, OCManager ocManager, IDatabaseServiceFactory databaseServiceFactory) {
        this.mObjectRegistry = registry;
    }

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap parsedSvcConfigNode;
        this.context = runner.getContext();
        CompositeMap parameter = this.context.getChild("parameter");
        if (parameter != null) {
            parameter.remove((Object)"_generate_state_task");
            parameter.put((Object)"_generate_state", (Object)true);
            parameter.put((Object)"enableTask", (Object)true);
        }
        if ((parsedSvcConfigNode = this.context.getChild("parsedSvcConfig")) != null && parsedSvcConfigNode.getChilds() != null) {
            CompositeMap reportProcedure = (CompositeMap)parsedSvcConfigNode.getChilds().get(0);
            ServiceInstance svc = ServiceInstance.getInstance((CompositeMap)this.context);
            svc.setServiceConfigData(reportProcedure);
            try {
                this.service();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void service() throws Exception {
        boolean is_success = true;
        IProcedureManager mProcManager = (IProcedureManager)this.mObjectRegistry.getInstanceOfType(IProcedureManager.class);
        ServiceInstance svc = ServiceInstance.getInstance((CompositeMap)this.context);
        if (is_success) {
            svc.getController().setProcedureName(ControllerProcedures.INVOKE_SERVICE);
            IParticipantManager mParticipantManager = (IParticipantManager)this.mObjectRegistry.getInstanceOfType(IParticipantManager.class);
            Configuration mServiceParentConfig = null;
            if (mParticipantManager != null) {
                mServiceParentConfig = mParticipantManager.getParticipantsAsConfig("export");
            }
            svc.setRootConfig(mServiceParentConfig);
            Procedure proc = AbstractFacadeServlet.getProcedureToRun((IProcedureManager)mProcManager, (IService)svc);
            if (proc != null) {
                ServiceInstance cfsvc;
                if (svc instanceof IConfigurableService && !(cfsvc = svc).isConfigParsed()) {
                    cfsvc.parseConfig();
                }
                this.context.put((Object)"success", (Object)true);
                svc.invoke(proc);
            }
        }
    }
}

