/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.touch;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.touch.Component;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class Ajax
extends Component {
    private static final String PROPERTITY_ID = "id";
    private static final String PROPERTITY_TYPE = "type";
    private static final String PROPERTITY_URL = "url";
    private static final String PROPERTITY_TIMEOUT = "timeout";
    private static final String PROPERTITY_ASYNC = "async";
    private static final String PROPERTITY_DATATYPE = "dataType";
    private static final String PARAMETERS = "parameters";
    private static final String EVENTS = "events";

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        CompositeMap view = context.getView();
        Map map = context.getMap();
        CompositeMap model = context.getModel();
        if (null != view.getString(PROPERTITY_ID)) {
            this.addConfig(PROPERTITY_ID, view.getString(PROPERTITY_ID));
        }
        if (null != view.getString(PROPERTITY_TYPE)) {
            this.addConfig(PROPERTITY_TYPE, view.getString(PROPERTITY_TYPE));
        }
        if (null != view.getString(PROPERTITY_URL)) {
            this.addConfig(PROPERTITY_URL, TextParser.parse(view.getString(PROPERTITY_URL), model));
        }
        if (null != view.getInt(PROPERTITY_TIMEOUT)) {
            this.addConfig(PROPERTITY_TIMEOUT, view.getInt(PROPERTITY_TIMEOUT));
        }
        if (null != view.getBoolean(PROPERTITY_ASYNC)) {
            this.addConfig(PROPERTITY_ASYNC, view.getBoolean(PROPERTITY_ASYNC));
        }
        if (null != view.getString(PROPERTITY_DATATYPE.toLowerCase())) {
            this.addConfig(PROPERTITY_DATATYPE, view.getString(PROPERTITY_DATATYPE.toLowerCase()));
        }
        this.processParameters(view, model);
        this.processEvents(view);
        map.put("config", this.getConfigString());
    }

    private void processParameters(CompositeMap parent, CompositeMap model) {
        CompositeMap parameters = parent.getChild(PARAMETERS);
        if (null != parameters) {
            Iterator childs = parameters.getChildIterator();
            HashMap<String, JSONObject> datas = new HashMap<String, JSONObject>();
            while (childs.hasNext()) {
                CompositeMap child = (CompositeMap)childs.next();
                String key = child.getString("name");
                String value = TextParser.parse(child.getString("value"), model);
                String bind = child.getString("bind");
                String dataType = child.getString("datatype");
                HashMap<String, Object> m = new HashMap<String, Object>();
                if (null != value) {
                    m.put("value", value);
                }
                if (null != bind) {
                    m.put("bind", bind);
                }
                if (null != dataType) {
                    m.put("datatype", dataType);
                    if (null != value && "java.lang.Long".equals(dataType)) {
                        m.put("value", new Long(value));
                    }
                }
                datas.put(key, new JSONObject(m));
            }
            if (!datas.isEmpty()) {
                this.addConfig(PARAMETERS, new JSONObject(datas));
            }
        }
    }

    private void processEvents(CompositeMap parent) {
        CompositeMap events = parent.getChild(EVENTS);
        if (null != events) {
            Iterator childs = events.getChildIterator();
            HashMap datas = new HashMap();
            while (childs.hasNext()) {
                CompositeMap child = (CompositeMap)childs.next();
                String key = child.getString("name");
                String handler = child.getString("handler");
                this.addConfig(key, new Component.JSONFunction(this, handler));
            }
        }
    }
}

