/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std.config;

import aurora.presentation.component.std.config.ComponentConfig;
import aurora.presentation.component.std.config.GridColumnConfig;
import uncertain.composite.CompositeMap;

public class GridConfig
extends ComponentConfig {
    public static final String TAG_NAME = "grid";
    public static final String PROPERTITY_COLUMNS = "columns";
    public static final String PROPERTITY_EDITOR = "editor";
    public static final String PROPERTITY_EDITORS = "editors";
    public static final String PROPERTITY_TOOLBAR = "toolBar";
    public static final String PROPERTITY_DATASET = "dataset";
    public static final String PROPERTITY_NAVBAR = "navbar";
    public static final String PROPERTITY_AUTO_FOCUS = "autofocus";
    public static final String PROPERTITY_AUTO_APPEND = "autoappend";
    public static final String PROPERTITY_ROW_RENDERER = "rowrenderer";
    public static final String PROPERTITY_CAN_PASTE = "canpaste";
    public static final String PROPERTITY_CAN_WHEEL = "canwheel";
    public static final String PROPERTITY_SHOW_ROWNUMBER = "showrownumber";

    public static GridConfig getInstance() {
        GridConfig model = new GridConfig();
        model.initialize(GridConfig.createContext(null, TAG_NAME));
        return model;
    }

    public static GridConfig getInstance(CompositeMap context) {
        GridConfig model = new GridConfig();
        model.initialize(GridConfig.createContext(context, TAG_NAME));
        return model;
    }

    public String getRowRenderer() {
        return this.getString(PROPERTITY_ROW_RENDERER);
    }

    public void setRowRenderer(String renderer) {
        this.putString(PROPERTITY_ROW_RENDERER, renderer);
    }

    public String getDataSet() {
        return this.getString(PROPERTITY_DATASET);
    }

    public void setDataSet(String ds) {
        this.putString(PROPERTITY_DATASET, ds);
    }

    public boolean isAutoFocus() {
        return this.getBoolean(PROPERTITY_AUTO_FOCUS, true);
    }

    public void setAutoFocus(boolean focus) {
        this.putBoolean(PROPERTITY_AUTO_FOCUS, focus);
    }

    public boolean isAutoAppend() {
        return this.getBoolean(PROPERTITY_AUTO_APPEND, true);
    }

    public void setAutoAppend(boolean append) {
        this.putBoolean(PROPERTITY_AUTO_APPEND, append);
    }

    public boolean isCanPaste() {
        return this.getBoolean(PROPERTITY_CAN_PASTE, false);
    }

    public void setCanPaste(boolean canPaste) {
        this.putBoolean(PROPERTITY_CAN_PASTE, canPaste);
    }

    public boolean isCanWheel() {
        return this.getBoolean(PROPERTITY_CAN_WHEEL, true);
    }

    public void setCanWheel(boolean canPaste) {
        this.putBoolean(PROPERTITY_CAN_WHEEL, canPaste);
    }

    public boolean hasNavBar() {
        return this.getBoolean(PROPERTITY_NAVBAR, false);
    }

    public void setNavBar(boolean nb) {
        this.putBoolean(PROPERTITY_NAVBAR, nb);
    }

    public CompositeMap getColumns() {
        CompositeMap context = this.getObjectContext();
        CompositeMap columns = context.getChild(PROPERTITY_COLUMNS);
        if (columns == null) {
            columns = new CompositeMap(PROPERTITY_COLUMNS);
            context.addChild(columns);
        }
        return columns;
    }

    public void addColumn(GridColumnConfig column) {
        CompositeMap columns = this.getColumns();
        columns.addChild(column.getObjectContext());
    }

    public CompositeMap getEditors() {
        CompositeMap context = this.getObjectContext();
        CompositeMap editors = context.getChild(PROPERTITY_EDITORS);
        if (editors == null) {
            editors = new CompositeMap(PROPERTITY_EDITORS);
            context.addChild(editors);
        }
        return editors;
    }

    public void addEditor(ComponentConfig editor) {
        CompositeMap editors = this.getEditors();
        editors.addChild(editor.getObjectContext());
    }
}

