/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std.config;

import aurora.presentation.component.std.config.ComponentConfig;
import java.util.List;
import uncertain.composite.CompositeMap;

public class FormViewConfig
extends ComponentConfig {
    public static final String TAG_NAME = "formView";
    private static final String PROPERTITY_TITLE = "title";
    private static final String PROPERTITY_FIELDS = "formSection";
    private static final String PROPERTITY_DATA_MODEL = "datamodel";
    public static final String PROPERTITY_PROMPT_ALIGN = "promptalign";
    public static final String PROPERTITY_PROMPT_WIDTH = "promptwidth";
    public static final String PROPERTITY_TABLE_STYLE = "tablestyle";
    private static final String DEFAULT_PROMPT_ALIGN = "left";
    private static final int DEFAULT_PROMPT_WIDTH = 15;

    public static FormViewConfig getInstance() {
        FormViewConfig model = new FormViewConfig();
        model.initialize(FormViewConfig.createContext(null, TAG_NAME));
        return model;
    }

    public static FormViewConfig getInstance(CompositeMap context) {
        FormViewConfig model = new FormViewConfig();
        model.initialize(FormViewConfig.createContext(context, TAG_NAME));
        return model;
    }

    public List getSections() {
        CompositeMap context = this.getObjectContext();
        List sections = context.getChildsNotNull();
        return sections;
    }

    public String getDataModel() {
        return this.getString(PROPERTITY_DATA_MODEL);
    }

    public void setDataModel(String dm) {
        this.putString(PROPERTITY_DATA_MODEL, dm);
    }

    public String getTitle() {
        return this.getString(PROPERTITY_TITLE);
    }

    public void setTitle(String title) {
        this.putString(PROPERTITY_TITLE, title);
    }

    public String getTableStyle() {
        return this.getString(PROPERTITY_TABLE_STYLE);
    }

    public void setTableStyle(String style) {
        this.putString(PROPERTITY_TABLE_STYLE, style);
    }

    public String getPromptAlign() {
        return this.getString(PROPERTITY_PROMPT_ALIGN, DEFAULT_PROMPT_ALIGN);
    }

    public void setPromptAlign(String align) {
        this.putString(PROPERTITY_PROMPT_ALIGN, align);
    }

    public int getPromptWidth() {
        return this.getInt(PROPERTITY_PROMPT_WIDTH, 15);
    }

    public void setPromptWidth(int width) {
        this.putInt(PROPERTITY_PROMPT_WIDTH, width);
    }

    public String getTitleText() {
        CompositeMap context = this.getObjectContext();
        CompositeMap title = context.getChild(PROPERTITY_TITLE);
        if (title != null) {
            return title.getText();
        }
        return null;
    }
}

