/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.sql.builder;

import aurora.database.sql.ISqlStatement;
import aurora.database.sql.InsertField;
import aurora.database.sql.InsertStatement;
import aurora.database.sql.builder.AbstractSqlBuilder;

public class DefaultInsertBuilder
extends AbstractSqlBuilder {
    public String createSql(InsertStatement statement) {
        if (statement.getInsertFields().size() == 0) {
            throw new IllegalArgumentException("No field defined in insert statement");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(this.getKeyword("INSERT"));
        sql.append(" ").append(this.getKeyword("INTO")).append(" ");
        sql.append(this.mRegistry.getSql(statement.getInsertTable()));
        sql.append(" ( ");
        StringBuffer fields = new StringBuffer();
        StringBuffer values = new StringBuffer();
        int i = 0;
        for (InsertField f : statement.getInsertFields()) {
            if (i > 0) {
                fields.append(",");
                values.append(",");
            }
            fields.append(f.getFieldName());
            values.append(this.mRegistry.getSql(f.getUpdateSource()));
            ++i;
        }
        sql.append(fields.toString()).append(") ");
        if (statement.getSelectStatement() == null) {
            sql.append(this.getKeyword("VALUES")).append(" ( ");
            sql.append(values.toString());
            sql.append(")");
        } else {
            sql.append(this.mRegistry.getSql(statement.getSelectStatement()));
        }
        return sql.toString();
    }

    @Override
    public String createSql(ISqlStatement statement) {
        if (statement instanceof InsertStatement) {
            return this.createSql((InsertStatement)statement);
        }
        return null;
    }
}

