/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.task.excel;

import java.io.File;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class ExcelRemove
extends AbstractEntry {
    public String path;

    @Override
    public void run(ProcedureRunner runner) throws Exception {
        boolean is_success;
        if (this.path == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "path");
        }
        this.path = TextParser.parse(this.path, runner.getContext());
        if (!this.path.endsWith(".xls") && !this.path.endsWith(".xlsx")) {
            throw new IllegalArgumentException("This file '" + this.path + "' is not an excel file!");
        }
        ILogger logger = LoggingContext.getLogger(runner.getContext(), this.getClass().getCanonicalName());
        File file = new File(this.path);
        if (!file.exists()) {
            logger.warning("This file '" + this.path + "' is not exist!");
        }
        if (!(is_success = file.delete())) {
            logger.warning("This file '" + this.path + "' can not be deleted!");
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

