/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.action;

import aurora.database.DBUtil;
import aurora.database.service.BusinessModelService;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import aurora.plugin.c3p0.C3P0NativeJdbcExtractor;
import aurora.presentation.component.std.IDGenerator;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import com.mchange.v2.c3p0.C3P0ProxyConnection;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.jdbc.OracleResultSet;
import oracle.sql.BLOB;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class AttachmentManager
extends AbstractEntry {
    public static final String PROPERTITY_ACTION_TYPE = "actiontype";
    public static final String PROPERTITY_SAVE_TYPE = "savetype";
    public static final String PROPERTITY_SAVE_PATH = "savepath";
    public static final String PROPERTITY_URL = "url";
    public static final String PROPERTITY_RANDOM_NAME = "random_name";
    private static final String SAVE_TYPE_DATABASE = "db";
    private static final String SAVE_TYPE_FILE = "file";
    public int Buffer_size = 512000;
    private static final String FND_UPLOAD_FILE_TYPE = "fnd.fnd_upload_file_type";
    private String saveType;
    private String savePath;
    private String actionType;
    private String useSubFolder = null;
    private String randomName = "true";
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM");
    private DatabaseServiceFactory databasefactory;

    public AttachmentManager(IObjectRegistry registry) {
        this.databasefactory = (DatabaseServiceFactory)registry.getInstanceOfType(DatabaseServiceFactory.class);
    }

    @Override
    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        String actionType = this.getActionType();
        if ("upload".equalsIgnoreCase(actionType)) {
            this.doUpload(context);
        } else if ("delete".equalsIgnoreCase(actionType)) {
            this.doDelete(context);
        } else if ("download".equalsIgnoreCase(actionType)) {
            this.doDownload(context);
            runner.stop();
            ProcedureRunner preRunner = runner;
            while (preRunner.getCaller() != null) {
                preRunner = preRunner.getCaller();
                preRunner.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDownload(CompositeMap context) throws Exception {
        ServiceContext service = ServiceContext.createServiceContext(context);
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance(context);
        CompositeMap params = service.getParameter();
        Object aid = params.getObject("@attachment_id");
        if (aid != null) {
            SqlServiceContext ssc = this.databasefactory.createContextWithConnection();
            Connection conn = ssc.getConnection();
            Statement st = conn.createStatement();
            ResultSet rs = null;
            InputStream is = null;
            OutputStream os = null;
            ReadableByteChannel rbc = null;
            WritableByteChannel wbc = null;
            try {
                rs = st.executeQuery("select file_name,file_size,mime_type, file_path, content from fnd_atm_attachment t where t.attachment_id = " + aid);
                if (!rs.next()) {
                    throw new IllegalArgumentException("attachment_id not set");
                }
                String path = rs.getString(4);
                String fileName = rs.getString(1);
                int fileSize = rs.getInt(2);
                String mimeType = rs.getString(3);
                HttpServletResponse response = serviceInstance.getResponse();
                response.setHeader("Content-Type", mimeType);
                response.setHeader("Content-disposition", "attachment;" + this.processFileName(serviceInstance.getRequest(), fileName));
                try {
                    Class.forName("org.apache.catalina.startup.Bootstrap");
                    if (fileSize > 0) {
                        response.setContentLength(fileSize);
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                if (path != null) {
                    File file = new File(path);
                    if (file.exists()) {
                        os = response.getOutputStream();
                        is = new FileInputStream(path);
                        rbc = Channels.newChannel(is);
                        wbc = Channels.newChannel(os);
                        ByteBuffer buf = ByteBuffer.allocate(this.Buffer_size);
                        int size = -1;
                        while ((size = rbc.read(buf)) > 0) {
                            buf.position(0);
                            wbc.write(buf);
                            buf.clear();
                            os.flush();
                        }
                    }
                } else {
                    Blob content = rs.getBlob(5);
                    if (content != null) {
                        os = response.getOutputStream();
                        is = content.getBinaryStream();
                        rbc = Channels.newChannel(is);
                        wbc = Channels.newChannel(os);
                        ByteBuffer buf = ByteBuffer.allocate(this.Buffer_size);
                        int size = -1;
                        while ((size = rbc.read(buf)) > 0) {
                            buf.position(0);
                            wbc.write(buf);
                            buf.clear();
                            os.flush();
                        }
                    }
                }
                response.setHeader("Connection", "close");
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
                if (ssc != null) {
                    ssc.freeConnection();
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ex) {}
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelete(CompositeMap context) throws Exception {
        ServiceContext service = ServiceContext.createServiceContext(context);
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance(context);
        CompositeMap params = service.getParameter();
        Object aid = serviceInstance.getRequest().getAttribute("attachment_id");
        if (aid == null) {
            aid = params.getObject("/parameter/record/@attachment_id");
        }
        if (aid != null && !"".equals(aid)) {
            SqlServiceContext ssc = this.databasefactory.createContextWithConnection();
            Connection conn = ssc.getConnection();
            Statement st = conn.createStatement();
            ResultSet rs = null;
            try {
                File file;
                rs = st.executeQuery("select file_path from fnd_atm_attachment t where t.attachment_id = " + aid);
                if (!rs.next()) {
                    throw new IllegalArgumentException("attachment_id not set");
                }
                String path = rs.getString(1);
                if (path != null && (file = new File(path)).exists()) {
                    file.delete();
                }
                st.execute("delete from fnd_atm_attachment at where at.attachment_id = " + aid);
                st.execute("delete from fnd_atm_attachment_multi atm where atm.attachment_id = " + aid);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
                if (ssc != null) {
                    ssc.freeConnection();
                }
            }
        }
    }

    private void doUpload(CompositeMap context) throws Exception {
        ServiceContext service = ServiceContext.createServiceContext(context);
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance(context);
        CompositeMap params = service.getParameter();
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload up = new ServletFileUpload((FileItemFactory)factory);
        List items = null;
        ArrayList<FileItem> files = new ArrayList<FileItem>();
        Connection conn = null;
        String url = null;
        try {
            items = up.parseRequest(serviceInstance.getRequest());
            for (FileItem fileItem : items) {
                if (fileItem.isFormField()) {
                    String name = fileItem.getFieldName();
                    String value = fileItem.getString("UTF-8");
                    if (PROPERTITY_URL.equalsIgnoreCase(name)) {
                        url = value;
                        continue;
                    }
                    if (PROPERTITY_ACTION_TYPE.equalsIgnoreCase(name)) {
                        this.actionType = value;
                        continue;
                    }
                    params.put(name, value);
                    if (!"attachment_id".equalsIgnoreCase(name)) continue;
                    serviceInstance.getRequest().setAttribute("attachment_id", (Object)value);
                    continue;
                }
                files.add(fileItem);
            }
            for (FileItem fileItem : files) {
                File file = new File(fileItem.getName());
                String file_name = file.getName();
                if ("".equals(file_name)) continue;
                params.put("file_name", file_name);
                params.put("file_size", new Long(fileItem.getSize()));
                BusinessModelService modelService = this.databasefactory.getModelService(FND_UPLOAD_FILE_TYPE, context);
                modelService.execute(null);
                Object aid = service.getModel().getObject("/parameter/@attachment_id");
                SqlServiceContext sqlServiceContext = SqlServiceContext.createSqlServiceContext(context);
                conn = sqlServiceContext.getConnection();
                InputStream in = fileItem.getInputStream();
                String attach_id = aid.toString();
                if (SAVE_TYPE_DATABASE.equalsIgnoreCase(this.getSaveType())) {
                    this.writeBLOB(conn, in, attach_id);
                } else if (SAVE_TYPE_FILE.equalsIgnoreCase(this.getSaveType())) {
                    this.writeFile(conn, in, attach_id, file_name);
                }
                fileItem.delete();
                params.put("success", "true");
                if (url != null) continue;
                PrintWriter out = serviceInstance.getResponse().getWriter();
                out.write(aid.toString());
                out.close();
            }
            if (url != null) {
                serviceInstance.getResponse().sendRedirect(url);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(Connection conn, InputStream instream, String aid, String fileName) throws Exception {
        if ("".equals(fileName)) {
            return;
        }
        if ("true".equals(this.getRandomName())) {
            fileName = IDGenerator.getInstance().generate();
        }
        String datePath = this.sdf.format(new Date());
        String path = this.getSavePath().replaceAll("\\\\", "/");
        if (path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        if ("true".equalsIgnoreCase(this.getUseSubFolder())) {
            path = path + datePath;
        }
        FileUtils.forceMkdir((File)new File(path));
        Statement stmt = null;
        try {
            int b;
            long size = 0L;
            File file = new File(path, fileName);
            FileOutputStream fos = new FileOutputStream(file);
            while ((b = instream.read()) >= 0) {
                fos.write(b);
                ++size;
            }
            fos.close();
            stmt = conn.createStatement();
            stmt.executeUpdate("update fnd_atm_attachment a set a.file_path = '" + file.getPath() + "' where a.attachment_id = " + aid);
        }
        catch (Throwable throwable) {
            DBUtil.closeStatement(stmt);
            throw throwable;
        }
        DBUtil.closeStatement(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeBLOB(Connection conn, InputStream instream, String aid) throws Exception {
        long l;
        BLOB blob;
        OutputStream outstream;
        ResultSet rs;
        Statement st;
        long size;
        block9: {
            Connection nativeConn = conn;
            if (conn instanceof C3P0ProxyConnection) {
                C3P0NativeJdbcExtractor nativeJdbcExtractor = new C3P0NativeJdbcExtractor();
                try {
                    nativeConn = nativeJdbcExtractor.getNativeConnection(conn);
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
            }
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            size = 0L;
            st = null;
            rs = null;
            outstream = null;
            st = nativeConn.createStatement();
            st.executeUpdate("update fnd_atm_attachment t set t.content = empty_blob() where t.attachment_id=" + aid);
            rs = st.executeQuery("select content from fnd_atm_attachment t where t.attachment_id = " + aid + " for update");
            if (!rs.next()) {
                throw new IllegalArgumentException("attachment_id not set");
            }
            blob = ((OracleResultSet)rs).getBLOB(1);
            rs.close();
            if (blob != null) break block9;
            System.out.println("Warning: can't update fnd_atm_attachment.content for recrd " + aid);
            long l2 = 0L;
            DBUtil.closeResultSet(rs);
            DBUtil.closeStatement(st);
            return l2;
        }
        try {
            int le;
            outstream = blob.getBinaryOutputStream(0L);
            int chunk = blob.getChunkSize();
            byte[] buff = new byte[chunk];
            while ((le = instream.read(buff)) != -1) {
                outstream.write(buff, 0, le);
                size += (long)le;
            }
            outstream.close();
            st.close();
            instream.close();
            l = size;
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet(rs);
            DBUtil.closeStatement(st);
            throw throwable;
        }
        DBUtil.closeResultSet(rs);
        DBUtil.closeStatement(st);
        return l;
    }

    public String getSaveType() {
        return this.saveType == null ? SAVE_TYPE_DATABASE : this.saveType;
    }

    public void setSaveType(String saveType) {
        this.saveType = saveType;
    }

    public String getSavePath() {
        return this.savePath == null ? "." : this.savePath;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public String getActionType() {
        return this.actionType == null ? "upload" : this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public String processFileName(HttpServletRequest request, String filename) throws UnsupportedEncodingException {
        String userAgent = request.getHeader("User-Agent");
        String new_filename = URLEncoder.encode(filename, "UTF8");
        String rtn = "filename=\"" + new_filename + "\"";
        if (userAgent != null) {
            if ((userAgent = userAgent.toLowerCase()).indexOf("msie") != -1) {
                rtn = "filename=\"" + new String(filename.getBytes("gb2312"), "iso-8859-1") + "\"";
            } else if (userAgent.indexOf("opera") != -1) {
                rtn = "filename*=UTF-8''" + new_filename;
            } else if (userAgent.indexOf("safari") != -1) {
                rtn = "filename=\"" + new String(filename.getBytes("UTF-8"), "ISO8859-1") + "\"";
            } else if (userAgent.indexOf("applewebkit") != -1) {
                new_filename = MimeUtility.encodeText((String)filename, (String)"UTF8", (String)"B");
                rtn = "filename=\"" + new_filename + "\"";
            } else if (userAgent.indexOf("mozilla") != -1) {
                rtn = "filename*=UTF-8''" + new_filename;
            }
        }
        return rtn;
    }

    public String getUseSubFolder() {
        return this.useSubFolder == null ? "true" : this.useSubFolder;
    }

    public void setUseSubFolder(String useSubFolder) {
        this.useSubFolder = useSubFolder;
    }

    public String getRandomName() {
        return this.randomName;
    }

    public void setRandomName(String randomName) {
        this.randomName = randomName;
    }
}

